/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.regionserver;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.regionserver.LogRollBackupSubprocedurePool;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LogRollBackupSubprocedure
extends Subprocedure {
    private static final Logger LOG = LoggerFactory.getLogger(LogRollBackupSubprocedure.class);
    private final RegionServerServices rss;
    private final LogRollBackupSubprocedurePool taskManager;
    private String backupRoot;

    public LogRollBackupSubprocedure(RegionServerServices rss, ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, LogRollBackupSubprocedurePool taskManager, byte[] data) {
        super(member, "rolllog", errorListener, wakeFrequency, timeout);
        LOG.info("Constructing a LogRollBackupSubprocedure.");
        this.rss = rss;
        this.taskManager = taskManager;
        if (data != null) {
            this.backupRoot = new String(data, StandardCharsets.UTF_8);
        }
    }

    private void rolllog() throws ForeignException {
        this.monitor.rethrowException();
        this.taskManager.submitTask(new RSRollLogTask());
        this.monitor.rethrowException();
        this.taskManager.waitForOutstandingTasks();
        this.monitor.rethrowException();
    }

    public void acquireBarrier() {
    }

    public byte[] insideBarrier() throws ForeignException {
        this.rolllog();
        return null;
    }

    public void cleanup(Exception e) {
        this.taskManager.abort("Aborting log roll subprocedure tasks for backup due to error", e);
    }

    public void releaseBarrier() {
    }

    class RSRollLogTask
    implements Callable<Void> {
        RSRollLogTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DRPC started: " + LogRollBackupSubprocedure.this.rss.getServerName());
            }
            AbstractFSWAL fsWAL = (AbstractFSWAL)LogRollBackupSubprocedure.this.rss.getWAL(null);
            long filenum = fsWAL.getFilenum();
            List wals = LogRollBackupSubprocedure.this.rss.getWALs();
            long highest = -1L;
            for (WAL wal : wals) {
                if (wal == null || ((AbstractFSWAL)wal).getFilenum() <= highest) continue;
                highest = ((AbstractFSWAL)wal).getFilenum();
            }
            LOG.info("Trying to roll log in backup subprocedure, current log number: " + filenum + " highest: " + highest + " on " + LogRollBackupSubprocedure.this.rss.getServerName());
            ((HRegionServer)LogRollBackupSubprocedure.this.rss).getWalRoller().requestRollAll();
            long start = EnvironmentEdgeManager.currentTime();
            while (!((HRegionServer)LogRollBackupSubprocedure.this.rss).getWalRoller().walRollFinished()) {
                Thread.sleep(20L);
            }
            LOG.debug("log roll took " + (EnvironmentEdgeManager.currentTime() - start));
            LOG.info("After roll log in backup subprocedure, current log number: " + fsWAL.getFilenum() + " on " + LogRollBackupSubprocedure.this.rss.getServerName());
            Connection connection = LogRollBackupSubprocedure.this.rss.getConnection();
            try (BackupSystemTable table = new BackupSystemTable(connection);){
                HashMap<String, Long> serverTimestampMap = table.readRegionServerLastLogRollResult(LogRollBackupSubprocedure.this.backupRoot);
                String host = LogRollBackupSubprocedure.this.rss.getServerName().getHostname();
                int port = LogRollBackupSubprocedure.this.rss.getServerName().getPort();
                String server = host + ":" + port;
                Long sts = serverTimestampMap.get(host);
                if (sts != null && sts > highest) {
                    LOG.warn("Won't update server's last roll log result: current=" + sts + " new=" + highest);
                    Void void_ = null;
                    return void_;
                }
                table.writeRegionServerLastLogRollResult(server, highest, LogRollBackupSubprocedure.this.backupRoot);
                Void void_ = null;
                return void_;
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
                throw e;
            }
        }
    }
}

