/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.CellSortReducer;
import org.apache.hadoop.hbase.mapreduce.HFileInputFormat;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MapReduceExtendedCell;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MapReduceHFileSplitterJob
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MapReduceHFileSplitterJob.class);
    static final String NAME = "HFileSplitterJob";
    public static final String BULK_OUTPUT_CONF_KEY = "hfile.bulk.output";
    public static final String TABLES_KEY = "hfile.input.tables";
    public static final String TABLE_MAP_KEY = "hfile.input.tablesmap";
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";

    public MapReduceHFileSplitterJob() {
    }

    protected MapReduceHFileSplitterJob(Configuration c) {
        super(c);
    }

    public Job createSubmittableJob(String[] args) throws IOException {
        Job job;
        block37: {
            Configuration conf = this.getConf();
            String inputDirs = args[0];
            String tabName = args[1];
            conf.setStrings(TABLES_KEY, new String[]{tabName});
            conf.set("mapreduce.input.fileinputformat.inputdir", inputDirs);
            job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "HFileSplitterJob_" + EnvironmentEdgeManager.currentTime()));
            job.setJarByClass(MapReduceHFileSplitterJob.class);
            job.setInputFormatClass(HFileInputFormat.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
            if (hfileOutPath != null) {
                LOG.debug("add incremental job :" + hfileOutPath + " from " + inputDirs);
                TableName tableName = TableName.valueOf((String)tabName);
                job.setMapperClass(HFileCellMapper.class);
                job.setReducerClass(CellSortReducer.class);
                Path outputDir = new Path(hfileOutPath);
                FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
                job.setMapOutputValueClass(MapReduceExtendedCell.class);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = conn.getTable(tableName);
                     RegionLocator regionLocator = conn.getRegionLocator(tableName);){
                    HFileOutputFormat2.configureIncrementalLoad((Job)job, (TableDescriptor)table.getDescriptor(), (RegionLocator)regionLocator);
                    break block37;
                }
            }
            throw new IOException("No bulk output directory specified");
        }
        LOG.debug("success configuring load incremental job");
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{Preconditions.class});
        return job;
    }

    private void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: HFileSplitterJob [options] <HFile inputdir(s)> <table>");
        System.err.println("Read all HFile's for <table> and split them to <table> region boundaries.");
        System.err.println("<table>  table to load.\n");
        System.err.println("To generate HFiles for a bulk data load, pass the option:");
        System.err.println("  -Dhfile.bulk.output=/path/for/output");
        System.err.println("Other options:");
        System.err.println("   -D mapreduce.job.name=jobName - use the specified mapreduce job name for the HFile splitter");
        System.err.println("For performance also consider the following options:\n  -Dmapreduce.map.speculative=false\n  -Dmapreduce.reduce.speculative=false");
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new MapReduceHFileSplitterJob(HBaseConfiguration.create()), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            this.usage("Wrong number of arguments: " + args.length);
            return -1;
        }
        Job job = this.createSubmittableJob(args);
        int result = job.waitForCompletion(true) ? 0 : 1;
        return result;
    }

    static class HFileCellMapper
    extends Mapper<NullWritable, Cell, ImmutableBytesWritable, Cell> {
        HFileCellMapper() {
        }

        public void map(NullWritable key, Cell value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new ImmutableBytesWritable(CellUtil.cloneRow((Cell)value)), (Object)new MapReduceExtendedCell(value));
        }

        public void setup(Mapper.Context context) throws IOException {
        }
    }
}

