/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.BindException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALCoprocessor;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.FileSystemProxy;
import org.apache.hadoop.hbase.wal.IOTestProvider;
import org.apache.hadoop.hbase.wal.NoEOFWALStreamReader;
import org.apache.hadoop.hbase.wal.SyncReplicationWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALFactory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALFactory.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALFactory.class);
    protected static Configuration conf;
    private static MiniDFSCluster cluster;
    protected static final HBaseTestingUtil TEST_UTIL;
    protected static Path hbaseDir;
    protected static Path hbaseWALDir;
    protected FileSystem fs;
    protected Path dir;
    protected WALFactory wals;
    private ServerName currentServername;
    @Rule
    public final TestName currentTest = new TestName();

    @Before
    public void setUp() throws Exception {
        this.fs = cluster.getFileSystem();
        this.dir = new Path(hbaseDir, this.currentTest.getMethodName());
        this.currentServername = ServerName.valueOf((String)this.currentTest.getMethodName(), (int)16010, (long)1L);
        this.wals = new WALFactory(conf, this.currentServername.toString());
    }

    @After
    public void tearDown() throws Exception {
        FileStatus[] entries;
        try {
            this.wals.close();
        }
        catch (IOException exception) {
            LOG.warn("Encountered exception while closing wal factory. If you have other errors, this may be the cause. Message: " + exception);
            LOG.debug("Exception details for failure to close wal factory.", (Throwable)exception);
        }
        for (FileStatus dir : entries = this.fs.listStatus(new Path("/"))) {
            this.fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CommonFSUtils.setWALRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)new Path("file:///tmp/wal"));
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.getConfiguration().setInt("hbase.lease.recovery.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.lease.recovery.dfs.timeout", 1000);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.wal.classes", SampleRegionWALCoprocessor.class.getName());
        TEST_UTIL.startMiniDFSCluster(3);
        conf = TEST_UTIL.getConfiguration();
        cluster = TEST_UTIL.getDFSCluster();
        hbaseDir = TEST_UTIL.createRootDir();
        hbaseWALDir = TEST_UTIL.createWALRootDir();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void canCloseSingleton() throws IOException {
        WALFactory.getInstance((Configuration)conf).close();
    }

    @Test
    public void testSplit() throws IOException {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        byte[] rowName = tableName.getName();
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
        int howmany = 3;
        RegionInfo[] infos = new RegionInfo[3];
        Path tableDataDir = CommonFSUtils.getTableDir((Path)hbaseDir, (TableName)tableName);
        this.fs.mkdirs(tableDataDir);
        Path tabledir = CommonFSUtils.getWALTableDir((Configuration)conf, (TableName)tableName);
        this.fs.mkdirs(tabledir);
        for (int i = 0; i < 3; ++i) {
            infos[i] = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)("" + i))).setEndKey(Bytes.toBytes((String)("" + (i + 1)))).build();
            this.fs.mkdirs(new Path(tabledir, infos[i].getEncodedName()));
            this.fs.mkdirs(new Path(tableDataDir, infos[i].getEncodedName()));
            LOG.info("allo " + new Path(tabledir, infos[i].getEncodedName()).toString());
        }
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(Bytes.toBytes((String)"column"), 0);
        for (int ii = 0; ii < 3; ++ii) {
            for (int i = 0; i < 3; ++i) {
                WAL log = this.wals.getWAL(infos[i]);
                for (int j = 0; j < 3; ++j) {
                    WALEdit edit = new WALEdit();
                    byte[] family = Bytes.toBytes((String)"column");
                    byte[] qualifier = Bytes.toBytes((String)Integer.toString(j));
                    byte[] column = Bytes.toBytes((String)("column:" + Integer.toString(j)));
                    edit.add((Cell)new KeyValue(rowName, family, qualifier, EnvironmentEdgeManager.currentTime(), column));
                    LOG.info("Region " + i + ": " + edit);
                    WALKeyImpl walKey = new WALKeyImpl(infos[i].getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes);
                    log.appendData(infos[i], walKey, edit);
                    walKey.getWriteEntry();
                }
                log.sync();
                log.rollWriter(true);
            }
        }
        this.wals.shutdown();
        Path logDir = new Path(new Path(hbaseWALDir, "WALs"), this.currentServername.toString());
        Path oldLogDir = new Path(hbaseDir, "oldWALs");
        List splits = WALSplitter.split((Path)hbaseWALDir, (Path)logDir, (Path)oldLogDir, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        this.verifySplits(splits, 3);
    }

    @Test
    public void Broken_testSync() throws Exception {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
        Path p = new Path(this.dir, this.currentTest.getMethodName() + ".fsdos");
        FSDataOutputStream out = this.fs.create(p);
        out.write(tableName.getName());
        Method syncMethod = null;
        try {
            syncMethod = out.getClass().getMethod("hflush", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                syncMethod = out.getClass().getMethod("sync", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                Assert.fail((String)"This version of Hadoop supports neither Syncable.sync() nor Syncable.hflush().");
            }
        }
        syncMethod.invoke((Object)out, new Object[0]);
        FSDataInputStream in = this.fs.open(p);
        Assert.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        byte[] buffer = new byte[1024];
        int read = in.read(buffer);
        Assert.assertEquals((long)tableName.getName().length, (long)read);
        out.close();
        in.close();
        int total = 20;
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(tableName.getName(), 0);
        WAL wal = this.wals.getWAL(info);
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
            wal.appendData(info, new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes), kvs);
        }
        wal.sync();
        Path walPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
        int count = NoEOFWALStreamReader.count(this.wals, this.fs, walPath);
        Assert.assertEquals((long)20L, (long)count);
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
            wal.appendData(info, new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes), kvs);
        }
        wal.sync();
        count = NoEOFWALStreamReader.count(this.wals, this.fs, walPath);
        Assert.assertTrue((count >= 20 ? 1 : 0) != 0);
        wal.sync();
        count = NoEOFWALStreamReader.count(this.wals, this.fs, walPath);
        Assert.assertEquals((long)40L, (long)count);
        byte[] value = new byte[0x100400];
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), value));
            wal.appendData(info, new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes), kvs);
        }
        wal.sync();
        count = NoEOFWALStreamReader.count(this.wals, this.fs, walPath);
        Assert.assertEquals((long)60L, (long)count);
        wal.shutdown();
        count = NoEOFWALStreamReader.count(this.wals, this.fs, walPath);
        Assert.assertEquals((long)60L, (long)count);
    }

    private void verifySplits(List<Path> splits, int howmany) throws IOException {
        Assert.assertEquals((long)(howmany * howmany), (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            LOG.info("Verifying=" + splits.get(i));
            try (WALStreamReader reader = this.wals.createStreamReader(this.fs, splits.get(i));){
                int count = 0;
                String previousRegion = null;
                long seqno = -1L;
                WAL.Entry entry = new WAL.Entry();
                while ((entry = reader.next(entry)) != null) {
                    WALKeyImpl key = entry.getKey();
                    String region = Bytes.toString((byte[])key.getEncodedRegionName());
                    if (previousRegion != null) {
                        Assert.assertEquals(previousRegion, (Object)region);
                    }
                    LOG.info("oldseqno=" + seqno + ", newseqno=" + key.getSequenceId());
                    Assert.assertTrue((seqno < key.getSequenceId() ? 1 : 0) != 0);
                    seqno = key.getSequenceId();
                    previousRegion = region;
                    ++count;
                }
                Assert.assertEquals((long)howmany, (long)count);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendClose() throws Exception {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        WAL wal = this.wals.getWAL(regionInfo);
        int total = 20;
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(tableName.getName(), 0);
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        for (int i = 0; i < total; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
            wal.appendData(regionInfo, new WALKeyImpl(regionInfo.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes), kvs);
        }
        wal.sync();
        int namenodePort = cluster.getNameNodePort();
        final Path walPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            TEST_UTIL.shutdownMiniDFSCluster();
            try {
                wal.shutdown();
            }
            catch (IOException e) {
                LOG.info(e.toString(), (Throwable)e);
            }
            this.fs.close();
            LOG.info("STOPPED first instance of the cluster");
        }
        finally {
            while (cluster.isClusterUp()) {
                LOG.error("Waiting for cluster to go down");
                Thread.sleep(1000L);
            }
            Assert.assertFalse((boolean)cluster.isClusterUp());
            cluster = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    cluster = TEST_UTIL.startMiniDFSClusterForTestWAL(namenodePort);
                    break;
                }
                catch (BindException e) {
                    LOG.info("Sleeping.  BindException bringing up new cluster");
                    Threads.sleep((long)1000L);
                    continue;
                }
            }
            cluster.waitActive();
            this.fs = cluster.getFileSystem();
            LOG.info("STARTED second instance.");
        }
        Method setLeasePeriod = cluster.getClass().getDeclaredMethod("setLeasePeriod", Long.TYPE, Long.TYPE);
        setLeasePeriod.setAccessible(true);
        setLeasePeriod.invoke((Object)cluster, 1000L, 1000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOG.info(e.toString(), (Throwable)e);
        }
        final FileSystem recoveredFs = this.fs;
        final Configuration rlConf = conf;
        class RecoverLogThread
        extends Thread {
            public Exception exception = null;

            RecoverLogThread() {
            }

            @Override
            public void run() {
                try {
                    RecoverLeaseFSUtils.recoverFileLease((FileSystem)recoveredFs, (Path)walPath, (Configuration)rlConf, null);
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
        RecoverLogThread t = new RecoverLogThread();
        t.start();
        t.join(60000L);
        if (t.isAlive()) {
            t.interrupt();
            throw new Exception("Timed out waiting for WAL.recoverLog()");
        }
        if (t.exception != null) {
            throw t.exception;
        }
        int count = 0;
        try (NoEOFWALStreamReader reader = NoEOFWALStreamReader.create(this.wals, this.fs, walPath);){
            WAL.Entry entry = new WAL.Entry();
            while (reader.next(entry) != null) {
                ++count;
                Assert.assertTrue((String)"Should be one KeyValue per WALEdit", (entry.getEdit().getCells().size() == 1 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)total, (long)count);
        setLeasePeriod.invoke((Object)cluster, 60000L, 3600000L);
    }

    @Test
    public void testEditAdd() throws IOException {
        int colCount = 10;
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.currentTest.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"column")).build();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        byte[] row = Bytes.toBytes((String)"row");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
        long timestamp = EnvironmentEdgeManager.currentTime();
        WALEdit cols = new WALEdit();
        for (int i = 0; i < colCount; ++i) {
            cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
        }
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(row).setEndKey(Bytes.toBytes((String)(Bytes.toString((byte[])row) + "1"))).build();
        WAL log = this.wals.getWAL(info);
        long txid = log.appendData(info, new WALKeyImpl(info.getEncodedNameAsBytes(), htd.getTableName(), EnvironmentEdgeManager.currentTime(), mvcc, scopes), cols);
        log.sync(txid);
        log.startCacheFlush(info.getEncodedNameAsBytes(), htd.getColumnFamilyNames());
        log.completeCacheFlush(info.getEncodedNameAsBytes(), -1L);
        log.shutdown();
        Path filename = AbstractFSWALProvider.getCurrentFileName((WAL)log);
        try (NoEOFWALStreamReader reader = NoEOFWALStreamReader.create(this.wals, this.fs, filename);){
            for (int i = 0; i < 1; ++i) {
                WAL.Entry entry = reader.next(null);
                if (entry == null) {
                    break;
                }
                WALKeyImpl key = entry.getKey();
                WALEdit val = entry.getEdit();
                Assert.assertTrue((boolean)Bytes.equals((byte[])info.getEncodedNameAsBytes(), (byte[])key.getEncodedRegionName()));
                Assert.assertTrue((boolean)htd.getTableName().equals((Object)key.getTableName()));
                Cell cell = (Cell)val.getCells().get(0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (int)0, (int)row.length, (byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
                Assert.assertEquals((long)((byte)(i + 48)), (long)CellUtil.cloneValue((Cell)cell)[0]);
                LOG.info(key + " " + val);
            }
        }
    }

    @Test
    public void testAppend() throws IOException {
        int colCount = 10;
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.currentTest.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"column")).build();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        byte[] row = Bytes.toBytes((String)"row");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
        long timestamp = EnvironmentEdgeManager.currentTime();
        WALEdit cols = new WALEdit();
        for (int i = 0; i < colCount; ++i) {
            cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
        }
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        WAL log = this.wals.getWAL(hri);
        long txid = log.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), htd.getTableName(), EnvironmentEdgeManager.currentTime(), mvcc, scopes), cols);
        log.sync(txid);
        log.startCacheFlush(hri.getEncodedNameAsBytes(), htd.getColumnFamilyNames());
        log.completeCacheFlush(hri.getEncodedNameAsBytes(), -1L);
        log.shutdown();
        Path filename = AbstractFSWALProvider.getCurrentFileName((WAL)log);
        try (WALStreamReader reader = this.wals.createStreamReader(this.fs, filename);){
            WAL.Entry entry = reader.next();
            Assert.assertEquals((long)colCount, (long)entry.getEdit().size());
            int idx = 0;
            for (Cell val : entry.getEdit().getCells()) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName()));
                Assert.assertTrue((boolean)htd.getTableName().equals((Object)entry.getKey().getTableName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (int)0, (int)row.length, (byte[])val.getRowArray(), (int)val.getRowOffset(), (int)val.getRowLength()));
                Assert.assertEquals((long)((byte)(idx + 48)), (long)CellUtil.cloneValue((Cell)val)[0]);
                System.out.println(entry.getKey() + " " + val);
                ++idx;
            }
        }
    }

    @Test
    public void testVisitors() throws Exception {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        byte[] row = Bytes.toBytes((String)"row");
        DumbWALActionsListener visitor = new DumbWALActionsListener();
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
        long timestamp = EnvironmentEdgeManager.currentTime();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(Bytes.toBytes((String)"column"), 0);
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        WAL log = this.wals.getWAL(hri);
        log.registerWALActionsListener((WALActionsListener)visitor);
        for (int i = 0; i < 10; ++i) {
            WALEdit cols = new WALEdit();
            cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            log.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes), cols);
        }
        log.sync();
        Assert.assertEquals((long)10L, (long)visitor.increments);
        log.unregisterWALActionsListener((WALActionsListener)visitor);
        WALEdit cols = new WALEdit();
        cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(11)), timestamp, new byte[]{59}));
        log.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), mvcc, scopes), cols);
        log.sync();
        Assert.assertEquals((long)10L, (long)visitor.increments);
    }

    @Test
    public void testWALCoprocessorLoaded() throws Exception {
        WALCoprocessorHost host = this.wals.getWAL(null).getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(SampleRegionWALCoprocessor.class);
        Assert.assertNotNull((Object)c);
    }

    @Test
    public void testWALProviders() throws IOException {
        Configuration conf = new Configuration();
        WALFactory walFactory = new WALFactory(conf, this.currentServername.toString());
        Assert.assertEquals(SyncReplicationWALProvider.class, walFactory.getWALProvider().getClass());
        WALProvider wrappedWALProvider = ((SyncReplicationWALProvider)walFactory.getWALProvider()).getWrappedProvider();
        Assert.assertEquals(wrappedWALProvider.getClass(), walFactory.getMetaProvider().getClass());
        walFactory = new WALFactory(conf, this.currentServername, null, false);
        Assert.assertEquals(walFactory.getWALProvider().getClass(), walFactory.getMetaProvider().getClass());
    }

    @Test
    public void testOnlySetWALProvider() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbase.wal.provider", WALFactory.Providers.multiwal.name());
        WALFactory walFactory = new WALFactory(conf, this.currentServername.toString());
        WALProvider wrappedWALProvider = ((SyncReplicationWALProvider)walFactory.getWALProvider()).getWrappedProvider();
        Assert.assertEquals(SyncReplicationWALProvider.class, walFactory.getWALProvider().getClass());
        Assert.assertEquals((Object)WALFactory.Providers.multiwal.clazz, wrappedWALProvider.getClass());
        Assert.assertEquals((Object)WALFactory.Providers.multiwal.clazz, walFactory.getMetaProvider().getClass());
    }

    @Test
    public void testOnlySetMetaWALProvider() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbase.wal.meta_provider", WALFactory.Providers.asyncfs.name());
        WALFactory walFactory = new WALFactory(conf, this.currentServername.toString());
        WALProvider wrappedWALProvider = ((SyncReplicationWALProvider)walFactory.getWALProvider()).getWrappedProvider();
        Assert.assertEquals(SyncReplicationWALProvider.class, walFactory.getWALProvider().getClass());
        Assert.assertEquals((Object)WALFactory.Providers.defaultProvider.clazz, wrappedWALProvider.getClass());
        Assert.assertEquals((Object)WALFactory.Providers.asyncfs.clazz, walFactory.getMetaProvider().getClass());
    }

    @Test
    public void testDefaultProvider() throws IOException {
        Configuration conf = new Configuration();
        WALFactory normalWalFactory = new WALFactory(conf, this.currentServername.toString());
        Class fshLogProvider = normalWalFactory.getProviderClass("hbase.wal.provider", WALFactory.Providers.filesystem.name());
        Assert.assertEquals((Object)WALFactory.Providers.filesystem.clazz, (Object)fshLogProvider);
        WALFactory customizedWalFactory = new WALFactory(conf, this.currentServername.toString()){

            WALFactory.Providers getDefaultProvider() {
                return WALFactory.Providers.multiwal;
            }
        };
        Class multiwalProviderClass = customizedWalFactory.getProviderClass("hbase.wal.provider", WALFactory.Providers.multiwal.name());
        Assert.assertEquals((Object)WALFactory.Providers.multiwal.clazz, (Object)multiwalProviderClass);
    }

    @Test
    public void testCustomProvider() throws IOException {
        Configuration config = new Configuration();
        config.set("hbase.wal.provider", IOTestProvider.class.getName());
        WALFactory walFactory = new WALFactory(config, this.currentServername.toString());
        Class walProvider = walFactory.getProviderClass("hbase.wal.provider", WALFactory.Providers.filesystem.name());
        Assert.assertEquals(IOTestProvider.class, (Object)walProvider);
        WALProvider metaWALProvider = walFactory.getMetaProvider();
        Assert.assertEquals(IOTestProvider.class, metaWALProvider.getClass());
    }

    @Test
    public void testCustomMetaProvider() throws IOException {
        Configuration config = new Configuration();
        config.set("hbase.wal.meta_provider", IOTestProvider.class.getName());
        WALFactory walFactory = new WALFactory(config, this.currentServername.toString());
        Class walProvider = walFactory.getProviderClass("hbase.wal.provider", WALFactory.Providers.filesystem.name());
        Assert.assertEquals((Object)WALFactory.Providers.filesystem.clazz, (Object)walProvider);
        WALProvider metaWALProvider = walFactory.getMetaProvider();
        Assert.assertEquals(IOTestProvider.class, metaWALProvider.getClass());
    }

    @Test
    public void testCustomReplicationProvider() throws IOException {
        Configuration config = new Configuration();
        config.set("hbase.wal.replication_provider", IOTestProvider.class.getName());
        WALFactory walFactory = new WALFactory(config, this.currentServername.toString());
        Class walProvider = walFactory.getProviderClass("hbase.wal.provider", WALFactory.Providers.filesystem.name());
        Assert.assertEquals((Object)WALFactory.Providers.filesystem.clazz, (Object)walProvider);
        WALProvider replicationWALProvider = walFactory.getReplicationProvider();
        Assert.assertEquals(IOTestProvider.class, replicationWALProvider.getClass());
    }

    @Test
    public void testDifferentWALs() throws IOException {
        WAL normalWAL = this.wals.getWAL(null);
        WAL metaWAL = this.wals.getWAL(RegionInfoBuilder.FIRST_META_REGIONINFO);
        WAL replicationWAL = this.wals.getWAL(RegionInfoBuilder.newBuilder((TableName)ReplicationStorageFactory.REPLICATION_QUEUE_TABLE_NAME_DEFAULT).build());
        Assert.assertNotSame((Object)normalWAL, (Object)metaWAL);
        Assert.assertNotSame((Object)normalWAL, (Object)replicationWAL);
        Assert.assertNotSame((Object)metaWAL, (Object)replicationWAL);
    }

    @Test
    public void testReaderClosedOnBadCodec() throws IOException {
        Configuration confWithCodec = new Configuration(conf);
        confWithCodec.setClass("hbase.regionserver.wal.codec", BrokenWALCellCodec.class, Codec.class);
        WALFactory customFactory = new WALFactory(confWithCodec, this.currentServername.toString());
        final ArrayList openedReaders = new ArrayList();
        FileSystemProxy proxyFs = new FileSystemProxy(this.fs){

            @Override
            public FSDataInputStream open(Path p) throws IOException {
                InputStreamProxy is = new InputStreamProxy((InputStream)super.open(p));
                openedReaders.add(is);
                return is;
            }

            @Override
            public FSDataInputStream open(Path p, int blockSize) throws IOException {
                InputStreamProxy is = new InputStreamProxy((InputStream)super.open(p, blockSize));
                openedReaders.add(is);
                return is;
            }
        };
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.currentTest.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"column")).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        byte[] row = Bytes.toBytes((String)"row");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
        WALEdit cols = new WALEdit();
        cols.add((Cell)new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)"0"), EnvironmentEdgeManager.currentTime(), new byte[]{0}));
        WAL log = customFactory.getWAL(hri);
        long txid = log.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), htd.getTableName(), EnvironmentEdgeManager.currentTime(), mvcc, scopes), cols);
        log.sync(txid);
        log.startCacheFlush(hri.getEncodedNameAsBytes(), htd.getColumnFamilyNames());
        log.completeCacheFlush(hri.getEncodedNameAsBytes(), -1L);
        log.shutdown();
        BrokenWALCellCodec.THROW_FAILURE_ON_INIT.set(true);
        Path filename = AbstractFSWALProvider.getCurrentFileName((WAL)log);
        Assert.assertThrows((String)"Expected to see an exception when creating WAL reader", IOException.class, () -> customFactory.createStreamReader((FileSystem)proxyFs, filename));
        Assert.assertEquals((long)1L, (long)openedReaders.size());
        long unclosedReaders = openedReaders.stream().filter(r -> !((InputStreamProxy)r).isClosed.get()).collect(Collectors.counting());
        Assert.assertEquals((String)"Should not find any open readers", (long)0L, (long)unclosedReaders);
    }

    static {
        TEST_UTIL = new HBaseTestingUtil();
    }

    private static class BrokenWALCellCodec
    extends WALCellCodec {
        static final AtomicBoolean THROW_FAILURE_ON_INIT = new AtomicBoolean(false);

        static void maybeInjectFailure() {
            if (THROW_FAILURE_ON_INIT.get()) {
                throw new RuntimeException("Injected instantiation exception");
            }
        }

        public BrokenWALCellCodec() {
            BrokenWALCellCodec.maybeInjectFailure();
        }

        public BrokenWALCellCodec(Configuration conf, CompressionContext compression) {
            super(conf, compression);
            BrokenWALCellCodec.maybeInjectFailure();
        }
    }

    private static class InputStreamProxy
    extends FSDataInputStream {
        private final InputStream real;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        public InputStreamProxy(InputStream real) {
            super(real);
            this.real = real;
        }

        public void close() throws IOException {
            this.isClosed.set(true);
            this.real.close();
        }
    }

    static class DumbWALActionsListener
    implements WALActionsListener {
        int increments = 0;

        DumbWALActionsListener() {
        }

        public void visitLogEntryBeforeWrite(RegionInfo info, WALKey logKey, WALEdit logEdit) {
            ++this.increments;
        }
    }
}

