/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.DualAsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogTestHelper;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerInfoProvider;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.SyncReplicationWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSyncReplicationWALProvider {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationWALProvider.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static String PEER_ID = "1";
    private static String REMOTE_WAL_DIR = "/RemoteWAL";
    private static TableName TABLE = TableName.valueOf((String)"table");
    private static TableName TABLE_NO_REP = TableName.valueOf((String)"table-no-rep");
    private static RegionInfo REGION = RegionInfoBuilder.newBuilder((TableName)TABLE).build();
    private static RegionInfo REGION_NO_REP = RegionInfoBuilder.newBuilder((TableName)TABLE_NO_REP).build();
    private static WALFactory FACTORY;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniDFSCluster(3);
        FACTORY = new WALFactory(UTIL.getConfiguration(), "test");
        ((SyncReplicationWALProvider)FACTORY.getWALProvider()).setPeerInfoProvider((SyncReplicationPeerInfoProvider)new InfoProvider());
        UTIL.getTestFileSystem().mkdirs(new Path(REMOTE_WAL_DIR, PEER_ID));
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        FACTORY.close();
        UTIL.shutdownMiniDFSCluster();
    }

    private void testReadWrite(DualAsyncFSWAL wal) throws Exception {
        int recordCount = 100;
        int columnCount = 10;
        byte[] row = Bytes.toBytes((String)"testRow");
        long timestamp = EnvironmentEdgeManager.currentTime();
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        ProtobufLogTestHelper.doWrite((WAL)wal, REGION, TABLE, columnCount, recordCount, row, timestamp, mvcc);
        final Path localFile = wal.getCurrentFileName();
        final Path remoteFile = new Path(REMOTE_WAL_DIR + "/" + PEER_ID, localFile.getName());
        try (ProtobufWALStreamReader reader = (ProtobufWALStreamReader)FACTORY.createStreamReader(UTIL.getTestFileSystem(), localFile);){
            ProtobufLogTestHelper.doRead(reader, false, REGION, TABLE, columnCount, recordCount, row, timestamp);
        }
        reader = (ProtobufWALStreamReader)FACTORY.createStreamReader(UTIL.getTestFileSystem(), remoteFile);
        var11_10 = null;
        try {
            ProtobufLogTestHelper.doRead(reader, false, REGION, TABLE, columnCount, recordCount, row, timestamp);
        }
        catch (Throwable throwable) {
            var11_10 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var11_10 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var11_10.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        wal.rollWriter();
        final DistributedFileSystem dfs = UTIL.getDFSCluster().getFileSystem();
        UTIL.waitFor(5000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return dfs.isFileClosed(localFile) && dfs.isFileClosed(remoteFile);
            }

            public String explainFailure() throws Exception {
                StringBuilder sb = new StringBuilder();
                if (!dfs.isFileClosed(localFile)) {
                    sb.append(localFile + " has not been closed yet.");
                }
                if (!dfs.isFileClosed(remoteFile)) {
                    sb.append(remoteFile + " has not been closed yet.");
                }
                return sb.toString();
            }
        });
        try (ProtobufWALStreamReader reader = (ProtobufWALStreamReader)FACTORY.createStreamReader(UTIL.getTestFileSystem(), localFile);){
            ProtobufLogTestHelper.doRead(reader, true, REGION, TABLE, columnCount, recordCount, row, timestamp);
        }
        reader = (ProtobufWALStreamReader)FACTORY.createStreamReader(UTIL.getTestFileSystem(), remoteFile);
        var12_15 = null;
        try {
            ProtobufLogTestHelper.doRead(reader, true, REGION, TABLE, columnCount, recordCount, row, timestamp);
        }
        catch (Throwable throwable) {
            var12_15 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var12_15 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var12_15.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void test() throws Exception {
        WAL walNoRep = FACTORY.getWAL(REGION_NO_REP);
        MatcherAssert.assertThat((Object)walNoRep, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DualAsyncFSWAL.class)));
        DualAsyncFSWAL wal = (DualAsyncFSWAL)FACTORY.getWAL(REGION);
        Assert.assertEquals((long)2L, (long)FACTORY.getWALs().size());
        this.testReadWrite(wal);
        SyncReplicationWALProvider walProvider = (SyncReplicationWALProvider)FACTORY.getWALProvider();
        walProvider.peerSyncReplicationStateChange(PEER_ID, SyncReplicationState.ACTIVE, SyncReplicationState.DOWNGRADE_ACTIVE, 1);
        Assert.assertEquals((long)1L, (long)FACTORY.getWALs().size());
    }

    public static final class InfoProvider
    implements SyncReplicationPeerInfoProvider {
        public Optional<Pair<String, String>> getPeerIdAndRemoteWALDir(TableName table) {
            if (table != null && table.equals((Object)TABLE)) {
                return Optional.of(Pair.newPair((Object)PEER_ID, (Object)REMOTE_WAL_DIR));
            }
            return Optional.empty();
        }

        public boolean checkState(TableName table, BiPredicate<SyncReplicationState, SyncReplicationState> checker) {
            return false;
        }
    }
}

