/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.hfile.TestHFile;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.BaseTestHBaseFsck;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore
@Category(value={MiscTests.class, MediumTests.class})
public class TestHBaseFsckMOB
extends BaseTestHBaseFsck {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseFsckMOB.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", BaseTestHBaseFsck.MasterSyncCoprocessor.class.getName());
        conf.setInt("hbase.regionserver.handler.count", 2);
        conf.setInt("hbase.regionserver.metahandler.count", 30);
        conf.setInt("hbase.htable.threads.max", 7);
        conf.setInt("hbase.hconnection.threads.max", 14);
        conf.setInt("hbase.hbck.close.timeout", 1600);
        conf.setInt("hbase.rpc.timeout", 6400);
        TEST_UTIL.startMiniCluster(1);
        tableExecutorService = new ThreadPoolExecutor(1, 7, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("testhbck-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        hbfsckExecutorService = new ScheduledThreadPoolExecutor(7);
        AssignmentManager assignmentManager = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        regionStates = assignmentManager.getRegionStates();
        connection = TEST_UTIL.getConnection();
        admin = connection.getAdmin();
        admin.balancerSwitch(false, true);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        tableExecutorService.shutdown();
        hbfsckExecutorService.shutdown();
        admin.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        EnvironmentEdgeManager.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuarantineCorruptMobFile() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupMobTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path mobFile = this.getFlushedMobFile(fs, table);
            admin.disableTable(table);
            String corruptMobFile = this.createMobFileName(mobFile.getName());
            Path corrupt = new Path(mobFile.getParent(), corruptMobFile);
            TestHFile.truncateFile(fs, mobFile, corrupt);
            LOG.info("Created corrupted mob file " + corrupt);
            HBaseFsck.debugLsr((Configuration)conf, (Path)CommonFSUtils.getRootDir((Configuration)conf));
            HBaseFsck.debugLsr((Configuration)conf, (Path)MobUtils.getMobHome((Configuration)conf));
            admin.enableTable(table);
            HBaseFsck res = HbckTestingUtil.doHFileQuarantine(conf, table);
            Assert.assertEquals((long)0L, (long)res.getRetCode());
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)4L, (long)hfcc.getHFilesChecked());
            Assert.assertEquals((long)0L, (long)hfcc.getCorrupted().size());
            Assert.assertEquals((long)0L, (long)hfcc.getFailures().size());
            Assert.assertEquals((long)0L, (long)hfcc.getQuarantined().size());
            Assert.assertEquals((long)0L, (long)hfcc.getMissing().size());
            Assert.assertEquals((long)5L, (long)hfcc.getMobFilesChecked());
            Assert.assertEquals((long)1L, (long)hfcc.getCorruptedMobFiles().size());
            Assert.assertEquals((long)0L, (long)hfcc.getFailureMobFiles().size());
            Assert.assertEquals((long)1L, (long)hfcc.getQuarantinedMobFiles().size());
            Assert.assertEquals((long)0L, (long)hfcc.getMissedMobFiles().size());
            String quarantinedMobFile = ((Path)hfcc.getQuarantinedMobFiles().iterator().next()).getName();
            Assert.assertEquals((Object)corruptMobFile, (Object)quarantinedMobFile);
        }
        finally {
            this.cleanupTable(table);
        }
    }
}

