/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AuthManager;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestZKPermissionWatcher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKPermissionWatcher.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestZKPermissionWatcher.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static AuthManager AUTH_A;
    private static AuthManager AUTH_B;
    private static ZKPermissionWatcher WATCHER_A;
    private static ZKPermissionWatcher WATCHER_B;
    private static final Abortable ABORTABLE;
    private static TableName TEST_TABLE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        UTIL.startMiniCluster();
        AUTH_A = new AuthManager(conf);
        AUTH_B = new AuthManager(conf);
        WATCHER_A = new ZKPermissionWatcher(new ZKWatcher(conf, "TestZKPermissionsWatcher_1", ABORTABLE), AUTH_A, conf);
        WATCHER_B = new ZKPermissionWatcher(new ZKWatcher(conf, "TestZKPermissionsWatcher_2", ABORTABLE), AUTH_B, conf);
        WATCHER_A.start();
        WATCHER_B.start();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        WATCHER_A.close();
        WATCHER_B.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPermissionsWatcher() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        User george = User.createUserForTesting((Configuration)conf, (String)"george", (String[])new String[0]);
        User hubert = User.createUserForTesting((Configuration)conf, (String)"hubert", (String[])new String[0]);
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(george, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(george, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(george, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(george, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.WRITE));
        ArrayList<UserPermission> acl = new ArrayList<UserPermission>(1);
        acl.add(new UserPermission(george.getShortName(), Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build()));
        ArrayListMultimap multimap = ArrayListMultimap.create();
        multimap.putAll((Object)george.getShortName(), acl);
        byte[] serialized = PermissionStorage.writePermissionsAsBytes((ListMultimap)multimap, (Configuration)conf);
        WATCHER_A.writeToZookeeper(TEST_TABLE.getName(), serialized);
        final long mtimeB = AUTH_B.getMTime();
        UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return AUTH_B.getMTime() > mtimeB;
            }
        });
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)AUTH_A.authorizeUserTable(george, TEST_TABLE, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_A.authorizeUserTable(george, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUserTable(george, TEST_TABLE, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_B.authorizeUserTable(george, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.WRITE));
        ArrayList<UserPermission> acl2 = new ArrayList<UserPermission>(1);
        acl2.add(new UserPermission(hubert.getShortName(), Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build()));
        final long mtimeA = AUTH_A.getMTime();
        multimap.putAll((Object)hubert.getShortName(), acl2);
        byte[] serialized2 = PermissionStorage.writePermissionsAsBytes((ListMultimap)multimap, (Configuration)conf);
        WATCHER_B.writeToZookeeper(TEST_TABLE.getName(), serialized2);
        UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return AUTH_A.getMTime() > mtimeA;
            }
        });
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)AUTH_A.authorizeUserTable(george, TEST_TABLE, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_A.authorizeUserTable(george, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUserTable(george, TEST_TABLE, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_B.authorizeUserTable(george, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_A.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUserTable(hubert, TEST_TABLE, Permission.Action.WRITE));
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            public void abort(String why, Throwable e) {
                LOG.info(why, e);
                this.abort.set(true);
            }

            public boolean isAborted() {
                return this.abort.get();
            }
        };
        TEST_TABLE = TableName.valueOf((String)"perms_test");
    }
}

