/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestUpdateRSGroupConfiguration
extends TestRSGroupsBase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestUpdateRSGroupConfiguration.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUpdateRSGroupConfiguration.class);
    private static final String TEST_GROUP = "test";
    private static final String TEST2_GROUP = "test2";

    @BeforeClass
    public static void setUp() throws Exception {
        TestUpdateRSGroupConfiguration.setUpConfigurationFiles(TEST_UTIL);
        TestUpdateRSGroupConfiguration.setUpTestBeforeClass();
        TestUpdateRSGroupConfiguration.addResourceToRegionServerConfiguration(TEST_UTIL);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestUpdateRSGroupConfiguration.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testNonexistentRSGroup() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> ADMIN.updateConfiguration(TEST2_GROUP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomOnlineConfigChangeInRSGroup() throws Exception {
        RSGroupInfo testRSGroup = this.addGroup(TEST_GROUP, 1);
        RSGroupInfo test2RSGroup = this.addGroup(TEST2_GROUP, 1);
        TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().forEach(thread -> {
            Configuration conf = thread.getRegionServer().getConfiguration();
            Assert.assertEquals((long)0L, (long)conf.getInt("hbase.custom.config", 0));
        });
        this.replaceHBaseSiteXML();
        try {
            ADMIN.updateConfiguration(TEST_GROUP);
            Address testServerAddr = (Address)Iterables.getOnlyElement((Iterable)testRSGroup.getServers());
            LOG.info("Check hbase.custom.config for " + testServerAddr);
            Configuration testRsConf = TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).filter(rs -> rs.getServerName().getAddress().equals((Object)testServerAddr)).findFirst().get().getConfiguration();
            Assert.assertEquals((long)1000L, (long)testRsConf.getInt("hbase.custom.config", 0));
            Address test2ServerAddr = (Address)Iterables.getOnlyElement((Iterable)test2RSGroup.getServers());
            LOG.info("Check hbase.custom.config for " + test2ServerAddr);
            Configuration test2RsConf = TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).filter(rs -> rs.getServerName().getAddress().equals((Object)test2ServerAddr)).findFirst().get().getConfiguration();
            Assert.assertEquals((long)0L, (long)test2RsConf.getInt("hbase.custom.config", 0));
        }
        finally {
            this.restoreHBaseSiteXML();
        }
    }
}

