/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestRSGroupsFallback
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsFallback.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsFallback.class);
    private static final String FALLBACK_GROUP = "fallback";

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.rsgroup.fallback.enable", true);
        conf.setInt("hbase.balancer.max.balancing", 0);
        TestRSGroupsFallback.setUpTestBeforeClass();
        MASTER.balanceSwitch(true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsFallback.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testFallback() throws Exception {
        this.addGroup(FALLBACK_GROUP, 1);
        String groupName = this.getGroupName(this.name.getMethodName());
        this.addGroup(groupName, 1);
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f")).build()).setRegionServerGroup(groupName).build();
        ADMIN.createTable(desc, HBaseTestingUtil.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.waitUntilAllRegionsAssigned(this.tableName);
        this.crashRsInGroup(groupName);
        this.assertRegionsInGroup(this.tableName, "default");
        this.crashRsInGroup("default");
        this.assertRegionsInGroup(this.tableName, FALLBACK_GROUP);
        TEST_UTIL.getMiniHBaseCluster().startRegionServerAndWait(60000L);
        Assert.assertTrue((boolean)MASTER.balance().isBalancerRan());
        this.assertRegionsInGroup(this.tableName, "default");
        JVMClusterUtil.RegionServerThread t = TEST_UTIL.getMiniHBaseCluster().startRegionServerAndWait(60000L);
        ADMIN.moveServersToRSGroup(Collections.singleton(t.getRegionServer().getServerName().getAddress()), groupName);
        Assert.assertTrue((boolean)MASTER.balance().isBalancerRan());
        this.assertRegionsInGroup(this.tableName, groupName);
        TEST_UTIL.deleteTable(this.tableName);
    }

    private void assertRegionsInGroup(TableName table, String group) throws IOException {
        ProcedureTestingUtility.waitAllProcedures((ProcedureExecutor)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor());
        RSGroupInfo rsGroup = ADMIN.getRSGroup(group);
        MASTER.getAssignmentManager().getRegionStates().getRegionsOfTable(table).forEach(region -> {
            Address regionOnServer = ((ServerName)MASTER.getAssignmentManager().getRegionStates().getRegionAssignments().get(region)).getAddress();
            Assert.assertTrue((boolean)rsGroup.getServers().contains(regionOnServer));
        });
    }

    private void crashRsInGroup(String groupName) throws Exception {
        for (Address server : ADMIN.getRSGroup(groupName).getServers()) {
            AssignmentTestingUtil.crashRs(TEST_UTIL, this.getServerName(server), true);
        }
        Threads.sleep((long)1000L);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
    }
}

