/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestRSGroupsAdmin1
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsAdmin1.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsAdmin1.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsAdmin1.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsAdmin1.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testValidGroupNames() throws IOException {
        String[] badNames = new String[]{"foo*", "foo@", "-"};
        String[] goodNames = new String[]{"foo_123"};
        for (String entry : badNames) {
            try {
                ADMIN.addRSGroup(entry);
                Assert.fail((String)("Expected a constraint exception for: " + entry));
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
        for (String entry : goodNames) {
            ADMIN.addRSGroup(entry);
        }
    }

    @Test
    public void testBogusArgs() throws Exception {
        Assert.assertNull((Object)ADMIN.getRSGroup(TableName.valueOf((String)"nonexistent")));
        Assert.assertNull((Object)ADMIN.getRSGroup(Address.fromParts((String)"bogus", (int)123)));
        Assert.assertNull((Object)ADMIN.getRSGroup("bogus"));
        try {
            ADMIN.removeRSGroup("bogus");
            Assert.fail((String)"Expected removing bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{TableName.valueOf((String)"bogustable")}), "bogus");
            Assert.fail((String)"Expected set table to bogus group fail");
        }
        catch (TableNotFoundException | ConstraintException throwable) {
            // empty catch block
        }
        try {
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{Address.fromParts((String)"bogus", (int)123)}), "bogus");
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            ADMIN.balancerSwitch(true, true);
            ADMIN.balanceRSGroup("bogus");
            ADMIN.balancerSwitch(false, true);
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testNamespaceConstraint() throws Exception {
        String nsName = "Group_foo";
        String groupName = "Group_foo";
        LOG.info("testNamespaceConstraint");
        this.addGroup(groupName, 1);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.OBSERVER.preAddRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.OBSERVER.postAddRSGroupCalled);
        ADMIN.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        RSGroupInfo rsGroupInfo = ADMIN.getRSGroup(groupName);
        ADMIN.moveServersToRSGroup(rsGroupInfo.getServers(), "default");
        try {
            ADMIN.removeRSGroup(groupName);
            Assert.fail((String)"Expected a constraint exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ADMIN.modifyNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        String anotherGroup = "Group_anotherGroup";
        ADMIN.addRSGroup(anotherGroup);
        ADMIN.deleteNamespace(nsName);
        ADMIN.removeRSGroup(groupName);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.OBSERVER.preRemoveRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.OBSERVER.postRemoveRSGroupCalled);
        try {
            ADMIN.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", "foo").build());
            Assert.fail((String)"Expected a constraint exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testNamespaceConstraint2() throws Exception {
        String nsName = "Group" + this.name.getMethodName();
        String groupName = "Group" + this.name.getMethodName();
        TableName tableName = TableName.valueOf((String)nsName, (String)this.name.getMethodName());
        this.addGroup(groupName, 1);
        ADMIN.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        TEST_UTIL.createTable(tableName, "C");
        TEST_UTIL.waitTableAvailable(tableName);
        RSGroupInfo rsGroup = ADMIN.getRSGroup(tableName);
        Assert.assertEquals((Object)groupName, (Object)rsGroup.getName());
        TEST_UTIL.deleteTable(tableName);
        ADMIN.deleteNamespace(nsName);
        ADMIN.moveServersToRSGroup(rsGroup.getServers(), "default");
        ADMIN.removeRSGroup(groupName);
    }

    @Test
    public void testFailRemoveGroup() throws IOException, InterruptedException {
        int initNumGroups = ADMIN.listRSGroups().size();
        this.addGroup("bar", 3);
        TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f"));
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), "bar");
        RSGroupInfo barGroup = ADMIN.getRSGroup("bar");
        try {
            ADMIN.removeRSGroup(barGroup.getName());
            Assert.fail((String)"Expected remove group to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ADMIN.moveServersToRSGroup(barGroup.getServers(), "default");
            Assert.fail((String)"Expected move servers to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ADMIN.setRSGroup((Set)Sets.newHashSet((Iterable)ADMIN.listTablesInRSGroup("bar")), "default");
        try {
            ADMIN.removeRSGroup(barGroup.getName());
            Assert.fail((String)"Expected move servers to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ADMIN.moveServersToRSGroup(barGroup.getServers(), "default");
        ADMIN.removeRSGroup(barGroup.getName());
        Assert.assertEquals((long)initNumGroups, (long)ADMIN.listRSGroups().size());
    }

    @Test
    public void testMultiTableMove() throws Exception {
        final TableName tableNameA = TableName.valueOf((String)("Group" + TestRSGroupsAdmin1.getNameWithoutIndex(this.name.getMethodName()) + "A"));
        final TableName tableNameB = TableName.valueOf((String)("Group" + TestRSGroupsAdmin1.getNameWithoutIndex(this.name.getMethodName()) + "B"));
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName(TestRSGroupsAdmin1.getNameWithoutIndex(this.name.getMethodName()));
        RSGroupInfo newGroup = this.addGroup(newGroupName, 1);
        TEST_UTIL.createTable(tableNameA, familyNameBytes);
        TEST_UTIL.createTable(tableNameB, familyNameBytes);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regionsA = TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameA);
                if (regionsA == null) {
                    return false;
                }
                List<String> regionsB = TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameB);
                if (regionsB == null) {
                    return false;
                }
                return TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameA).size() >= 1 && TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameB).size() >= 1;
            }
        });
        RSGroupInfo tableGrpA = ADMIN.getRSGroup(tableNameA);
        Assert.assertTrue((boolean)tableGrpA.getName().equals("default"));
        RSGroupInfo tableGrpB = ADMIN.getRSGroup(tableNameB);
        Assert.assertTrue((boolean)tableGrpB.getName().equals("default"));
        LOG.info("Moving table [" + tableNameA + "," + tableNameB + "] to " + newGroup.getName());
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{tableNameA, tableNameB}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)ADMIN.getRSGroup(tableNameA).getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)ADMIN.getRSGroup(tableNameB).getName());
        HashSet defaultTables = Sets.newHashSet((Iterable)ADMIN.listTablesInRSGroup("default"));
        Assert.assertFalse((boolean)defaultTables.contains(tableNameA));
        Assert.assertFalse((boolean)defaultTables.contains(tableNameB));
        HashSet newGroupTables = Sets.newHashSet((Iterable)ADMIN.listTablesInRSGroup(newGroupName));
        Assert.assertTrue((boolean)newGroupTables.contains(tableNameA));
        Assert.assertTrue((boolean)newGroupTables.contains(tableNameB));
    }

    @Test
    public void testTableMoveTruncateAndDrop() throws Exception {
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName(TestRSGroupsAdmin1.getNameWithoutIndex(this.name.getMethodName()));
        final RSGroupInfo newGroup = this.addGroup(newGroupName, 2);
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin1.this.getTableRegionMap().get(TestRSGroupsAdmin1.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin1.this.getTableRegionMap().get(TestRSGroupsAdmin1.this.tableName).size() >= 5;
            }
        });
        RSGroupInfo tableGrp = ADMIN.getRSGroup(this.tableName);
        LOG.info("got table group info is {}", (Object)tableGrp);
        Assert.assertTrue((boolean)tableGrp.getName().equals("default"));
        LOG.info("Moving table " + this.tableName + " to " + newGroup.getName());
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)ADMIN.getRSGroup(this.tableName).getName());
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> serverMap = TestRSGroupsAdmin1.this.getTableServerRegionMap().get(TestRSGroupsAdmin1.this.tableName);
                int count = 0;
                if (serverMap != null) {
                    for (ServerName rs : serverMap.keySet()) {
                        if (!newGroup.containsServer(rs.getAddress())) continue;
                        count += serverMap.get(rs).size();
                    }
                }
                return count == 5;
            }
        });
        ADMIN.disableTable(this.tableName);
        ADMIN.truncateTable(this.tableName, true);
        List tablesInGroup = ADMIN.listTablesInRSGroup(newGroup.getName());
        Assert.assertEquals((long)1L, (long)tablesInGroup.size());
        Assert.assertEquals((Object)this.tableName, tablesInGroup.get(0));
        TEST_UTIL.deleteTable(this.tableName);
        Assert.assertEquals((long)0L, (long)ADMIN.listTablesInRSGroup(newGroup.getName()).size());
    }

    @Test
    public void testDisabledTableMove() throws Exception {
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName(TestRSGroupsAdmin1.getNameWithoutIndex(this.name.getMethodName()));
        RSGroupInfo newGroup = this.addGroup(newGroupName, 2);
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin1.this.getTableRegionMap().get(TestRSGroupsAdmin1.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin1.this.getTableRegionMap().get(TestRSGroupsAdmin1.this.tableName).size() >= 5;
            }
        });
        RSGroupInfo tableGrp = ADMIN.getRSGroup(this.tableName);
        Assert.assertTrue((boolean)tableGrp.getName().equals("default"));
        ADMIN.disableTable(this.tableName);
        LOG.info("Moving table " + this.tableName + " to " + newGroup.getName());
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)ADMIN.getRSGroup(this.tableName).getName());
    }

    @Test
    public void testNonExistentTableMove() throws Exception {
        TableName tableName = TableName.valueOf((String)("Group" + TestRSGroupsAdmin1.getNameWithoutIndex(this.name.getMethodName())));
        RSGroupInfo tableGrp = ADMIN.getRSGroup(tableName);
        Assert.assertNull((Object)tableGrp);
        boolean exist = ADMIN.tableExists(tableName);
        Assert.assertFalse((boolean)exist);
        LOG.info("Moving table " + tableName + " to " + "default");
        try {
            ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            Assert.fail((String)("Table " + tableName + " shouldn't have been successfully moved."));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex instanceof TableNotFoundException));
        }
        try {
            ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{Address.fromParts((String)"bogus", (int)123)}), "default");
            Assert.fail((String)("Table " + tableName + " shouldn't have been successfully moved."));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex instanceof TableNotFoundException));
        }
        Assert.assertNull((Object)ADMIN.getRSGroup(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSGroupListDoesNotContainFailedTableCreation() throws Exception {
        this.toggleQuotaCheckAndRestartMiniCluster(true);
        String nsp = "np1";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "5").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertEquals((long)3L, (long)ADMIN.listNamespaceDescriptors().length);
        ColumnFamilyDescriptor fam1 = ColumnFamilyDescriptorBuilder.of((String)"fam1");
        TableDescriptor tableDescOne = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table1"))).setColumnFamily(fam1).build();
        ADMIN.createTable(tableDescOne);
        TableDescriptor tableDescTwo = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table2"))).setColumnFamily(fam1).build();
        boolean constraintViolated = false;
        try {
            ADMIN.createTable(tableDescTwo, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 6);
            Assert.fail((String)"Creation table should fail because of quota violation.");
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof IOException));
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((String)("Constraint not violated for table " + tableDescTwo.getTableName()), (boolean)constraintViolated);
        }
        List rsGroupInfoList = ADMIN.listRSGroups();
        boolean foundTable2 = false;
        boolean foundTable1 = false;
        for (int i = 0; i < rsGroupInfoList.size(); ++i) {
            HashSet tables = Sets.newHashSet((Iterable)ADMIN.listTablesInRSGroup(((RSGroupInfo)rsGroupInfoList.get(i)).getName()));
            if (tables.contains(tableDescTwo.getTableName())) {
                foundTable2 = true;
            }
            if (!tables.contains(tableDescOne.getTableName())) continue;
            foundTable1 = true;
        }
        Assert.assertFalse((String)"Found table2 in rsgroup list.", (boolean)foundTable2);
        Assert.assertTrue((String)"Did not find table1 in rsgroup list", (boolean)foundTable1);
        TEST_UTIL.deleteTable(tableDescOne.getTableName());
        ADMIN.deleteNamespace(nspDesc.getName());
        this.toggleQuotaCheckAndRestartMiniCluster(false);
    }

    @Test
    public void testNotMoveTableToNullRSGroupWhenCreatingExistingTable() throws Exception {
        TableName tn1 = TableName.valueOf((String)"t1");
        TEST_UTIL.createTable(tn1, "cf1");
        try {
            TEST_UTIL.createTable(tn1, "cf1");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
        TEST_UTIL.waitFor(5000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.MASTER.getMasterProcedureExecutor().getActiveExecutorCount() == 0;
            }
        });
        HashSet tables = Sets.newHashSet((Iterable)ADMIN.listTablesInRSGroup("default"));
        Assert.assertTrue((String)"Table 't1' must be in 'default' rsgroup", (boolean)tables.contains(tn1));
        TEST_UTIL.deleteTable(tn1);
    }

    @Test
    public void testRenameRSGroup() throws Exception {
        RSGroupInfo oldgroup = this.addGroup("oldgroup", 2);
        TableName tb1 = TableName.valueOf((String)"testRename");
        TEST_UTIL.createTable(tb1, "tr");
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{tb1}), oldgroup.getName());
        TEST_UTIL.waitFor(1000L, () -> ADMIN.getRSGroup(tb1).getServers().size() == 2);
        oldgroup = ADMIN.getRSGroup(oldgroup.getName());
        Assert.assertEquals((long)2L, (long)oldgroup.getServers().size());
        Assert.assertEquals((Object)oldgroup.getName(), (Object)ADMIN.getRSGroup(tb1).getName());
        RSGroupInfo normal = this.addGroup("normal", 1);
        TableName tb2 = TableName.valueOf((String)"unmovedTable");
        TEST_UTIL.createTable(tb2, "ut");
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{tb2}), normal.getName());
        TEST_UTIL.waitFor(1000L, () -> ADMIN.getRSGroup(tb2).getServers().size() == 1);
        normal = ADMIN.getRSGroup(normal.getName());
        Assert.assertEquals((long)1L, (long)normal.getServers().size());
        Assert.assertEquals((Object)normal.getName(), (Object)ADMIN.getRSGroup(tb2).getName());
        ADMIN.renameRSGroup(oldgroup.getName(), "newgroup");
        Set servers = oldgroup.getServers();
        RSGroupInfo newgroup = ADMIN.getRSGroup("newgroup");
        Assert.assertEquals((long)servers.size(), (long)newgroup.getServers().size());
        int match = 0;
        for (Address addr : newgroup.getServers()) {
            if (!servers.contains(addr)) continue;
            ++match;
        }
        Assert.assertEquals((long)servers.size(), (long)match);
        Assert.assertEquals((Object)newgroup.getName(), (Object)ADMIN.getRSGroup(tb1).getName());
        Assert.assertEquals((Object)normal.getName(), (Object)ADMIN.getRSGroup(tb2).getName());
    }

    @Test
    public void testRenameRSGroupConstraints() throws Exception {
        String oldGroupName = "oldGroup";
        RSGroupInfo oldGroup = this.addGroup(oldGroupName, 2);
        oldGroup = ADMIN.getRSGroup(oldGroup.getName());
        Assert.assertNotNull((Object)oldGroup);
        Assert.assertEquals((long)2L, (long)oldGroup.getServers().size());
        String anotherRSGroupName = "anotherRSGroup";
        RSGroupInfo anotherGroup = this.addGroup(anotherRSGroupName, 1);
        anotherGroup = ADMIN.getRSGroup(anotherGroup.getName());
        Assert.assertNotNull((Object)anotherGroup);
        Assert.assertEquals((long)1L, (long)anotherGroup.getServers().size());
        try {
            ADMIN.renameRSGroup("nonExistingRSGroup", "newRSGroup1");
            Assert.fail((String)"ConstraintException was expected.");
        }
        catch (ConstraintException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("does not exist"));
        }
        try {
            ADMIN.renameRSGroup(oldGroup.getName(), anotherRSGroupName);
            Assert.fail((String)"ConstraintException was expected.");
        }
        catch (ConstraintException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Group already exists"));
        }
        try {
            ADMIN.renameRSGroup("default", "newRSGroup2");
            Assert.fail((String)"ConstraintException was expected.");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
        try {
            ADMIN.renameRSGroup(oldGroup.getName(), "default");
            Assert.fail((String)"ConstraintException was expected.");
        }
        catch (ConstraintException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Group already exists"));
        }
    }

    @Test
    public void testTableConstraint() throws Exception {
        String prefix = this.name.getMethodName();
        String ns = prefix + "_ns";
        TableName tableName = TableName.valueOf((String)(ns + ":t"));
        String nsGroup = prefix + "_nsg";
        String tableGroup = prefix + "_tg";
        this.addGroup(nsGroup, 1);
        this.addGroup(tableGroup, 1);
        ADMIN.createNamespace(NamespaceDescriptor.create((String)ns).build());
        TEST_UTIL.createTable(tableName, "C");
        TEST_UTIL.waitTableAvailable(tableName);
        Assert.assertEquals((Object)ADMIN.getRSGroup(tableName).getName(), (Object)"default");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)ADMIN.getDescriptor(tableName)).setRegionServerGroup(tableGroup).build();
        ADMIN.modifyTable(td);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        Assert.assertEquals((Object)ADMIN.getRSGroup(tableName).getName(), (Object)tableGroup);
        NamespaceDescriptor nd = NamespaceDescriptor.create((NamespaceDescriptor)ADMIN.getNamespaceDescriptor(ns)).addConfiguration("hbase.rsgroup.name", nsGroup).build();
        ADMIN.modifyNamespace(nd);
        Assert.assertEquals((Object)ADMIN.getRSGroup(tableName).getName(), (Object)tableGroup);
        td = TableDescriptorBuilder.newBuilder((TableDescriptor)ADMIN.getDescriptor(tableName)).setRegionServerGroup(null).build();
        ADMIN.modifyTable(td);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        Assert.assertEquals((Object)ADMIN.getRSGroup(tableName).getName(), (Object)nsGroup);
        TEST_UTIL.deleteTable(tableName);
        ADMIN.deleteNamespace(ns);
    }
}

