/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestRSGroupConfig
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupConfig.class);
    @Rule
    public TestName name = new TestName();
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupConfig.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestRSGroupsBase.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestRSGroupsBase.tearDownAfterClass();
    }

    @Test
    public void testSetDefaultGroupConfiguration() {
        Assert.assertThrows(ConstraintException.class, () -> this.testSetConfiguration("default"));
    }

    @Test
    public void testSetNonDefaultGroupConfiguration() throws Exception {
        String group = "Group" + this.name.getMethodName();
        ADMIN.addRSGroup(group);
        this.testSetConfiguration(group);
        ADMIN.removeRSGroup(group);
    }

    private void testSetConfiguration(String group) throws Exception {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("aaa", "111");
        configuration.put("bbb", "222");
        ADMIN.updateRSGroupConfig(group, configuration);
        RSGroupInfo rsGroup = ADMIN.getRSGroup(group);
        Assert.assertEquals(configuration, (Object)rsGroup.getConfiguration());
        ADMIN.updateRSGroupConfig(group, null);
        rsGroup = ADMIN.getRSGroup(group);
        Map configFromGroup = rsGroup.getConfiguration();
        Assert.assertEquals((long)0L, (long)configFromGroup.size());
    }
}

