/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.replication.DummyReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationSourceManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSourceManager.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Configuration CONF;
    private static FileSystem FS;
    private static final byte[] F1;
    private static final byte[] F2;
    private static final TableName TABLE_NAME;
    private static RegionInfo RI;
    private static NavigableMap<byte[], Integer> SCOPES;
    @Rule
    public final TestName name = new TestName();
    private Path oldLogDir;
    private Path logDir;
    private Path remoteLogDir;
    private Server server;
    private Replication replication;
    private ReplicationSourceManager manager;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
        FS = UTIL.getTestFileSystem();
        CONF = new Configuration(UTIL.getConfiguration());
        CONF.setLong("replication.sleep.before.failover", 0L);
        RI = RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build();
        SCOPES = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        SCOPES.put(F1, 1);
        SCOPES.put(F2, 0);
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        Path rootDir = UTIL.getDataTestDirOnTestFS(this.name.getMethodName());
        CommonFSUtils.setRootDir((Configuration)CONF, (Path)rootDir);
        this.server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)this.server.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)this.server.getZooKeeper()).thenReturn((Object)UTIL.getZooKeeperWatcher());
        Mockito.when((Object)this.server.getConnection()).thenReturn((Object)UTIL.getConnection());
        ServerName sn = ServerName.valueOf((String)"hostname.example.org", (int)1234, (long)1L);
        Mockito.when((Object)this.server.getServerName()).thenReturn((Object)sn);
        this.oldLogDir = new Path(rootDir, "oldWALs");
        FS.mkdirs(this.oldLogDir);
        this.logDir = new Path(rootDir, "WALs");
        FS.mkdirs(this.logDir);
        this.remoteLogDir = new Path(rootDir, "remoteWALs");
        FS.mkdirs(this.remoteLogDir);
        TableName tableName = TableName.valueOf((String)("replication_" + this.name.getMethodName()));
        UTIL.getAdmin().createTable(ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName));
        CONF.set("hbase.replication.queue.table.name", tableName.getNameAsString());
        this.replication = new Replication();
        this.replication.initialize(this.server, FS, new Path(this.logDir, sn.toString()), this.oldLogDir, new WALFactory(CONF, this.server.getServerName(), null, false));
        this.manager = this.replication.getReplicationManager();
    }

    @After
    public void tearDown() {
        this.replication.stopReplicationService();
    }

    private void addPeerAndWait(String peerId, String clusterKey, boolean syncRep) throws ReplicationException, IOException {
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getZkCluster().getAddress().toString() + ":/" + clusterKey).setReplicationEndpointImpl(ReplicationEndpointForTest.class.getName());
        if (syncRep) {
            builder.setTableCFsMap((Map)ImmutableMap.of((Object)TABLE_NAME, Collections.emptyList())).setRemoteWALDir(FS.makeQualified(this.remoteLogDir).toString());
        }
        this.manager.getReplicationPeers().getPeerStorage().addPeer(peerId, builder.build(), true, syncRep ? SyncReplicationState.DOWNGRADE_ACTIVE : SyncReplicationState.NONE);
        this.manager.addPeer(peerId);
        UTIL.waitFor(20000L, () -> {
            ReplicationSourceInterface rs = this.manager.getSource(peerId);
            return rs != null && rs.isSourceActive();
        });
    }

    private void removePeerAndWait(String peerId) throws Exception {
        ReplicationPeers rp = this.manager.getReplicationPeers();
        rp.getPeerStorage().removePeer(peerId);
        this.manager.removePeer(peerId);
        UTIL.waitFor(20000L, () -> {
            if (rp.getPeer(peerId) != null) {
                return false;
            }
            if (this.manager.getSource(peerId) != null) {
                return false;
            }
            return this.manager.getOldSources().stream().noneMatch(rs -> rs.getPeerId().equals(peerId));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWALFile(Path file) throws Exception {
        try (ProtobufLogWriter writer = new ProtobufLogWriter();){
            writer.init(FS, file, CONF, false, FS.getDefaultBlockSize(file), null);
            WALKeyImpl key = new WALKeyImpl(RI.getEncodedNameAsBytes(), TABLE_NAME, EnvironmentEdgeManager.currentTime(), SCOPES);
            WALEdit edit = new WALEdit();
            edit.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(F1).setFamily(F1).setQualifier(F1).setType(Cell.Type.Put).setValue(F1).build());
            edit.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(F2).setFamily(F2).setQualifier(F2).setType(Cell.Type.Put).setValue(F2).build());
            writer.append(new WAL.Entry(key, edit));
            writer.sync(false);
        }
    }

    @Test
    public void testClaimQueue() throws Exception {
        String peerId = "1";
        this.addPeerAndWait(peerId, "error", false);
        ServerName serverName = ServerName.valueOf((String)"hostname0.example.org", (int)12345, (long)123L);
        String walName1 = serverName.toString() + ".1";
        this.createWALFile(new Path(this.oldLogDir, walName1));
        ReplicationQueueId queueId = new ReplicationQueueId(serverName, peerId);
        ReplicationQueueStorage queueStorage = this.manager.getQueueStorage();
        queueStorage.setOffset(queueId, "", new ReplicationGroupOffset(peerId, 0L), Collections.emptyMap());
        this.manager.claimQueue(queueId);
        MatcherAssert.assertThat((Object)this.manager.getOldSources(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testSameWALPrefix() throws IOException {
        String walName1 = "localhost,8080,12345-45678-Peer.34567";
        String walName2 = "localhost,8080,12345.56789";
        this.manager.postLogRoll(new Path(walName1));
        this.manager.postLogRoll(new Path(walName2));
        Set latestWals = this.manager.getLastestPath().stream().map(Path::getName).collect(Collectors.toSet());
        MatcherAssert.assertThat(latestWals, (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)2)).and(Matchers.hasItems((Object[])new String[]{walName1, walName2})));
    }

    private MetricsReplicationSourceSource getGlobalSource() {
        return ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getGlobalSource();
    }

    @Test
    public void testRemovePeerMetricsCleanup() throws Exception {
        MetricsReplicationSourceSource globalSource = this.getGlobalSource();
        int globalLogQueueSizeInitial = globalSource.getSizeOfLogQueue();
        String peerId = "DummyPeer";
        this.addPeerAndWait(peerId, "hbase", false);
        Assert.assertEquals((long)globalLogQueueSizeInitial, (long)globalSource.getSizeOfLogQueue());
        ReplicationSourceInterface source = this.manager.getSource(peerId);
        Assert.assertNotNull((Object)source);
        int sizeOfSingleLogQueue = source.getSourceMetrics().getSizeOfLogQueue();
        Path serverLogDir = new Path(this.logDir, this.server.getServerName().toString());
        source.enqueueLog(new Path(serverLogDir, this.server.getServerName() + ".1"));
        Assert.assertEquals((long)(1 + sizeOfSingleLogQueue), (long)source.getSourceMetrics().getSizeOfLogQueue());
        Assert.assertEquals((long)(source.getSourceMetrics().getSizeOfLogQueue() + globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
        this.removePeerAndWait(peerId);
        Assert.assertEquals((long)globalLogQueueSizeInitial, (long)globalSource.getSizeOfLogQueue());
        this.addPeerAndWait(peerId, "hbase", false);
        source = this.manager.getSource(peerId);
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((long)(source.getSourceMetrics().getSizeOfLogQueue() + globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisablePeerMetricsCleanup() throws Exception {
        String peerId = "DummyPeer";
        try {
            MetricsReplicationSourceSource globalSource = this.getGlobalSource();
            int globalLogQueueSizeInitial = globalSource.getSizeOfLogQueue();
            this.addPeerAndWait("DummyPeer", "hbase", false);
            Assert.assertEquals((long)globalLogQueueSizeInitial, (long)globalSource.getSizeOfLogQueue());
            ReplicationSourceInterface source = this.manager.getSource("DummyPeer");
            Assert.assertNotNull((Object)source);
            int sizeOfSingleLogQueue = source.getSourceMetrics().getSizeOfLogQueue();
            Path serverLogDir = new Path(this.logDir, this.server.getServerName().toString());
            source.enqueueLog(new Path(serverLogDir, this.server.getServerName() + ".1"));
            Assert.assertEquals((long)(1 + sizeOfSingleLogQueue), (long)source.getSourceMetrics().getSizeOfLogQueue());
            Assert.assertEquals((long)(source.getSourceMetrics().getSizeOfLogQueue() + globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
            this.manager.refreshSources("DummyPeer");
            Assert.assertEquals((long)globalLogQueueSizeInitial, (long)globalSource.getSizeOfLogQueue());
            source = this.manager.getSource("DummyPeer");
            Assert.assertNotNull((Object)source);
            Assert.assertEquals((long)sizeOfSingleLogQueue, (long)source.getSourceMetrics().getSizeOfLogQueue());
            Assert.assertEquals((long)(source.getSourceMetrics().getSizeOfLogQueue() + globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
        }
        finally {
            this.removePeerAndWait("DummyPeer");
        }
    }

    @Test
    public void testRemoveRemoteWALs() throws Exception {
        String peerId = "2";
        this.addPeerAndWait(peerId, "hbase", true);
        String walNameNotExists = "remoteWAL-12345-" + peerId + ".12345" + ".syncrep";
        Path wal = new Path(this.logDir, walNameNotExists);
        this.manager.postLogRoll(wal);
        Path remoteLogDirForPeer = new Path(this.remoteLogDir, peerId);
        FS.mkdirs(remoteLogDirForPeer);
        String walName = "remoteWAL-12345-" + peerId + ".23456" + ".syncrep";
        Path remoteWAL = new Path(remoteLogDirForPeer, walName).makeQualified(FS.getUri(), FS.getWorkingDirectory());
        FS.create(remoteWAL).close();
        wal = new Path(this.logDir, walName);
        this.manager.postLogRoll(wal);
        ReplicationSourceInterface source = this.manager.getSource(peerId);
        this.manager.cleanOldLogs(walName, true, source);
        Assert.assertFalse((boolean)FS.exists(remoteWAL));
    }

    static {
        F1 = Bytes.toBytes((String)"f1");
        F2 = Bytes.toBytes((String)"f2");
        TABLE_NAME = TableName.valueOf((String)"test");
    }

    public static final class ReplicationEndpointForTest
    extends DummyReplicationEndpoint {
        private String clusterKey;

        @Override
        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            if (this.clusterKey.endsWith("error")) {
                throw new RuntimeException("Inject error");
            }
            return true;
        }

        public void init(ReplicationEndpoint.Context context) throws IOException {
            super.init(context);
            this.clusterKey = context.getReplicationPeer().getPeerConfig().getClusterKey();
        }
    }
}

