/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.HBaseInterClusterReplicationEndpoint;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactoryImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceShipper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationSource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSource.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSource.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final HBaseTestingUtil TEST_UTIL_PEER = new HBaseTestingUtil();
    private static FileSystem FS;
    private static Path oldLogDir;
    private static Path logDir;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniDFSCluster(1);
        FS = TEST_UTIL.getDFSCluster().getFileSystem();
        Path rootDir = TEST_UTIL.createRootDir();
        oldLogDir = new Path(rootDir, "oldWALs");
        if (FS.exists(oldLogDir)) {
            FS.delete(oldLogDir, true);
        }
        if (FS.exists(logDir = new Path(rootDir, "WALs"))) {
            FS.delete(logDir, true);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL_PEER.shutdownMiniHBaseCluster();
        TEST_UTIL.shutdownMiniHBaseCluster();
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultSkipsMetaWAL() throws IOException {
        ReplicationSource rs = new ReplicationSource();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)mockPeer.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockPeer.getPeerBandwidth()).thenReturn((Object)0L);
        ReplicationPeerConfig peerConfig = (ReplicationPeerConfig)Mockito.mock(ReplicationPeerConfig.class);
        Mockito.when((Object)peerConfig.getReplicationEndpointImpl()).thenReturn((Object)DoNothingReplicationEndpoint.class.getName());
        Mockito.when((Object)mockPeer.getPeerConfig()).thenReturn((Object)peerConfig);
        ReplicationSourceManager manager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)manager.getGlobalMetrics()).thenReturn(Mockito.mock(MetricsReplicationGlobalSourceSource.class));
        RegionServerServices rss = TEST_UTIL.createMockRegionServerService(ServerName.parseServerName((String)"a.b.c,1,1"));
        ReplicationQueueId queueId = new ReplicationQueueId(rss.getServerName(), "qid");
        rs.init(conf, null, manager, null, mockPeer, (Server)rss, new ReplicationQueueData(queueId, ImmutableMap.of()), null, p -> OptionalLong.empty(), new MetricsSource(queueId.toString()));
        try {
            rs.startup();
            Assert.assertTrue((boolean)rs.isSourceActive());
            Assert.assertEquals((long)0L, (long)rs.getSourceMetrics().getSizeOfLogQueue());
            rs.enqueueLog(new Path("a.1.meta"));
            Assert.assertEquals((long)0L, (long)rs.getSourceMetrics().getSizeOfLogQueue());
            rs.enqueueLog(new Path("a.1"));
            Assert.assertEquals((long)1L, (long)rs.getSourceMetrics().getSizeOfLogQueue());
        }
        finally {
            rs.terminate("Done");
            rss.stop("Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALEntryFilter() throws IOException {
        ReplicationSource rs = new ReplicationSource();
        UUID uuid = UUID.randomUUID();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)mockPeer.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockPeer.getPeerBandwidth()).thenReturn((Object)0L);
        ReplicationPeerConfig peerConfig = (ReplicationPeerConfig)Mockito.mock(ReplicationPeerConfig.class);
        Mockito.when((Object)peerConfig.getReplicationEndpointImpl()).thenReturn((Object)DoNothingReplicationEndpoint.class.getName());
        Mockito.when((Object)mockPeer.getPeerConfig()).thenReturn((Object)peerConfig);
        ReplicationSourceManager manager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        RegionServerServices rss = TEST_UTIL.createMockRegionServerService(ServerName.parseServerName((String)"a.b.c,1,1"));
        ReplicationQueueId queueId = new ReplicationQueueId(rss.getServerName(), "qid");
        rs.init(conf, null, manager, null, mockPeer, (Server)rss, new ReplicationQueueData(queueId, ImmutableMap.of()), uuid, p -> OptionalLong.empty(), new MetricsSource(queueId.toString()));
        try {
            rs.startup();
            TEST_UTIL.waitFor(30000L, () -> rs.getWalEntryFilter() != null);
            WALEntryFilter wef = rs.getWalEntryFilter();
            WALEdit we = new WALEdit().add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(HConstants.EMPTY_START_ROW).setFamily(HConstants.CATALOG_FAMILY).setType(Cell.Type.Put).build());
            WAL.Entry e = new WAL.Entry(new WALKeyImpl(HConstants.EMPTY_BYTE_ARRAY, TableName.valueOf((String)"test"), -1L, -1L, uuid), we);
            Assert.assertTrue((wef.filter(e) == e ? 1 : 0) != 0);
            e = new WAL.Entry(new WALKeyImpl(HConstants.EMPTY_BYTE_ARRAY, TableName.META_TABLE_NAME, -1L, -1L, uuid), we);
            Assert.assertNull((Object)wef.filter(e));
        }
        finally {
            rs.terminate("Done");
            rss.stop("Done");
        }
    }

    @Test
    public void testLogMoving() throws Exception {
        Path logPath = new Path(logDir, "log");
        if (!FS.exists(logDir)) {
            FS.mkdirs(logDir);
        }
        if (!FS.exists(oldLogDir)) {
            FS.mkdirs(oldLogDir);
        }
        WALProvider.Writer writer = WALFactory.createWALWriter((FileSystem)FS, (Path)logPath, (Configuration)TEST_UTIL.getConfiguration());
        for (int i = 0; i < 3; ++i) {
            byte[] b = Bytes.toBytes((String)Integer.toString(i));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add((Cell)kv);
            WALKeyImpl key = new WALKeyImpl(b, TableName.valueOf((byte[])b), 0L, 0L, HConstants.DEFAULT_CLUSTER_ID);
            writer.append(new WAL.Entry(key, edit));
            writer.sync(false);
        }
        writer.close();
        WALStreamReader reader = WALFactory.createStreamReader((FileSystem)FS, (Path)logPath, (Configuration)TEST_UTIL.getConfiguration());
        WAL.Entry entry = reader.next();
        Assert.assertNotNull((Object)entry);
        Path oldLogPath = new Path(oldLogDir, "log");
        FS.rename(logPath, oldLogPath);
        entry = reader.next();
        Assert.assertNotNull((Object)entry);
        reader.next();
        entry = reader.next();
        Assert.assertNull((Object)entry);
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTerminateTimeout() throws Exception {
        ReplicationSource source = new ReplicationSource();
        DoNothingReplicationEndpoint replicationEndpoint = new DoNothingReplicationEndpoint();
        try {
            replicationEndpoint.start();
            ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
            Mockito.when((Object)mockPeer.getPeerBandwidth()).thenReturn((Object)0L);
            Configuration testConf = HBaseConfiguration.create();
            testConf.setInt("replication.source.maxretriesmultiplier", 1);
            ReplicationSourceManager manager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
            ReplicationQueueId queueId = new ReplicationQueueId(ServerName.valueOf((String)"test,123,123"), "testPeer");
            source.init(testConf, null, manager, null, mockPeer, null, new ReplicationQueueData(queueId, ImmutableMap.of()), null, p -> OptionalLong.empty(), null);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<?> future = executor.submit(() -> source.terminate("testing source termination"));
            long sleepForRetries = testConf.getLong("replication.source.sleepforretries", 1000L);
            Waiter.waitFor((Configuration)testConf, (long)(sleepForRetries * 2L), future::isDone);
        }
        finally {
            replicationEndpoint.stop();
        }
    }

    @Test
    public void testTerminateClearsBuffer() throws Exception {
        ReplicationSource source = new ReplicationSource();
        ReplicationSourceManager mockManager = new ReplicationSourceManager(null, null, conf, null, null, null, null, null, null, null, (MetricsReplicationGlobalSourceSource)Mockito.mock(MetricsReplicationGlobalSourceSource.class));
        ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)mockPeer.getPeerBandwidth()).thenReturn((Object)0L);
        Configuration testConf = HBaseConfiguration.create();
        ReplicationQueueId queueId = new ReplicationQueueId(ServerName.valueOf((String)"test,123,123"), "testPeer");
        source.init(testConf, null, mockManager, null, mockPeer, (Server)Mockito.mock(Server.class), new ReplicationQueueData(queueId, ImmutableMap.of()), null, p -> OptionalLong.empty(), (MetricsSource)Mockito.mock(MetricsSource.class));
        ReplicationSourceWALReader reader = new ReplicationSourceWALReader(null, conf, null, 0L, null, source, null);
        ReplicationSourceShipper shipper = new ReplicationSourceShipper(conf, null, null, source);
        shipper.entryReader = reader;
        source.workerThreads.put("testPeer", shipper);
        WALEntryBatch batch = new WALEntryBatch(10, logDir);
        WAL.Entry mockEntry = (WAL.Entry)Mockito.mock(WAL.Entry.class);
        WALEdit mockEdit = (WALEdit)Mockito.mock(WALEdit.class);
        WALKeyImpl mockKey = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)mockEntry.getEdit()).thenReturn((Object)mockEdit);
        Mockito.when((Object)mockEdit.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)mockEntry.getKey()).thenReturn((Object)mockKey);
        Mockito.when((Object)mockKey.estimatedSerializedSizeOf()).thenReturn((Object)1000L);
        Mockito.when((Object)mockEdit.heapSize()).thenReturn((Object)10000L);
        Mockito.when((Object)mockEdit.size()).thenReturn((Object)0);
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"0001"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"v1"));
        cells.add(kv);
        Mockito.when((Object)mockEdit.getCells()).thenReturn(cells);
        reader.addEntryToBatch(batch, mockEntry);
        reader.entryBatchQueue.put(batch);
        source.terminate("test");
        Assert.assertEquals((long)0L, (long)source.getSourceManager().getTotalBufferUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerShutdownRecoveredQueue() throws Exception {
        try {
            conf.set("hbase.wal.provider", "defaultProvider");
            conf.setInt("replication.sleep.before.failover", 2000);
            conf.set("hbase.regionserver.impl", ShutdownDelayRegionServer.class.getName());
            SingleProcessHBaseCluster cluster = TEST_UTIL.startMiniCluster(2);
            TEST_UTIL_PEER.startMiniCluster(1);
            HRegionServer serverA = cluster.getRegionServer(0);
            final ReplicationSourceManager managerA = serverA.getReplicationSourceService().getReplicationManager();
            HRegionServer serverB = cluster.getRegionServer(1);
            final ReplicationSourceManager managerB = serverB.getReplicationSourceService().getReplicationManager();
            Admin admin = TEST_UTIL.getAdmin();
            String peerId = "TestPeer";
            admin.addReplicationPeer("TestPeer", ReplicationPeerConfig.newBuilder().setClusterKey(TEST_UTIL_PEER.getClusterKey()).build());
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    return !managerA.getSources().isEmpty() && !managerB.getSources().isEmpty();
                }
            });
            admin.disableReplicationPeer("TestPeer");
            cluster.stopRegionServer(serverA.getServerName());
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return managerB.getOldSources().size() == 1;
                }
            });
            final HRegionServer serverC = cluster.startRegionServer().getRegionServer();
            serverC.waitForServerOnline();
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return serverC.getReplicationSourceService() != null;
                }
            });
            ReplicationSourceManager managerC = ((Replication)serverC.getReplicationSourceService()).getReplicationManager();
            Assert.assertEquals((long)0L, (long)managerC.getOldSources().size());
            cluster.stopRegionServer(serverB.getServerName());
            Waiter.waitFor((Configuration)conf, (long)20000L, () -> managerC.getOldSources().size() == 2);
            admin.enableReplicationPeer("TestPeer");
            Waiter.waitFor((Configuration)conf, (long)20000L, () -> managerC.getOldSources().size() == 0);
        }
        finally {
            conf.set("hbase.regionserver.impl", HRegionServer.class.getName());
        }
    }

    private RegionServerServices setupForAbortTests(ReplicationSource rs, Configuration conf, String endpointName) throws IOException {
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)mockPeer.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockPeer.getPeerBandwidth()).thenReturn((Object)0L);
        ReplicationPeerConfig peerConfig = (ReplicationPeerConfig)Mockito.mock(ReplicationPeerConfig.class);
        FaultyReplicationEndpoint.count = 0;
        Mockito.when((Object)peerConfig.getReplicationEndpointImpl()).thenReturn((Object)endpointName);
        Mockito.when((Object)mockPeer.getPeerConfig()).thenReturn((Object)peerConfig);
        ReplicationSourceManager manager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)manager.getGlobalMetrics()).thenReturn(Mockito.mock(MetricsReplicationGlobalSourceSource.class));
        RegionServerServices rss = TEST_UTIL.createMockRegionServerService(ServerName.parseServerName((String)"a.b.c,1,1"));
        ReplicationQueueId queueId = new ReplicationQueueId(rss.getServerName(), "qid");
        rs.init(conf, null, manager, null, mockPeer, (Server)rss, new ReplicationQueueData(queueId, ImmutableMap.of()), null, p -> OptionalLong.empty(), new MetricsSource(queueId.toString()));
        return rss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortFalseOnError() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("replication.source.regionserver.abort", false);
        ReplicationSource rs = new ReplicationSource();
        RegionServerServices rss = this.setupForAbortTests(rs, conf, FlakyReplicationEndpoint.class.getName());
        try {
            rs.startup();
            Assert.assertTrue((boolean)rs.isSourceActive());
            Assert.assertEquals((long)0L, (long)rs.getSourceMetrics().getSizeOfLogQueue());
            rs.enqueueLog(new Path("a.1.meta"));
            Assert.assertEquals((long)0L, (long)rs.getSourceMetrics().getSizeOfLogQueue());
            rs.enqueueLog(new Path("a.1"));
            Assert.assertEquals((long)1L, (long)rs.getSourceMetrics().getSizeOfLogQueue());
        }
        finally {
            rs.terminate("Done");
            rss.stop("Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicationSourceInitializingMetric() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("replication.source.regionserver.abort", false);
        ReplicationSource rs = new ReplicationSource();
        RegionServerServices rss = this.setupForAbortTests(rs, conf, BadReplicationEndpoint.class.getName());
        try {
            rs.startup();
            Assert.assertTrue((boolean)rs.isSourceActive());
            Waiter.waitFor((Configuration)conf, (long)10000L, () -> rs.getSourceMetrics().getSourceInitializing() == 1);
            BadReplicationEndpoint.failing = false;
            Waiter.waitFor((Configuration)conf, (long)10000L, () -> rs.getSourceMetrics().getSourceInitializing() == 0);
        }
        finally {
            rs.terminate("Done");
            rss.stop("Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortFalseOnErrorDoesntBlockMainThread() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        ReplicationSource rs = new ReplicationSource();
        RegionServerServices rss = this.setupForAbortTests(rs, conf, FaultyReplicationEndpoint.class.getName());
        try {
            rs.startup();
            Assert.assertTrue((boolean)true);
        }
        finally {
            rs.terminate("Done");
            rss.stop("Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortTrueOnError() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        ReplicationSource rs = new ReplicationSource();
        RegionServerServices rss = this.setupForAbortTests(rs, conf, FlakyReplicationEndpoint.class.getName());
        try {
            rs.startup();
            Assert.assertTrue((boolean)rs.isSourceActive());
            Waiter.waitFor((Configuration)conf, (long)1000L, () -> rss.isAborted());
            Assert.assertTrue((boolean)rss.isAborted());
            Waiter.waitFor((Configuration)conf, (long)1000L, () -> !rs.isSourceActive());
            Assert.assertFalse((boolean)rs.isSourceActive());
        }
        finally {
            rs.terminate("Done");
            rss.stop("Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAgeOfOldestWal() throws Exception {
        try {
            ManualEnvironmentEdge manualEdge = new ManualEnvironmentEdge();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)manualEdge);
            String peerId = "1";
            MetricsSource metrics = new MetricsSource(peerId);
            Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
            conf.setInt("replication.source.maxretriesmultiplier", 1);
            ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
            Mockito.when((Object)mockPeer.getConfiguration()).thenReturn((Object)conf);
            Mockito.when((Object)mockPeer.getPeerBandwidth()).thenReturn((Object)0L);
            ReplicationPeerConfig peerConfig = (ReplicationPeerConfig)Mockito.mock(ReplicationPeerConfig.class);
            Mockito.when((Object)peerConfig.getReplicationEndpointImpl()).thenReturn((Object)DoNothingReplicationEndpoint.class.getName());
            Mockito.when((Object)mockPeer.getPeerConfig()).thenReturn((Object)peerConfig);
            ReplicationSourceManager manager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
            Mockito.when((Object)manager.getGlobalMetrics()).thenReturn(Mockito.mock(MetricsReplicationGlobalSourceSource.class));
            RegionServerServices rss = TEST_UTIL.createMockRegionServerService(ServerName.parseServerName((String)"a.b.c,1,1"));
            ReplicationQueueId queueId = new ReplicationQueueId(rss.getServerName(), peerId);
            ReplicationSource source = new ReplicationSource();
            source.init(conf, null, manager, null, mockPeer, (Server)rss, new ReplicationQueueData(queueId, ImmutableMap.of()), null, p -> OptionalLong.empty(), metrics);
            Path log1 = new Path(logDir, "log-walgroup-a.8");
            manualEdge.setValue(10L);
            source.enqueueLog(log1);
            MetricsReplicationSourceSource metricsSource1 = this.getSourceMetrics(peerId);
            Assert.assertEquals((long)2L, (long)metricsSource1.getOldestWalAge());
            Path log2 = new Path(logDir, "log-walgroup-b.4");
            source.enqueueLog(log2);
            Assert.assertEquals((long)6L, (long)metricsSource1.getOldestWalAge());
            metrics.clear();
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private MetricsReplicationSourceSource getSourceMetrics(String sourceId) {
        MetricsReplicationSourceFactoryImpl factory = (MetricsReplicationSourceFactoryImpl)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class);
        return factory.getSource(sourceId);
    }

    static {
        conf = TEST_UTIL.getConfiguration();
    }

    public static class FaultyReplicationEndpoint
    extends DoNothingReplicationEndpoint {
        static int count = 0;

        @Override
        public synchronized UUID getPeerUUID() {
            throw new RuntimeException();
        }
    }

    public static class BadReplicationEndpoint
    extends DoNothingReplicationEndpoint {
        static boolean failing = true;

        @Override
        public synchronized UUID getPeerUUID() {
            return failing ? null : super.getPeerUUID();
        }
    }

    public static class FlakyReplicationEndpoint
    extends DoNothingReplicationEndpoint {
        static int count = 0;

        @Override
        public synchronized UUID getPeerUUID() {
            if (count == 0) {
                ++count;
                throw new RuntimeException();
            }
            return super.getPeerUUID();
        }
    }

    public static class DoNothingReplicationEndpoint
    extends HBaseInterClusterReplicationEndpoint {
        private final UUID uuid = UUID.randomUUID();

        public void init(ReplicationEndpoint.Context context) throws IOException {
            this.ctx = context;
        }

        public WALEntryFilter getWALEntryfilter() {
            return null;
        }

        public synchronized UUID getPeerUUID() {
            return this.uuid;
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }

        public boolean canReplicateToSameCluster() {
            return true;
        }
    }

    public static class ShutdownDelayRegionServer
    extends HRegionServer {
        public ShutdownDelayRegionServer(Configuration conf) throws IOException {
            super(conf);
        }

        protected void stopServiceThreads() {
            LOG.info("Adding a delay to the regionserver shutdown");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                LOG.error("Interrupted while sleeping");
            }
            super.stopServiceThreads();
        }
    }
}

