/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestDrainReplicationQueuesForStandBy
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDrainReplicationQueuesForStandBy.class);

    @Test
    public void test() throws Exception {
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 0, 100);
        HRegionServer rs = UTIL1.getRSForFirstRegionInTable(TABLE_NAME);
        final String walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName((String)((AbstractFSWAL)rs.getWAL(RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build())).getCurrentFileName().getName());
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        this.verify(UTIL2, 0, 100);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        try (Table table = UTIL2.getConnection().getTable(TABLE_NAME);){
            for (int i = 0; i < 100; ++i) {
                table.delete(new Delete(Bytes.toBytes((int)i)));
            }
        }
        UTIL2.flush(TABLE_NAME);
        UTIL2.compact(TABLE_NAME, true);
        final HRegion region = (HRegion)rs.getRegions(TABLE_NAME).get(0);
        UTIL1.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return region.get(new Get(Bytes.toBytes((int)99))).isEmpty();
            }

            public String explainFailure() throws Exception {
                return "Replication has not been catched up yet";
            }
        });
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().enableReplicationPeer(PEER_ID);
        final ReplicationSource source = (ReplicationSource)((Replication)rs.getReplicationSourceService()).getReplicationManager().getSource(PEER_ID);
        UTIL1.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !source.workerThreads.containsKey(walGroupId);
            }

            public String explainFailure() throws Exception {
                return "Replication has not been catched up yet";
            }
        });
        HRegion region2 = UTIL2.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)region2.get(new Get(Bytes.toBytes((int)i))).isEmpty());
        }
    }
}

