/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleanerBarrier;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestReplicationLogCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationLogCleaner.class);
    private static final Configuration CONF = HBaseConfiguration.create();
    private MasterServices services;
    private ReplicationLogCleaner cleaner;

    @Before
    public void setUp() throws ReplicationException {
        this.services = (MasterServices)Mockito.mock(MasterServices.class);
        ReplicationPeerManager rpm = (ReplicationPeerManager)Mockito.mock(ReplicationPeerManager.class);
        Mockito.when((Object)rpm.getReplicationLogCleanerBarrier()).thenReturn((Object)new ReplicationLogCleanerBarrier());
        Mockito.when((Object)this.services.getReplicationPeerManager()).thenReturn((Object)rpm);
        Mockito.when((Object)rpm.listPeers(null)).thenReturn(new ArrayList());
        ReplicationQueueStorage rqs = (ReplicationQueueStorage)Mockito.mock(ReplicationQueueStorage.class);
        Mockito.when((Object)rpm.getQueueStorage()).thenReturn((Object)rqs);
        Mockito.when((Object)rpm.getQueueStorage().hasData()).thenReturn((Object)true);
        Mockito.when((Object)rqs.listAllQueues()).thenReturn(new ArrayList());
        ServerManager sm = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)this.services.getServerManager()).thenReturn((Object)sm);
        Mockito.when((Object)sm.getOnlineServersList()).thenReturn(new ArrayList());
        ProcedureExecutor procExec = (ProcedureExecutor)Mockito.mock(ProcedureExecutor.class);
        Mockito.when((Object)this.services.getMasterProcedureExecutor()).thenReturn((Object)procExec);
        Mockito.when((Object)procExec.getProcedures()).thenReturn(new ArrayList());
        this.cleaner = new ReplicationLogCleaner();
        this.cleaner.setConf(CONF);
        ImmutableMap params = ImmutableMap.of((Object)"master", (Object)this.services);
        this.cleaner.init((Map)params);
    }

    @After
    public void tearDown() {
        this.cleaner.postClean();
    }

    private static Iterable<FileStatus> runCleaner(ReplicationLogCleaner cleaner, Iterable<FileStatus> files) {
        cleaner.preClean();
        return cleaner.getDeletableFiles(files);
    }

    private static FileStatus createFileStatus(Path path) {
        return new FileStatus(100L, false, 3, 256L, EnvironmentEdgeManager.currentTime(), path);
    }

    private static FileStatus createFileStatus(ServerName sn, int number) {
        Path path = new Path(sn.toString() + "." + number);
        return TestReplicationLogCleaner.createFileStatus(path);
    }

    private static ReplicationPeerDescription createPeer(String peerId) {
        return new ReplicationPeerDescription(peerId, true, null, null);
    }

    private void addServer(ServerName serverName) {
        this.services.getServerManager().getOnlineServersList().add(serverName);
    }

    private void addSCP(ServerName serverName, boolean finished) {
        ServerCrashProcedure scp = (ServerCrashProcedure)Mockito.mock(ServerCrashProcedure.class);
        Mockito.when((Object)scp.getServerName()).thenReturn((Object)serverName);
        Mockito.when((Object)scp.isFinished()).thenReturn((Object)finished);
        this.services.getMasterProcedureExecutor().getProcedures().add(scp);
    }

    private void addPeer(String ... peerIds) {
        this.services.getReplicationPeerManager().listPeers(null).addAll(Stream.of(peerIds).map(TestReplicationLogCleaner::createPeer).collect(Collectors.toList()));
    }

    private void addQueueData(ReplicationQueueData ... datas) throws ReplicationException {
        this.services.getReplicationPeerManager().getQueueStorage().listAllQueues().addAll(Arrays.asList(datas));
    }

    @Test
    public void testNoConf() {
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        List<FileStatus> files = Arrays.asList(new FileStatus());
        Assert.assertSame(files, TestReplicationLogCleaner.runCleaner(cleaner, files));
        cleaner.postClean();
    }

    @Test
    public void testCanNotFilter() {
        Assert.assertTrue((boolean)this.services.getReplicationPeerManager().getReplicationLogCleanerBarrier().disable());
        List<FileStatus> files = Arrays.asList(new FileStatus());
        Assert.assertSame(Collections.emptyList(), TestReplicationLogCleaner.runCleaner(this.cleaner, files));
    }

    @Test
    public void testNoPeer() {
        Path path = new Path("/wal." + EnvironmentEdgeManager.currentTime());
        Assert.assertTrue((boolean)AbstractFSWALProvider.validateWALFilename((String)path.getName()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(path);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testNotValidWalFile() {
        this.addPeer("1");
        Path path = new Path("/whatever");
        Assert.assertFalse((boolean)AbstractFSWALProvider.validateWALFilename((String)path.getName()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(path);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testMetaWalFile() {
        this.addPeer("1");
        Path path = new Path("/wal." + EnvironmentEdgeManager.currentTime() + ".meta");
        Assert.assertTrue((boolean)AbstractFSWALProvider.validateWALFilename((String)path.getName()));
        Assert.assertTrue((boolean)AbstractFSWALProvider.isMetaFile((Path)path));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(path);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testLiveRegionServerNoQueues() {
        this.addPeer("1");
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addServer(sn);
        List<FileStatus> files = Arrays.asList(TestReplicationLogCleaner.createFileStatus(sn, 1));
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, files), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testLiveRegionServerWithSCPNoQueues() {
        this.addPeer("1");
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addSCP(sn, false);
        List<FileStatus> files = Arrays.asList(TestReplicationLogCleaner.createFileStatus(sn, 1));
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, files), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testDeadRegionServerNoQueues() {
        this.addPeer("1");
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDeadRegionServerWithSCPNoQueues() {
        this.addPeer("1");
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addSCP(sn, true);
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testLiveRegionServerMissingQueue() throws ReplicationException {
        String peerId1 = "1";
        String peerId2 = "2";
        this.addPeer(peerId1, peerId2);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addServer(sn);
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data1 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId1), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        this.addQueueData(data1);
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testLiveRegionServerShouldNotDelete() throws ReplicationException {
        String peerId = "1";
        this.addPeer(peerId);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addServer(sn);
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data = new ReplicationQueueData(new ReplicationQueueId(sn, peerId), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), 0L)));
        this.addQueueData(data);
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testLiveRegionServerShouldNotDeleteTwoPeers() throws ReplicationException {
        String peerId1 = "1";
        String peerId2 = "2";
        this.addPeer(peerId1, peerId2);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addServer(sn);
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data1 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId1), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        ReplicationQueueData data2 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId2), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), 0L)));
        this.addQueueData(data1, data2);
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testLiveRegionServerShouldDelete() throws ReplicationException {
        String peerId = "1";
        this.addPeer(peerId);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addServer(sn);
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data = new ReplicationQueueData(new ReplicationQueueId(sn, peerId), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        this.services.getReplicationPeerManager().getQueueStorage().listAllQueues().add(data);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testLiveRegionServerShouldDeleteTwoPeers() throws ReplicationException {
        String peerId1 = "1";
        String peerId2 = "2";
        this.addPeer(peerId1, peerId2);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        this.addServer(sn);
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data1 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId1), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        ReplicationQueueData data2 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId2), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        this.addQueueData(data1, data2);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDeadRegionServerMissingQueue() throws ReplicationException {
        String peerId1 = "1";
        String peerId2 = "2";
        this.addPeer(peerId1, peerId2);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data1 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId1), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        this.addQueueData(data1);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDeadRegionServerShouldNotDelete() throws ReplicationException {
        String peerId = "1";
        this.addPeer(peerId);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data = new ReplicationQueueData(new ReplicationQueueId(sn, peerId), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), 0L)));
        this.addQueueData(data);
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testDeadRegionServerShouldNotDeleteTwoPeers() throws ReplicationException {
        String peerId1 = "1";
        String peerId2 = "2";
        this.addPeer(peerId1, peerId2);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data1 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId1), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        ReplicationQueueData data2 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId2), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), 0L)));
        this.addQueueData(data1, data2);
        MatcherAssert.assertThat(TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testDeadRegionServerShouldDelete() throws ReplicationException {
        String peerId = "1";
        this.addPeer(peerId);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data = new ReplicationQueueData(new ReplicationQueueId(sn, peerId), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        this.services.getReplicationPeerManager().getQueueStorage().listAllQueues().add(data);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDeadRegionServerShouldDeleteTwoPeers() throws ReplicationException {
        String peerId1 = "1";
        String peerId2 = "2";
        this.addPeer(peerId1, peerId2);
        ServerName sn = ServerName.valueOf((String)("server,123," + EnvironmentEdgeManager.currentTime()));
        FileStatus file = TestReplicationLogCleaner.createFileStatus(sn, 1);
        ReplicationQueueData data1 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId1), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        ReplicationQueueData data2 = new ReplicationQueueData(new ReplicationQueueId(sn, peerId2), ImmutableMap.of((Object)sn.toString(), (Object)new ReplicationGroupOffset(file.getPath().getName(), -1L)));
        this.addQueueData(data1, data2);
        Iterator<FileStatus> iter = TestReplicationLogCleaner.runCleaner(this.cleaner, Arrays.asList(file)).iterator();
        Assert.assertSame((Object)file, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }
}

