/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.replication.RecoverStandbyProcedure;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestRecoverStandbyProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoverStandbyProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRecoverStandbyProcedure.class);
    private static final TableName tableName = TableName.valueOf((String)"TestRecoverStandbyProcedure");
    private static final RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
    private static final byte[] family = Bytes.toBytes((String)"CF");
    private static final byte[] qualifier = Bytes.toBytes((String)"q");
    private static final long timestamp = EnvironmentEdgeManager.currentTime();
    private static final int ROW_COUNT = 1000;
    private static final int WAL_NUMBER = 10;
    private static final int RS_NUMBER = 3;
    private static final String PEER_ID = "1";
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static SyncReplicationReplayWALManager syncReplicationReplayWALManager;
    private static ProcedureExecutor<MasterProcedureEnv> procExec;
    private static FileSystem fs;
    private static Configuration conf;

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.startMiniCluster(3);
        UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        conf = UTIL.getConfiguration();
        HMaster master = UTIL.getHBaseCluster().getMaster();
        fs = master.getMasterFileSystem().getWALFileSystem();
        syncReplicationReplayWALManager = master.getSyncReplicationReplayWALManager();
        procExec = master.getMasterProcedureExecutor();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setupBeforeTest() throws IOException {
        UTIL.createTable(tableName, family);
    }

    @After
    public void tearDownAfterTest() throws IOException {
        try (Admin admin = UTIL.getAdmin();){
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
    }

    @Test
    public void testRecoverStandby() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.setupSyncReplicationWALs();
        long procId = procExec.submitProcedure((Procedure)new RecoverStandbyProcedure(PEER_ID, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 10000; ++i) {
                Result result = table.get(new Get(Bytes.toBytes((int)i)).setTimestamp(timestamp));
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(family, qualifier)));
            }
        }
    }

    private void setupSyncReplicationWALs() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        Path peerRemoteWALDir = ReplicationUtils.getPeerRemoteWALDir((Path)syncReplicationReplayWALManager.getRemoteWALDir(), (String)PEER_ID);
        if (!fs.exists(peerRemoteWALDir)) {
            fs.mkdirs(peerRemoteWALDir);
        }
        for (int i = 0; i < 10; ++i) {
            try (ProtobufLogWriter writer = new ProtobufLogWriter();){
                Path wal = new Path(peerRemoteWALDir, "srv1,8888." + i + ".syncrep");
                writer.init(fs, wal, conf, true, WALUtil.getWALBlockSize((Configuration)conf, (FileSystem)fs, (Path)peerRemoteWALDir), StreamSlowMonitor.create((Configuration)conf, (String)"defaultMonitor"));
                List<WAL.Entry> entries = this.setupWALEntries(i * 1000, (i + 1) * 1000);
                for (WAL.Entry entry : entries) {
                    writer.append(entry);
                }
                writer.sync(false);
                LOG.info("Created wal {} to replay for peer id={}", (Object)wal, (Object)PEER_ID);
                continue;
            }
        }
    }

    private List<WAL.Entry> setupWALEntries(int startRow, int endRow) {
        return IntStream.range(startRow, endRow).mapToObj(i -> this.createWALEntry(Bytes.toBytes((int)i), Bytes.toBytes((int)i))).collect(Collectors.toList());
    }

    private WAL.Entry createWALEntry(byte[] row, byte[] value) {
        WALKeyImpl key = new WALKeyImpl(regionInfo.getEncodedNameAsBytes(), tableName, 1L);
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(row, family, qualifier, timestamp, value));
        return new WAL.Entry(key, edit);
    }
}

