/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationStandBy
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationStandBy.class);

    private void assertDisallow(Table table, TableAction action) throws IOException {
        try {
            action.call(table);
            Assert.fail((String)"Should not allow the action");
        }
        catch (DoNotRetryIOException | RetriesExhaustedException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"STANDBY"));
        }
    }

    @Test
    public void testStandby() throws Exception {
        MasterFileSystem mfs = UTIL2.getHBaseCluster().getMaster().getMasterFileSystem();
        Path remoteWALDir = this.getRemoteWALDir(mfs, PEER_ID);
        Assert.assertFalse((boolean)mfs.getWALFileSystem().exists(remoteWALDir));
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        Assert.assertTrue((boolean)mfs.getWALFileSystem().exists(remoteWALDir));
        try (Table table = UTIL2.getConnection().getTable(TABLE_NAME);){
            this.assertDisallow(table, t -> t.get(new Get(Bytes.toBytes((String)"row"))));
            this.assertDisallow(table, t -> t.put(new Put(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"row"))));
            this.assertDisallow(table, t -> t.delete(new Delete(Bytes.toBytes((String)"row"))));
            this.assertDisallow(table, t -> t.incrementColumnValue(Bytes.toBytes((String)"row"), CF, CQ, 1L));
            this.assertDisallow(table, t -> t.append(new Append(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"row"))));
            this.assertDisallow(table, t -> t.get(Arrays.asList(new Get(Bytes.toBytes((String)"row")), new Get(Bytes.toBytes((String)"row1")))));
            this.assertDisallow(table, t -> t.put(Arrays.asList(new Put(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"row")), new Put(Bytes.toBytes((String)"row1")).addColumn(CF, CQ, Bytes.toBytes((String)"row1")))));
            this.assertDisallow(table, t -> t.mutateRow(new RowMutations(Bytes.toBytes((String)"row")).add((Mutation)new Put(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"row")))));
        }
        this.writeAndVerifyReplication(UTIL1, UTIL2, 0, 100);
        FileSystem fs2 = REMOTE_WAL_DIR2.getFileSystem(UTIL2.getConfiguration());
        Assert.assertTrue((boolean)fs2.exists(this.getRemoteWALDir(REMOTE_WAL_DIR2, PEER_ID)));
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        Assert.assertFalse((boolean)fs2.exists(this.getRemoteWALDir(REMOTE_WAL_DIR2, PEER_ID)));
        Assert.assertFalse((boolean)fs2.exists(this.getReplayRemoteWALs(REMOTE_WAL_DIR2, PEER_ID)));
        UTIL1.getAdmin().removeReplicationPeer(PEER_ID);
        this.verifyRemovedPeer(PEER_ID, REMOTE_WAL_DIR1, UTIL1);
        fs2.create(this.getRemoteWALDir(REMOTE_WAL_DIR2, PEER_ID));
        fs2.create(this.getReplayRemoteWALs(REMOTE_WAL_DIR2, PEER_ID));
        Assert.assertTrue((boolean)fs2.exists(this.getRemoteWALDir(REMOTE_WAL_DIR2, PEER_ID)));
        Assert.assertTrue((boolean)fs2.exists(this.getReplayRemoteWALs(REMOTE_WAL_DIR2, PEER_ID)));
        UTIL2.getAdmin().removeReplicationPeer(PEER_ID);
        this.verifyRemovedPeer(PEER_ID, REMOTE_WAL_DIR2, UTIL2);
    }

    @FunctionalInterface
    private static interface TableAction {
        public void call(Table var1) throws IOException;
    }
}

