/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.master.replication.TransitPeerSyncReplicationStateProcedure;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationNewRSJoinBetweenRefreshes
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationNewRSJoinBetweenRefreshes.class);
    private static boolean HALT;
    private static CountDownLatch ARRIVE;
    private static CountDownLatch RESUME;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL1.getConfiguration().setClass("hbase.coprocessor.regionserver.classes", HaltCP.class, RegionServerObserver.class);
        SyncReplicationTestBase.setUp();
    }

    @Test
    public void test() throws IOException, InterruptedException {
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        ARRIVE = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        HALT = true;
        Thread t = new Thread(() -> {
            try {
                UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        t.start();
        ARRIVE.await();
        UTIL1.getMiniHBaseCluster().startRegionServer();
        RESUME.countDown();
        t.join();
        Assert.assertEquals((Object)SyncReplicationState.DOWNGRADE_ACTIVE, (Object)UTIL1.getAdmin().getReplicationPeerSyncReplicationState(PEER_ID));
    }

    public static final class HaltCP
    implements RegionServerObserver,
    RegionServerCoprocessor {
        public Optional<RegionServerObserver> getRegionServerObserver() {
            return Optional.of(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postExecuteProcedures(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
            Class<HaltCP> clazz = HaltCP.class;
            synchronized (HaltCP.class) {
                if (!HALT) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                SyncReplicationTestBase.UTIL1.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof TransitPeerSyncReplicationStateProcedure).filter(p -> !p.isFinished()).map(p -> (TransitPeerSyncReplicationStateProcedure)p).findFirst().ifPresent(proc -> {
                    if (proc.getCurrentStateId() == 4) {
                        ARRIVE.countDown();
                        try {
                            RESUME.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        HALT = false;
                    }
                });
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

