/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.DualAsyncFSWAL;
import org.apache.hadoop.hbase.replication.DualAsyncFSWALForTest;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationMoreLogsInLocalCopyToRemote
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationMoreLogsInLocalCopyToRemote.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncReplicationMoreLogsInLocalCopyToRemote.class);

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL1.getConfiguration().setClass("hbase.wal.sync.impl", DualAsyncFSWALForTest.class, DualAsyncFSWAL.class);
        UTIL2.getConfiguration().setClass("hbase.wal.sync.impl", DualAsyncFSWALForTest.class, DualAsyncFSWAL.class);
        SyncReplicationTestBase.setUp();
    }

    @Test
    public void testSplitLog() throws Exception {
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        HRegionServer rs = UTIL1.getRSForFirstRegionInTable(TABLE_NAME);
        DualAsyncFSWALForTest wal = (DualAsyncFSWALForTest)rs.getWAL(RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build());
        wal.setRemoteBroken();
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL1.getConfiguration()).get();){
            AsyncTable table = conn.getTableBuilder(TABLE_NAME).setMaxAttempts(1).build();
            try {
                table.put(new Put(Bytes.toBytes((int)0)).addColumn(CF, CQ, Bytes.toBytes((int)0))).get();
                Assert.fail((String)"Should fail since the rs will crash and we will not retry");
            }
            catch (ExecutionException e) {
                LOG.info("Expected error:", (Throwable)e);
            }
        }
        UTIL1.waitFor(60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                try (Table table = SyncReplicationTestBase.UTIL1.getConnection().getTable(SyncReplicationTestBase.TABLE_NAME);){
                    boolean bl = table.exists(new Get(Bytes.toBytes((int)0)));
                    return bl;
                }
            }

            public String explainFailure() throws Exception {
                return "The row is still not available";
            }
        });
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        var4_4 = null;
        try (Table table = UTIL2.getConnection().getTable(TABLE_NAME);){
            Assert.assertEquals((long)0L, (long)Bytes.toInt((byte[])table.get(new Get(Bytes.toBytes((int)0))).getValue(CF, CQ)));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }
}

