/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.NoEOFWALStreamReader;
import org.apache.hadoop.hbase.wal.WAL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationActive
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationActive.class);

    @Test
    public void testActive() throws Exception {
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        this.verifyReplicationRequestRejection(UTIL1, true);
        this.verifyReplicationRequestRejection(UTIL2, false);
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 0, 100);
        Thread.sleep(2000L);
        this.verifyNotReplicatedThroughRegion(UTIL2, 0, 100);
        this.verifyNoClusterIdInRemoteLog(UTIL2, REMOTE_WAL_DIR2, PEER_ID);
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        this.verifyReplicationRequestRejection(UTIL2, true);
        this.verify(UTIL2, 0, 100);
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL1.getConfiguration()).get();){
            AsyncTable table = conn.getTableBuilder(TABLE_NAME).setMaxAttempts(1).build();
            CompletableFuture future = table.put(new Put(Bytes.toBytes((int)1000)).addColumn(CF, CQ, Bytes.toBytes((int)1000)));
            Thread.sleep(2000L);
            Assert.assertFalse((boolean)future.isDone());
            UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
            try {
                future.get();
                Assert.fail((String)"should fail because of the wal is closing");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"only marker edit is allowed"));
            }
        }
        HRegion region = UTIL1.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        Assert.assertTrue((boolean)region.get(new Get(Bytes.toBytes((int)1000))).isEmpty());
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        this.writeAndVerifyReplication(UTIL2, UTIL1, 100, 200);
        UTIL1.shutdownMiniCluster();
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        this.verifyReplicationRequestRejection(UTIL2, true);
        this.write(UTIL2, 200, 300);
    }

    private void verifyNoClusterIdInRemoteLog(HBaseTestingUtil utility, Path remoteDir, String peerId) throws Exception {
        FileSystem fs2 = utility.getTestFileSystem();
        FileStatus[] files = fs2.listStatus(new Path(remoteDir, peerId));
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (FileStatus file : files) {
            try (NoEOFWALStreamReader reader = NoEOFWALStreamReader.create(fs2, file.getPath(), utility.getConfiguration());){
                WAL.Entry entry = reader.next();
                Assert.assertTrue((entry != null ? 1 : 0) != 0);
                while (entry != null) {
                    Assert.assertEquals((long)entry.getKey().getClusterIds().size(), (long)0L);
                    entry = reader.next();
                }
            }
        }
    }
}

