/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationStatus
extends TestReplicationBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationStatus.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationStatus.class);

    static void insertRowsOnSource() throws IOException {
        byte[] qualName = Bytes.toBytes((String)"q");
        for (int i = 0; i < 100; ++i) {
            Put p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(famName, qualName, Bytes.toBytes((String)("val" + i)));
            htable1.put(p);
        }
    }

    @Test
    public void testReplicationStatus() throws Exception {
        UTIL1.getMiniHBaseCluster().startRegionServer();
        Waiter.waitFor((Configuration)UTIL1.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestReplicationBase.UTIL1.getMiniHBaseCluster().getLiveRegionServerThreads().size() > 1;
            }
        });
        Admin hbaseAdmin = UTIL1.getAdmin();
        hbaseAdmin.disableReplicationPeer("2");
        TestReplicationStatus.insertRowsOnSource();
        LOG.info("AFTER PUTS");
        Threads.sleep((long)10000L);
        ClusterMetrics metrics = hbaseAdmin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        for (JVMClusterUtil.RegionServerThread thread : UTIL1.getHBaseCluster().getRegionServerThreads()) {
            ServerName server = thread.getRegionServer().getServerName();
            Assert.assertTrue((String)("" + server), (boolean)metrics.getLiveServerMetrics().containsKey(server));
            ServerMetrics sm = (ServerMetrics)metrics.getLiveServerMetrics().get(server);
            List rLoadSourceList = sm.getReplicationLoadSourceList();
            ReplicationLoadSink rLoadSink = sm.getReplicationLoadSink();
            Assert.assertEquals((String)("Failed to get ReplicationLoadSourceList " + rLoadSourceList + ", " + server), (long)1L, (long)rLoadSourceList.size());
            Assert.assertEquals((Object)"2", (Object)((ReplicationLoadSource)rLoadSourceList.get(0)).getPeerID());
            Assert.assertTrue((String)"failed to get ReplicationLoadSink.AgeOfLastShippedOp ", (rLoadSink.getAgeOfLastAppliedOp() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"failed to get ReplicationLoadSink.TimeStampsOfLastAppliedOp ", (rLoadSink.getTimestampsOfLastAppliedOp() >= 0L ? 1 : 0) != 0);
        }
        HRegionServer hrs = UTIL1.getHBaseCluster().getRegionServer(1);
        hrs.stop("Stop RegionServer");
        while (hrs.isAlive()) {
            Threads.sleep((long)100L);
        }
        Threads.sleep((long)10000L);
        ServerName server = UTIL1.getHBaseCluster().getRegionServer(0).getServerName();
        List<ReplicationLoadSource> rLoadSourceList = this.waitOnMetricsReport(1, server);
        Assert.assertEquals((String)("Failed ReplicationLoadSourceList " + rLoadSourceList), (long)2L, (long)rLoadSourceList.size());
        Assert.assertEquals((Object)"2", (Object)rLoadSourceList.get(0).getPeerID());
    }

    private List<ReplicationLoadSource> waitOnMetricsReport(final int greaterThan, final ServerName serverName) throws Exception {
        UTIL1.waitFor(30000L, 1000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                List list = ((ServerMetrics)TestReplicationBase.hbaseAdmin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().get(serverName)).getReplicationLoadSourceList();
                return list.size() > greaterThan;
            }

            public String explainFailure() throws Exception {
                return "The ReplicationLoadSourceList's size is lesser than or equal to " + greaterThan + " for " + serverName;
            }
        });
        return ((ServerMetrics)hbaseAdmin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().get(serverName)).getReplicationLoadSourceList();
    }
}

