/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FlakeyTests.class, LargeTests.class})
public class TestPerTableCFReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPerTableCFReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestPerTableCFReplication.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static Configuration conf3;
    private static HBaseTestingUtil utility1;
    private static HBaseTestingUtil utility2;
    private static HBaseTestingUtil utility3;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 100;
    private static final TableName tableName;
    private static final TableName tabAName;
    private static final TableName tabBName;
    private static final TableName tabCName;
    private static final byte[] famName;
    private static final byte[] f1Name;
    private static final byte[] f2Name;
    private static final byte[] f3Name;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] noRepfamName;
    private static final byte[] val;
    private static TableDescriptor table;
    private static TableDescriptor tabA;
    private static TableDescriptor tabB;
    private static TableDescriptor tabC;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        utility1 = new HBaseTestingUtil(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        new ZKWatcher(conf1, "cluster1", null, true);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf3 = new Configuration(conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility2 = new HBaseTestingUtil(conf2);
        utility2.setZkCluster(miniZK);
        new ZKWatcher(conf2, "cluster3", null, true);
        utility3 = new HBaseTestingUtil(conf3);
        utility3.setZkCluster(miniZK);
        new ZKWatcher(conf3, "cluster3", null, true);
        table = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        tabA = TableDescriptorBuilder.newBuilder((TableName)tabAName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f1Name).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f2Name).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f3Name).setScope(1).build()).build();
        tabB = TableDescriptorBuilder.newBuilder((TableName)tabBName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f1Name).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f2Name).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f3Name).setScope(1).build()).build();
        tabC = TableDescriptorBuilder.newBuilder((TableName)tabCName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f1Name).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f2Name).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])f3Name).setScope(1).build()).build();
        utility1.startMiniCluster();
        utility2.startMiniCluster();
        utility3.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility3.shutdownMiniCluster();
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testParseTableCFsFromConfig() {
        Map tabCFsMap = null;
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig(null);
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)"");
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)"   ");
        Assert.assertEquals(null, (Object)tabCFsMap);
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "3"));
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)tableName1.getNameAsString());
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tableName2));
        Assert.assertEquals(null, tabCFsMap.get(tableName1));
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)(tableName2 + ":cf1"));
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName2));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tableName2)).get(0));
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)(tableName3 + " : cf1 , cf3"));
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName3));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tableName3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf3"));
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)(tableName1 + " ; " + tableName2 + ":cf1 ; " + tableName3 + ":cf1,cf3"));
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName3));
        Assert.assertEquals(null, tabCFsMap.get(tableName1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tableName2)).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tableName3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf3"));
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)(tableName1 + " ; ; " + tableName2 + ":cf1 ; " + tableName3 + ":cf1,,cf3 ;"));
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName3));
        Assert.assertEquals(null, tabCFsMap.get(tableName1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tableName2)).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tableName3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf3"));
        tabCFsMap = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)(tableName1 + ":tt:cf1 ; " + tableName2 + "::cf1 ; " + tableName3 + ":cf1,cf3"));
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tableName2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName3));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tableName3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf3"));
    }

    @Test
    public void testTableCFsHelperConverter() {
        ReplicationProtos.TableCF[] tableCFs = null;
        Map tabCFsMap = null;
        Assert.assertNull((Object)ReplicationPeerConfigUtil.convert(tabCFsMap));
        tabCFsMap = new HashMap();
        tableCFs = ReplicationPeerConfigUtil.convert(tabCFsMap);
        Assert.assertEquals((long)0L, (long)tableCFs.length);
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "3"));
        tabCFsMap.clear();
        tabCFsMap.put(tableName1, null);
        tableCFs = ReplicationPeerConfigUtil.convert(tabCFsMap);
        Assert.assertEquals((long)1L, (long)tableCFs.length);
        Assert.assertEquals((Object)tableName1.toString(), (Object)tableCFs[0].getTableName().getQualifier().toStringUtf8());
        Assert.assertEquals((long)0L, (long)tableCFs[0].getFamiliesCount());
        tabCFsMap.clear();
        tabCFsMap.put(tableName2, new ArrayList());
        ((List)tabCFsMap.get(tableName2)).add("cf1");
        tableCFs = ReplicationPeerConfigUtil.convert(tabCFsMap);
        Assert.assertEquals((long)1L, (long)tableCFs.length);
        Assert.assertEquals((Object)tableName2.toString(), (Object)tableCFs[0].getTableName().getQualifier().toStringUtf8());
        Assert.assertEquals((long)1L, (long)tableCFs[0].getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)tableCFs[0].getFamilies(0).toStringUtf8());
        tabCFsMap.clear();
        tabCFsMap.put(tableName3, new ArrayList());
        ((List)tabCFsMap.get(tableName3)).add("cf1");
        ((List)tabCFsMap.get(tableName3)).add("cf3");
        tableCFs = ReplicationPeerConfigUtil.convert(tabCFsMap);
        Assert.assertEquals((long)1L, (long)tableCFs.length);
        Assert.assertEquals((Object)tableName3.toString(), (Object)tableCFs[0].getTableName().getQualifier().toStringUtf8());
        Assert.assertEquals((long)2L, (long)tableCFs[0].getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)tableCFs[0].getFamilies(0).toStringUtf8());
        Assert.assertEquals((Object)"cf3", (Object)tableCFs[0].getFamilies(1).toStringUtf8());
        tabCFsMap.clear();
        tabCFsMap.put(tableName1, null);
        tabCFsMap.put(tableName2, new ArrayList());
        ((List)tabCFsMap.get(tableName2)).add("cf1");
        tabCFsMap.put(tableName3, new ArrayList());
        ((List)tabCFsMap.get(tableName3)).add("cf1");
        ((List)tabCFsMap.get(tableName3)).add("cf3");
        tableCFs = ReplicationPeerConfigUtil.convert(tabCFsMap);
        Assert.assertEquals((long)3L, (long)tableCFs.length);
        Assert.assertNotNull((Object)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName1.toString()));
        Assert.assertNotNull((Object)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName2.toString()));
        Assert.assertNotNull((Object)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName3.toString()));
        Assert.assertEquals((long)0L, (long)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName1.toString()).getFamiliesCount());
        Assert.assertEquals((long)1L, (long)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName2.toString()).getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName2.toString()).getFamilies(0).toStringUtf8());
        Assert.assertEquals((long)2L, (long)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName3.toString()).getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName3.toString()).getFamilies(0).toStringUtf8());
        Assert.assertEquals((Object)"cf3", (Object)ReplicationPeerConfigUtil.getTableCF((ReplicationProtos.TableCF[])tableCFs, (String)tableName3.toString()).getFamilies(1).toStringUtf8());
        tabCFsMap = ReplicationPeerConfigUtil.convert2Map((ReplicationProtos.TableCF[])tableCFs);
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName1));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tableName3));
        Assert.assertEquals(null, tabCFsMap.get(tableName1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tableName2)).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tableName3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tableName3)).contains("cf3"));
    }

    @Test
    public void testPerTableCFReplication() throws Exception {
        LOG.info("testPerTableCFReplication");
        try (Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
             Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
             Connection connection3 = ConnectionFactory.createConnection((Configuration)conf3);
             Admin admin1 = connection1.getAdmin();
             Admin admin2 = connection2.getAdmin();
             Admin admin3 = connection3.getAdmin();
             Admin replicationAdmin = connection1.getAdmin();){
            admin1.createTable(tabA);
            admin1.createTable(tabB);
            admin1.createTable(tabC);
            admin2.createTable(tabA);
            admin2.createTable(tabB);
            admin2.createTable(tabC);
            admin3.createTable(tabA);
            admin3.createTable(tabB);
            admin3.createTable(tabC);
            Table htab1A = connection1.getTable(tabAName);
            Table htab2A = connection2.getTable(tabAName);
            Table htab3A = connection3.getTable(tabAName);
            Table htab1B = connection1.getTable(tabBName);
            Table htab2B = connection2.getTable(tabBName);
            Table htab3B = connection3.getTable(tabBName);
            Table htab1C = connection1.getTable(tabCName);
            Table htab2C = connection2.getTable(tabCName);
            Table htab3C = connection3.getTable(tabCName);
            HashMap tableCFs = new HashMap();
            tableCFs.put(tabCName, null);
            tableCFs.put(tabBName, new ArrayList());
            ((List)tableCFs.get(tabBName)).add("f1");
            ((List)tableCFs.get(tabBName)).add("f3");
            ReplicationPeerConfig rpc2 = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).setReplicateAllUserTables(false).setTableCFsMap(tableCFs).build();
            replicationAdmin.addReplicationPeer("2", rpc2);
            tableCFs.clear();
            tableCFs.put(tabAName, null);
            tableCFs.put(tabBName, new ArrayList());
            ((List)tableCFs.get(tabBName)).add("f1");
            ((List)tableCFs.get(tabBName)).add("f2");
            ReplicationPeerConfig rpc3 = ReplicationPeerConfig.newBuilder().setClusterKey(utility3.getClusterKey()).setReplicateAllUserTables(false).setTableCFsMap(tableCFs).build();
            replicationAdmin.addReplicationPeer("3", rpc3);
            this.putAndWaitWithFamily(row1, f1Name, htab1A, htab3A);
            this.ensureRowNotReplicated(row1, f1Name, htab2A);
            this.deleteAndWaitWithFamily(row1, f1Name, htab1A, htab3A);
            this.putAndWaitWithFamily(row1, f2Name, htab1A, htab3A);
            this.ensureRowNotReplicated(row1, f2Name, htab2A);
            this.deleteAndWaitWithFamily(row1, f2Name, htab1A, htab3A);
            this.putAndWaitWithFamily(row1, f3Name, htab1A, htab3A);
            this.ensureRowNotReplicated(row1, f3Name, htab2A);
            this.deleteAndWaitWithFamily(row1, f3Name, htab1A, htab3A);
            this.putAndWaitWithFamily(row1, f1Name, htab1B, htab2B, htab3B);
            this.deleteAndWaitWithFamily(row1, f1Name, htab1B, htab2B, htab3B);
            this.putAndWaitWithFamily(row1, f2Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row1, f2Name, htab2B);
            this.deleteAndWaitWithFamily(row1, f2Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row1, f3Name, htab1B, htab2B);
            this.ensureRowNotReplicated(row1, f3Name, htab3B);
            this.deleteAndWaitWithFamily(row1, f3Name, htab1B, htab2B);
            this.putAndWaitWithFamily(row1, f1Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row1, f1Name, htab3C);
            this.deleteAndWaitWithFamily(row1, f1Name, htab1C, htab2C);
            this.putAndWaitWithFamily(row1, f2Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row1, f2Name, htab3C);
            this.deleteAndWaitWithFamily(row1, f2Name, htab1C, htab2C);
            this.putAndWaitWithFamily(row1, f3Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row1, f3Name, htab3C);
            this.deleteAndWaitWithFamily(row1, f3Name, htab1C, htab2C);
            tableCFs.clear();
            tableCFs.put(tabAName, new ArrayList());
            ((List)tableCFs.get(tabAName)).add("f1");
            ((List)tableCFs.get(tabAName)).add("f2");
            tableCFs.put(tabCName, new ArrayList());
            ((List)tableCFs.get(tabCName)).add("f2");
            ((List)tableCFs.get(tabCName)).add("f3");
            replicationAdmin.updateReplicationPeerConfig("2", ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)replicationAdmin.getReplicationPeerConfig("2")).setTableCFsMap(tableCFs).build());
            tableCFs.clear();
            tableCFs.put(tabBName, null);
            tableCFs.put(tabCName, new ArrayList());
            ((List)tableCFs.get(tabCName)).add("f3");
            replicationAdmin.updateReplicationPeerConfig("3", ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)replicationAdmin.getReplicationPeerConfig("3")).setTableCFsMap(tableCFs).build());
            this.putAndWaitWithFamily(row2, f1Name, htab1A, htab2A);
            this.ensureRowNotReplicated(row2, f1Name, htab3A);
            this.deleteAndWaitWithFamily(row2, f1Name, htab1A, htab2A);
            this.putAndWaitWithFamily(row2, f2Name, htab1A, htab2A);
            this.ensureRowNotReplicated(row2, f2Name, htab3A);
            this.deleteAndWaitWithFamily(row2, f2Name, htab1A, htab2A);
            this.putAndWaitWithFamily(row2, f3Name, htab1A, new Table[0]);
            this.ensureRowNotReplicated(row2, f3Name, htab2A, htab3A);
            this.deleteAndWaitWithFamily(row2, f3Name, htab1A, new Table[0]);
            this.putAndWaitWithFamily(row2, f1Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row2, f1Name, htab2B);
            this.deleteAndWaitWithFamily(row2, f1Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row2, f2Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row2, f2Name, htab2B);
            this.deleteAndWaitWithFamily(row2, f2Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row2, f3Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row2, f3Name, htab2B);
            this.deleteAndWaitWithFamily(row2, f3Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row2, f1Name, htab1C, new Table[0]);
            this.ensureRowNotReplicated(row2, f1Name, htab2C, htab3C);
            this.deleteAndWaitWithFamily(row2, f1Name, htab1C, new Table[0]);
            this.putAndWaitWithFamily(row2, f2Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row2, f2Name, htab3C);
            this.deleteAndWaitWithFamily(row2, f2Name, htab1C, htab2C);
            this.putAndWaitWithFamily(row2, f3Name, htab1C, htab2C, htab3C);
            this.deleteAndWaitWithFamily(row2, f3Name, htab1C, htab2C, htab3C);
        }
    }

    private void ensureRowNotReplicated(byte[] row, byte[] fam, Table ... tables) throws IOException {
        Get get = new Get(row);
        get.addFamily(fam);
        for (Table table : tables) {
            Result res = table.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
        }
    }

    private void deleteAndWaitWithFamily(byte[] row, byte[] fam, Table source, Table ... targets) throws Exception {
        Delete del = new Delete(row);
        del.addFamily(fam);
        source.delete(del);
        Get get = new Get(row);
        get.addFamily(fam);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            boolean removedFromAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.size() < 1) continue;
                LOG.info("Row not deleted");
                removedFromAll = false;
                break;
            }
            if (removedFromAll) break;
            Thread.sleep(500L);
        }
    }

    private void putAndWaitWithFamily(byte[] row, byte[] fam, Table source, Table ... targets) throws Exception {
        Put put = new Put(row);
        put.addColumn(fam, row, val);
        source.put(put);
        Get get = new Get(row);
        get.addFamily(fam);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            boolean replicatedToAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.isEmpty()) {
                    LOG.info("Row not available");
                    replicatedToAll = false;
                    break;
                }
                Assert.assertEquals((long)1L, (long)res.size());
                Assert.assertArrayEquals((byte[])val, (byte[])res.value());
            }
            if (replicatedToAll) break;
            Thread.sleep(500L);
        }
    }

    static {
        tableName = TableName.valueOf((String)"test");
        tabAName = TableName.valueOf((String)"TA");
        tabBName = TableName.valueOf((String)"TB");
        tabCName = TableName.valueOf((String)"TC");
        famName = Bytes.toBytes((String)"f");
        f1Name = Bytes.toBytes((String)"f1");
        f2Name = Bytes.toBytes((String)"f2");
        f3Name = Bytes.toBytes((String)"f3");
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        noRepfamName = Bytes.toBytes((String)"norep");
        val = Bytes.toBytes((String)"myval");
    }
}

