/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestMultiSlaveReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiSlaveReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiSlaveReplication.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static Configuration conf3;
    private static HBaseTestingUtil utility1;
    private static HBaseTestingUtil utility2;
    private static HBaseTestingUtil utility3;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 100;
    private static final TableName tableName;
    private static final byte[] famName;
    private static final byte[] row;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] noRepfamName;
    private static TableDescriptor table;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        conf1.setInt("hbase.master.cleaner.interval", 5000);
        utility1 = new HBaseTestingUtil(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        utility1.setZkCluster(miniZK);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf3 = new Configuration(conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility2 = new HBaseTestingUtil(conf2);
        utility2.setZkCluster(miniZK);
        utility3 = new HBaseTestingUtil(conf3);
        utility3.setZkCluster(miniZK);
        table = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
    }

    @Test
    public void testMultiSlaveReplication() throws Exception {
        LOG.info("testCyclicReplication");
        utility1.startMiniCluster();
        utility2.startMiniCluster();
        utility3.startMiniCluster();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf1);
             Admin admin1 = conn.getAdmin();){
            utility1.getAdmin().createTable(table);
            utility2.getAdmin().createTable(table);
            utility3.getAdmin().createTable(table);
            Table htable1 = utility1.getConnection().getTable(tableName);
            Table htable2 = utility2.getConnection().getTable(tableName);
            Table htable3 = utility3.getConnection().getTable(tableName);
            ReplicationPeerConfigBuilder rpcBuilder = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey());
            admin1.addReplicationPeer("1", rpcBuilder.build());
            this.putAndWait(row, famName, htable1, htable2);
            this.deleteAndWait(row, htable1, htable2);
            this.checkRow(row, 0, htable3);
            this.putAndWait(row2, famName, htable1, htable2);
            this.rollWALAndWait(utility1, htable1.getName(), row2);
            this.putAndWait(row3, famName, htable1, htable2);
            rpcBuilder.setClusterKey(utility3.getClusterKey());
            admin1.addReplicationPeer("2", rpcBuilder.build());
            this.putAndWait(row1, famName, htable1, htable2, htable3);
            this.deleteAndWait(row1, htable1, htable2, htable3);
            this.checkRow(row2, 0, htable3);
            this.checkRow(row3, 1, htable3);
            Put p = new Put(row);
            p.addColumn(famName, row, row);
            htable1.put(p);
            this.rollWALAndWait(utility1, htable1.getName(), row);
            this.deleteAndWait(row2, htable1, htable2, htable3);
            this.checkRow(row, 1, htable2);
            this.checkWithWait(row, 1, htable3);
            this.deleteAndWait(row, htable1, htable2, htable3);
            this.deleteAndWait(row3, htable1, htable2, htable3);
            utility3.shutdownMiniCluster();
            utility2.shutdownMiniCluster();
            utility1.shutdownMiniCluster();
        }
    }

    private void rollWALAndWait(HBaseTestingUtil utility, TableName table, byte[] row) throws IOException {
        Admin admin = utility.getAdmin();
        SingleProcessHBaseCluster cluster = utility.getMiniHBaseCluster();
        HRegion region = null;
        for (HRegion candidate : cluster.getRegions(table)) {
            if (!HRegion.rowIsInRange((RegionInfo)candidate.getRegionInfo(), (byte[])row)) continue;
            region = candidate;
            break;
        }
        Assert.assertNotNull((String)("Couldn't find the region for row '" + Arrays.toString(row) + "'"), (Object)region);
        final CountDownLatch latch = new CountDownLatch(1);
        WALActionsListener listener = new WALActionsListener(){

            public void postLogRoll(Path oldPath, Path newPath) throws IOException {
                latch.countDown();
            }
        };
        region.getWAL().registerWALActionsListener(listener);
        admin.rollWALWriter(cluster.getServerHoldingRegion(region.getTableDescriptor().getTableName(), region.getRegionInfo().getRegionName()));
        try {
            latch.await();
        }
        catch (InterruptedException exception) {
            LOG.warn("Interrupted while waiting for the wal of '" + region + "' to roll. If later replication tests fail, it's probably because we should still be waiting.");
            Thread.currentThread().interrupt();
        }
        region.getWAL().unregisterWALActionsListener(listener);
    }

    private void checkWithWait(byte[] row, int count, Table table) throws Exception {
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time while getting the row.");
            }
            boolean rowReplicated = false;
            Result res = table.get(get);
            if (res.size() >= 1) {
                LOG.info("Row is replicated");
                rowReplicated = true;
                Assert.assertEquals((String)("Table '" + table + "' did not have the expected number of  results."), (long)count, (long)res.size());
                break;
            }
            if (rowReplicated) break;
            Thread.sleep(500L);
        }
    }

    private void checkRow(byte[] row, int count, Table ... tables) throws IOException {
        Get get = new Get(row);
        for (Table table : tables) {
            Result res = table.get(get);
            Assert.assertEquals((String)("Table '" + table + "' did not have the expected number of results."), (long)count, (long)res.size());
        }
    }

    private void deleteAndWait(byte[] row, Table source, Table ... targets) throws Exception {
        Delete del = new Delete(row);
        source.delete(del);
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            boolean removedFromAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.size() < 1) continue;
                LOG.info("Row not deleted");
                removedFromAll = false;
                break;
            }
            if (removedFromAll) break;
            Thread.sleep(500L);
        }
    }

    private void putAndWait(byte[] row, byte[] fam, Table source, Table ... targets) throws Exception {
        Put put = new Put(row);
        put.addColumn(fam, row, row);
        source.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            boolean replicatedToAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.isEmpty()) {
                    LOG.info("Row not available");
                    replicatedToAll = false;
                    break;
                }
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
            }
            if (replicatedToAll) break;
            Thread.sleep(500L);
        }
    }

    static {
        tableName = TableName.valueOf((String)"test");
        famName = Bytes.toBytes((String)"f");
        row = Bytes.toBytes((String)"row");
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        row3 = Bytes.toBytes((String)"row3");
        noRepfamName = Bytes.toBytes((String)"norep");
    }
}

