/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncRegionServerAdmin;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestHBaseReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseReplicationEndpoint.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHBaseReplicationEndpoint.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private HBaseReplicationEndpoint endpoint;

    @Before
    public void setUp() throws Exception {
        try {
            ReplicationEndpoint.Context context = new ReplicationEndpoint.Context(null, UTIL.getConfiguration(), UTIL.getConfiguration(), null, null, null, null, null, null, null);
            this.endpoint = new DummyHBaseReplicationEndpoint();
            this.endpoint.init(context);
        }
        catch (Exception e) {
            LOG.info("Failed", (Throwable)e);
        }
    }

    @Test
    public void testChooseSinks() {
        ArrayList serverNames = Lists.newArrayList();
        int totalServers = 20;
        for (int i = 0; i < totalServers; ++i) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        ((DummyHBaseReplicationEndpoint)this.endpoint).setRegionServers(serverNames);
        this.endpoint.chooseSinks();
        int expected = (int)((float)totalServers * 0.5f);
        Assert.assertEquals((long)expected, (long)this.endpoint.getNumSinks());
    }

    @Test
    public void testChooseSinksLessThanRatioAvailable() {
        ArrayList serverNames = Lists.newArrayList((Object[])new ServerName[]{(ServerName)Mockito.mock(ServerName.class), (ServerName)Mockito.mock(ServerName.class)});
        ((DummyHBaseReplicationEndpoint)this.endpoint).setRegionServers(serverNames);
        this.endpoint.chooseSinks();
        Assert.assertEquals((long)1L, (long)this.endpoint.getNumSinks());
    }

    @Test
    public void testReportBadSink() {
        ServerName serverNameA = (ServerName)Mockito.mock(ServerName.class);
        ServerName serverNameB = (ServerName)Mockito.mock(ServerName.class);
        ((DummyHBaseReplicationEndpoint)this.endpoint).setRegionServers(Lists.newArrayList((Object[])new ServerName[]{serverNameA, serverNameB}));
        this.endpoint.chooseSinks();
        Assert.assertEquals((long)1L, (long)this.endpoint.getNumSinks());
        HBaseReplicationEndpoint.SinkPeer sinkPeer = new HBaseReplicationEndpoint.SinkPeer(serverNameA, (AsyncRegionServerAdmin)Mockito.mock(AsyncRegionServerAdmin.class));
        this.endpoint.reportBadSink(sinkPeer);
        Assert.assertEquals((long)1L, (long)this.endpoint.getNumSinks());
    }

    @Test
    public void testReportBadSinkPastThreshold() {
        int i;
        ArrayList serverNames = Lists.newArrayList();
        int totalServers = 30;
        for (int i2 = 0; i2 < totalServers; ++i2) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        ((DummyHBaseReplicationEndpoint)this.endpoint).setRegionServers(serverNames);
        this.endpoint.chooseSinks();
        int expected = (int)((float)totalServers * 0.5f);
        Assert.assertEquals((long)expected, (long)this.endpoint.getNumSinks());
        ServerName badSinkServer0 = (ServerName)this.endpoint.getSinkServers().get(0);
        HBaseReplicationEndpoint.SinkPeer sinkPeer = new HBaseReplicationEndpoint.SinkPeer(badSinkServer0, (AsyncRegionServerAdmin)Mockito.mock(AsyncRegionServerAdmin.class));
        for (int i3 = 0; i3 <= 3; ++i3) {
            this.endpoint.reportBadSink(sinkPeer);
        }
        Assert.assertEquals((long)(expected - 1), (long)this.endpoint.getNumSinks());
        ServerName badSinkServer1 = (ServerName)this.endpoint.getSinkServers().get(0);
        sinkPeer = new HBaseReplicationEndpoint.SinkPeer(badSinkServer1, (AsyncRegionServerAdmin)Mockito.mock(AsyncRegionServerAdmin.class));
        for (i = 0; i < 3; ++i) {
            this.endpoint.reportBadSink(sinkPeer);
        }
        this.endpoint.reportSinkSuccess(sinkPeer);
        this.endpoint.reportBadSink(sinkPeer);
        Assert.assertEquals((long)(expected - 1), (long)this.endpoint.getNumSinks());
        for (i = 0; i < 2; ++i) {
            this.endpoint.reportBadSink(sinkPeer);
        }
        Assert.assertEquals((long)(expected - 1), (long)this.endpoint.getNumSinks());
        this.endpoint.reportBadSink(sinkPeer);
        Assert.assertEquals((long)(expected - 2), (long)this.endpoint.getNumSinks());
    }

    @Test
    public void testReportBadSinkDownToZeroSinks() {
        ArrayList serverNames = Lists.newArrayList();
        int totalServers = 4;
        for (int i = 0; i < totalServers; ++i) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        ((DummyHBaseReplicationEndpoint)this.endpoint).setRegionServers(serverNames);
        this.endpoint.chooseSinks();
        int expected = (int)((float)totalServers * 0.5f);
        Assert.assertEquals((long)expected, (long)this.endpoint.getNumSinks());
        ServerName serverNameA = (ServerName)this.endpoint.getSinkServers().get(0);
        ServerName serverNameB = (ServerName)this.endpoint.getSinkServers().get(1);
        HBaseReplicationEndpoint.SinkPeer sinkPeerA = new HBaseReplicationEndpoint.SinkPeer(serverNameA, (AsyncRegionServerAdmin)Mockito.mock(AsyncRegionServerAdmin.class));
        HBaseReplicationEndpoint.SinkPeer sinkPeerB = new HBaseReplicationEndpoint.SinkPeer(serverNameB, (AsyncRegionServerAdmin)Mockito.mock(AsyncRegionServerAdmin.class));
        for (int i = 0; i <= 3; ++i) {
            this.endpoint.reportBadSink(sinkPeerA);
            this.endpoint.reportBadSink(sinkPeerB);
        }
        expected = (int)((float)(totalServers - 2) * 0.5f);
        Assert.assertEquals((long)expected, (long)this.endpoint.getNumSinks());
    }

    private static class DummyHBaseReplicationEndpoint
    extends HBaseReplicationEndpoint {
        List<ServerName> regionServers;

        private DummyHBaseReplicationEndpoint() {
        }

        public void setRegionServers(List<ServerName> regionServers) {
            this.regionServers = regionServers;
        }

        public List<ServerName> fetchSlavesAddresses() {
            return this.regionServers;
        }

        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            return false;
        }

        public AsyncClusterConnection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

