/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;

public class ReplicationSourceDummy
implements ReplicationSourceInterface {
    private ReplicationSourceManager manager;
    private ReplicationPeer replicationPeer;
    private ReplicationQueueId queueId;
    private Path currentPath;
    private MetricsSource metrics;
    private WALFileLengthProvider walFileLengthProvider;
    private AtomicBoolean startup = new AtomicBoolean(false);

    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueueStorage rq, ReplicationPeer rp, Server server, ReplicationQueueData queueData, UUID clusterId, WALFileLengthProvider walFileLengthProvider, MetricsSource metrics) throws IOException {
        this.manager = manager;
        this.queueId = queueData.getId();
        this.metrics = metrics;
        this.walFileLengthProvider = walFileLengthProvider;
        this.replicationPeer = rp;
    }

    public void enqueueLog(Path log) {
        this.currentPath = log;
        this.metrics.incrSizeOfLogQueue();
    }

    public Path getCurrentPath() {
        return this.currentPath;
    }

    public ReplicationSourceInterface startup() {
        this.startup.set(true);
        return this;
    }

    public boolean isStartup() {
        return this.startup.get();
    }

    public void terminate(String reason) {
        this.terminate(reason, null);
    }

    public void terminate(String reason, Exception e) {
        this.terminate(reason, e, true);
    }

    public void terminate(String reason, Exception e, boolean clearMetrics) {
        if (clearMetrics) {
            this.metrics.clear();
        } else {
            this.metrics.terminate();
        }
    }

    public ReplicationQueueId getQueueId() {
        return this.queueId;
    }

    public String getPeerId() {
        return this.queueId.getPeerId();
    }

    public String getStats() {
        return "";
    }

    public void addHFileRefs(TableName tableName, byte[] family, List<Pair<Path, Path>> files) throws ReplicationException {
    }

    public boolean isPeerEnabled() {
        return true;
    }

    public boolean isSourceActive() {
        return true;
    }

    public MetricsSource getSourceMetrics() {
        return this.metrics;
    }

    public ReplicationEndpoint getReplicationEndpoint() {
        return null;
    }

    public ReplicationSourceManager getSourceManager() {
        return this.manager;
    }

    public void tryThrottle(int batchSize) throws InterruptedException {
    }

    public void postShipEdits(List<WAL.Entry> entries, long batchSize) {
    }

    public WALFileLengthProvider getWALFileLengthProvider() {
        return this.walFileLengthProvider;
    }

    public ServerName getServerWALsBelongTo() {
        return null;
    }

    public ReplicationQueueStorage getReplicationQueueStorage() {
        return null;
    }

    public ReplicationPeer getPeer() {
        return this.replicationPeer;
    }
}

