/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.DualAsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;

class DualAsyncFSWALForTest
extends DualAsyncFSWAL {
    private boolean localBroken;
    private boolean remoteBroken;
    private CountDownLatch arrive;
    private CountDownLatch resume;

    public DualAsyncFSWALForTest(FileSystem fs, FileSystem remoteFs, Path rootDir, Path remoteWALDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
        super(fs, remoteFs, rootDir, remoteWALDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass);
    }

    protected WALProvider.AsyncWriter createCombinedAsyncWriter(WALProvider.AsyncWriter localWriter, WALProvider.AsyncWriter remoteWriter) {
        return new MyCombinedAsyncWriter(localWriter, remoteWriter);
    }

    protected WALProvider.AsyncWriter createWriterInstance(Path path) throws IOException {
        if (this.arrive != null) {
            this.arrive.countDown();
            try {
                this.resume.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.localBroken || this.remoteBroken) {
            throw new IOException("WAL broken");
        }
        return super.createWriterInstance(path);
    }

    public void setLocalBroken() {
        this.localBroken = true;
    }

    public void setRemoteBroken() {
        this.remoteBroken = true;
    }

    public void suspendLogRoll() {
        this.arrive = new CountDownLatch(1);
        this.resume = new CountDownLatch(1);
    }

    public void waitUntilArrive() throws InterruptedException {
        this.arrive.await();
    }

    public void resumeLogRoll() {
        this.resume.countDown();
    }

    private final class MyCombinedAsyncWriter
    implements WALProvider.AsyncWriter {
        private final WALProvider.AsyncWriter localWriter;
        private final WALProvider.AsyncWriter remoteWriter;

        public MyCombinedAsyncWriter(WALProvider.AsyncWriter localWriter, WALProvider.AsyncWriter remoteWriter) {
            this.localWriter = localWriter;
            this.remoteWriter = remoteWriter;
        }

        public long getLength() {
            return this.localWriter.getLength();
        }

        public long getSyncedLength() {
            return this.localWriter.getSyncedLength();
        }

        public void close() throws IOException {
            Closeables.close((Closeable)this.localWriter, (boolean)true);
            Closeables.close((Closeable)this.remoteWriter, (boolean)true);
        }

        public CompletableFuture<Long> sync(boolean forceSync) {
            CompletableFuture remoteFuture;
            CompletableFuture localFuture;
            if (!DualAsyncFSWALForTest.this.localBroken) {
                localFuture = this.localWriter.sync(forceSync);
            } else {
                localFuture = new CompletableFuture();
                localFuture.completeExceptionally(new IOException("Inject error"));
            }
            if (!DualAsyncFSWALForTest.this.remoteBroken) {
                remoteFuture = this.remoteWriter.sync(forceSync);
            } else {
                remoteFuture = new CompletableFuture();
                remoteFuture.completeExceptionally(new IOException("Inject error"));
            }
            return CompletableFuture.allOf(localFuture, remoteFuture).thenApply(v -> localFuture.getNow(0L));
        }

        public void append(WAL.Entry entry) {
            if (!DualAsyncFSWALForTest.this.localBroken) {
                this.localWriter.append(entry);
            }
            if (!DualAsyncFSWALForTest.this.remoteBroken) {
                this.remoteWriter.append(entry);
            }
        }
    }
}

