/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALSyncTimeoutIOException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestWALSyncTimeoutException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALSyncTimeoutException.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"family_test");
    private static final byte[] QUAL = Bytes.toBytes((String)"qualifier_test");
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static TableName tableName = TableName.valueOf((String)"TestWALSyncTimeoutException");
    private static volatile boolean testWALTimout = false;
    private static final long timeoutMIlliseconds = 3000L;
    private static final String USER_THREAD_NAME = tableName.getNameAsString();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setClass("hbase.hregion.impl", HRegionForTest.class, HRegion.class);
        conf.setInt("hbase.region.read-replica.sink.retries.number", 1);
        conf.setLong("hbase.region.read-replica.sink.rpc.timeout.ms", 600000L);
        conf.setLong("hbase.region.read-replica.sink.operation.timeout.ms", 1200000L);
        conf.setLong("hbase.region.read-replica.sink.meta-edit.rpc.timeout.ms", 600000L);
        conf.setLong("hbase.region.read-replica.sink.meta-edit.operation.timeout.ms", 1200000L);
        conf.setClass("hbase.wal.provider", SlowAsyncFSWALProvider.class, WALProvider.class);
        conf.setLong("hbase.regionserver.wal.sync.timeout", 3000L);
        HTU.startMiniCluster(StartTestingClusterOption.builder().numRegionServers(1).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALSyncWriteException() throws Exception {
        HRegionForTest region = this.createTable();
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(USER_THREAD_NAME);
        try {
            byte[] rowKey1 = Bytes.toBytes((int)1);
            byte[] value1 = Bytes.toBytes((int)3);
            Thread.sleep(2000L);
            testWALTimout = true;
            try {
                region.put(new Put(rowKey1).addColumn(FAMILY, QUAL, value1));
                Assert.fail();
            }
            catch (WALSyncTimeoutIOException e) {
                Assert.assertTrue((e != null ? 1 : 0) != 0);
            }
            Assert.assertTrue((boolean)region.getRSServices().isAborted());
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
            testWALTimout = false;
        }
    }

    private HRegionForTest createTable() throws Exception {
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        HTU.getAdmin().createTable(tableDescriptor);
        HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(0);
        return (HRegionForTest)((Object)rs.getRegions(tableName).get(0));
    }

    public static class SlowAsyncFSWALProvider
    extends AsyncFSWALProvider {
        protected AsyncFSWAL createWAL() throws IOException {
            return new SlowAsyncFSWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), this.abortable, CommonFSUtils.getWALRootDir((Configuration)this.conf), SlowAsyncFSWALProvider.getWALDirectoryName((String)this.factory.getFactoryId()), SlowAsyncFSWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.getFactoryId()), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null, this.eventLoopGroup, this.channelClass, this.factory.getExcludeDatanodeManager().getStreamSlowMonitor(this.providerId));
        }
    }

    public static class SlowAsyncFSWAL
    extends AsyncFSWAL {
        public SlowAsyncFSWAL(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, StreamSlowMonitor monitor) throws FailedLogCloseException, IOException {
            super(fs, abortable, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass, monitor);
        }

        public SlowAsyncFSWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass);
        }

        protected void atHeadOfRingBufferEventHandlerAppend() {
            if (testWALTimout) {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.atHeadOfRingBufferEventHandlerAppend();
        }
    }

    public static final class HRegionForTest
    extends HRegion {
        public HRegionForTest(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        public HRegionForTest(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public RegionServerServices getRSServices() {
            return this.rsServices;
        }
    }
}

