/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.NoEOFWALStreamReader;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestDurability {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDurability.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static FileSystem FS;
    private static MiniDFSCluster CLUSTER;
    private static Configuration CONF;
    private static Path DIR;
    private static byte[] FAMILY;
    private static byte[] ROW;
    private static byte[] COL;
    @Parameterized.Parameter
    public String walProvider;
    @Rule
    public TestName name = new TestName();

    @Parameterized.Parameters(name="{index}: provider={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"defaultProvider"}, {"asyncfs"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(1);
        CLUSTER = TEST_UTIL.getDFSCluster();
        FS = CLUSTER.getFileSystem();
        DIR = TEST_UTIL.getDataTestDirOnTestFS("TestDurability");
        CommonFSUtils.setRootDir((Configuration)CONF, (Path)DIR);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        CONF.set("hbase.wal.provider", this.walProvider);
    }

    @After
    public void tearDown() throws IOException {
        FS.delete(DIR, true);
    }

    @Test
    public void testDurability() throws Exception {
        WALFactory wals = new WALFactory(CONF, ServerName.valueOf((String)"TestDurability", (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString());
        HRegion region = this.createHRegion(wals, Durability.USE_DEFAULT);
        WAL wal = region.getWAL();
        HRegion deferredRegion = this.createHRegion(region.getTableDescriptor(), region.getRegionInfo(), "deferredRegion", wal, Durability.ASYNC_WAL);
        region.put(this.newPut(null));
        this.verifyWALCount(wals, wal, 1);
        deferredRegion.put(this.newPut(null));
        wal.sync();
        this.verifyWALCount(wals, wal, 2);
        deferredRegion.put(this.newPut(null));
        wal.sync();
        this.verifyWALCount(wals, wal, 3);
        region.put(this.newPut(null));
        this.verifyWALCount(wals, wal, 4);
        deferredRegion.put(this.newPut(Durability.USE_DEFAULT));
        wal.sync();
        this.verifyWALCount(wals, wal, 5);
        region.put(this.newPut(Durability.USE_DEFAULT));
        this.verifyWALCount(wals, wal, 6);
        region.put(this.newPut(Durability.SKIP_WAL));
        deferredRegion.put(this.newPut(Durability.SKIP_WAL));
        this.verifyWALCount(wals, wal, 6);
        wal.sync();
        this.verifyWALCount(wals, wal, 6);
        region.put(this.newPut(Durability.ASYNC_WAL));
        deferredRegion.put(this.newPut(Durability.ASYNC_WAL));
        wal.sync();
        this.verifyWALCount(wals, wal, 8);
        region.put(this.newPut(Durability.SYNC_WAL));
        deferredRegion.put(this.newPut(Durability.SYNC_WAL));
        this.verifyWALCount(wals, wal, 10);
        region.put(this.newPut(Durability.FSYNC_WAL));
        deferredRegion.put(this.newPut(Durability.FSYNC_WAL));
        this.verifyWALCount(wals, wal, 12);
    }

    @Test
    public void testIncrement() throws Exception {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        WALFactory wals = new WALFactory(CONF, ServerName.valueOf((String)"TestIncrement", (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString());
        HRegion region = this.createHRegion(wals, Durability.USE_DEFAULT);
        WAL wal = region.getWAL();
        Increment inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 0L);
        Result res = region.increment(inc1);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col1)));
        this.verifyWALCount(wals, wal, 1);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 1L);
        res = region.increment(inc1);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col1)));
        this.verifyWALCount(wals, wal, 2);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 0L);
        res = region.increment(inc1);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col1)));
        this.verifyWALCount(wals, wal, 3);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 0L);
        inc1.addColumn(FAMILY, col2, 0L);
        inc1.addColumn(FAMILY, col3, 0L);
        res = region.increment(inc1);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col1)));
        Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col2)));
        Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col3)));
        this.verifyWALCount(wals, wal, 4);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 5L);
        inc1.addColumn(FAMILY, col2, 4L);
        inc1.addColumn(FAMILY, col3, 3L);
        res = region.increment(inc1);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col1)));
        Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col2)));
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])res.getValue(FAMILY, col3)));
        this.verifyWALCount(wals, wal, 5);
    }

    @Test
    public void testIncrementWithReturnResultsSetToFalse() throws Exception {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        WALFactory wals = new WALFactory(CONF, ServerName.valueOf((String)"testIncrementWithReturnResultsSetToFalse", (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString());
        HRegion region = this.createHRegion(wals, Durability.USE_DEFAULT);
        Increment inc1 = new Increment(row1);
        inc1.setReturnResults(false);
        inc1.addColumn(FAMILY, col1, 1L);
        Result res = region.increment(inc1);
        Assert.assertTrue((boolean)res.isEmpty());
    }

    private Put newPut(Durability durability) {
        Put p = new Put(ROW);
        p.addColumn(FAMILY, COL, COL);
        if (durability != null) {
            p.setDurability(durability);
        }
        return p;
    }

    private void verifyWALCount(WALFactory wals, WAL log, int expected) throws Exception {
        Path walPath = AbstractFSWALProvider.getCurrentFileName((WAL)log);
        Assert.assertEquals((long)expected, (long)NoEOFWALStreamReader.count(wals, FS, walPath));
    }

    private HRegion createHRegion(WALFactory wals, Durability durability) throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName().replaceAll("[^A-Za-z0-9-_]", "_"));
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        Path path = new Path(DIR, tableName.getNameAsString());
        if (FS.exists(path) && !FS.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return HRegion.createHRegion((RegionInfo)info, (Path)path, (Configuration)CONF, (TableDescriptor)htd, (WAL)wals.getWAL(info));
    }

    private HRegion createHRegion(TableDescriptor td, RegionInfo info, String dir, WAL wal, Durability durability) throws IOException {
        Path path = new Path(DIR, dir);
        if (FS.exists(path) && !FS.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return HRegion.createHRegion((RegionInfo)info, (Path)path, (Configuration)CONF, (TableDescriptor)td, (WAL)wal);
    }

    static {
        FAMILY = Bytes.toBytes((String)"family");
        ROW = Bytes.toBytes((String)"row");
        COL = Bytes.toBytes((String)"col");
    }
}

