/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestProtobufLog;
import org.apache.hadoop.hbase.regionserver.wal.WriterOverAsyncWriter;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestAsyncProtobufLog
extends AbstractTestProtobufLog {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncProtobufLog.class);
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        AbstractTestProtobufLog.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractTestProtobufLog.tearDownAfterClass();
        EVENT_LOOP_GROUP.shutdownGracefully().syncUninterruptibly();
    }

    @Override
    protected WALProvider.Writer createWriter(Path path) throws IOException {
        return new WriterOverAsyncWriter((WALProvider.AsyncWriter)AsyncFSWALProvider.createAsyncWriter((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)this.fs, (Path)path, (boolean)false, (EventLoopGroup)EVENT_LOOP_GROUP.next(), CHANNEL_CLASS));
    }
}

