/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestStartupWithLegacyRegionReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStartupWithLegacyRegionReplicationEndpoint.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().addReplicationPeer("1", ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getZkCluster().getAddress().toString() + ":/1").build());
        UTIL.getAdmin().removeReplicationPeer("1");
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        String peerId = "legacy";
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").setReplicationEndpointImpl("org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint").build();
        SingleProcessHBaseCluster cluster = UTIL.getMiniHBaseCluster();
        HMaster master = cluster.getMaster();
        master.getReplicationPeerManager().addPeer(peerId, peerConfig, true);
        ServerName rsName = cluster.getRegionServer(0).getServerName();
        master.getReplicationPeerManager().getQueueStorage().setOffset(new ReplicationQueueId(rsName, "region_replica_replication"), "", new ReplicationGroupOffset("test-wal-file", 0L), Collections.emptyMap());
        cluster.stopRegionServer(0);
        JVMClusterUtil.RegionServerThread rst = cluster.startRegionServer();
        Assert.assertNotNull((Object)UTIL.getAdmin().getReplicationPeerConfig(peerId));
        Assert.assertTrue((boolean)rst.getRegionServer().getReplicationSourceService().getReplicationManager().getSources().stream().map(ReplicationSourceInterface::getPeerId).noneMatch(p -> p.equals(peerId)));
        UTIL.shutdownMiniHBaseCluster();
        UTIL.restartHBaseCluster(1);
        Assert.assertThrows(ReplicationPeerNotFoundException.class, () -> UTIL.getAdmin().getReplicationPeerConfig("legacy"));
        UTIL.waitFor(15000L, () -> UTIL.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).map(p -> (ServerCrashProcedure)p).allMatch(Procedure::isSuccess));
        ReplicationPeerManager ppm = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager();
        UTIL.waitFor(15000L, () -> !ppm.getPeerStorage().listPeerIds().contains(peerId) && ppm.getQueueStorage().listAllQueueIds(peerId, rsName).isEmpty());
    }
}

