/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationSink;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALSyncTimeoutIOException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionReplicationForWriteException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationForWriteException.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"family_test");
    private static final byte[] QUAL = Bytes.toBytes((String)"qualifier_test");
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static final int NB_SERVERS = 2;
    private static TableName tableName = TableName.valueOf((String)"TestRegionReplicationForWriteException");
    private static volatile boolean testWALTimout = false;
    private static volatile boolean testCP = false;
    private static final long timeoutMIlliseconds = 3000L;
    private static final String USER_THREAD_NAME = tableName.getNameAsString();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setClass("hbase.hregion.impl", HRegionForTest.class, HRegion.class);
        conf.setInt("hbase.region.read-replica.sink.retries.number", 1);
        conf.setLong("hbase.region.read-replica.sink.rpc.timeout.ms", 600000L);
        conf.setLong("hbase.region.read-replica.sink.operation.timeout.ms", 1200000L);
        conf.setLong("hbase.region.read-replica.sink.meta-edit.rpc.timeout.ms", 600000L);
        conf.setLong("hbase.region.read-replica.sink.meta-edit.operation.timeout.ms", 1200000L);
        conf.setBoolean("hbase.region.replica.wait.for.primary.flush", false);
        conf.setInt("hbase.region.read-replica.sink.flush.min-interval.secs", 3);
        conf.setClass("hbase.wal.provider", SlowAsyncFSWALProvider.class, WALProvider.class);
        conf.setLong("hbase.regionserver.wal.sync.timeout", 3000L);
        HTU.startMiniCluster(StartTestingClusterOption.builder().numRegionServers(2).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteException() throws Exception {
        HRegionForTest[] regions = this.createTable();
        RegionReplicationSink regionReplicationSink = (RegionReplicationSink)regions[0].getRegionReplicationSink().get();
        Assert.assertTrue((regionReplicationSink != null ? 1 : 0) != 0);
        AtomicInteger replicateCounter = new AtomicInteger(0);
        this.setUpSpiedRegionReplicationSink(regionReplicationSink, regions[0], replicateCounter);
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(USER_THREAD_NAME);
        try {
            Throwable throwable;
            Table table;
            testCP = true;
            try {
                byte[] rowKey1 = Bytes.toBytes((int)1);
                byte[] value1 = Bytes.toBytes((int)3);
                try {
                    regions[0].put(new Put(rowKey1).addColumn(FAMILY, QUAL, value1));
                    Assert.fail();
                }
                catch (DoNotRetryIOException e) {
                    Assert.assertTrue((boolean)e.getMessage().equals("Inject error!"));
                }
                table = HTU.getConnection().getTable(tableName);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)TestRegionReplicationForWriteException.checkReplica(table, FAMILY, QUAL, rowKey1, value1, 0));
                    HTU.waitFor(30000L, () -> TestRegionReplicationForWriteException.checkReplica(table, FAMILY, QUAL, rowKey1, value1, 1));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (table != null) {
                        if (throwable != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            table.close();
                        }
                    }
                }
            }
            finally {
                testCP = false;
            }
            byte[] rowKey2 = Bytes.toBytes((int)2);
            byte[] value2 = Bytes.toBytes((int)6);
            replicateCounter.set(0);
            testWALTimout = true;
            try {
                try {
                    regions[0].put(new Put(rowKey2).addColumn(FAMILY, QUAL, value2));
                    Assert.fail();
                }
                catch (WALSyncTimeoutIOException e) {
                    Assert.assertTrue((e != null ? 1 : 0) != 0);
                }
                Assert.assertTrue((boolean)regions[0].getRSServices().isAborted());
                Assert.assertTrue((replicateCounter.get() == 0 ? 1 : 0) != 0);
                Thread.sleep(2000L);
                table = HTU.getConnection().getTable(tableName);
                throwable = null;
                try {
                    Assert.assertFalse((boolean)TestRegionReplicationForWriteException.checkReplica(table, FAMILY, QUAL, rowKey2, value2, 1));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (table != null) {
                        if (throwable != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            table.close();
                        }
                    }
                }
            }
            finally {
                testWALTimout = false;
            }
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private RegionReplicationSink setUpSpiedRegionReplicationSink(RegionReplicationSink regionReplicationSink, HRegionForTest primaryRegion, AtomicInteger counter) {
        RegionReplicationSink spiedRegionReplicationSink = (RegionReplicationSink)Mockito.spy((Object)regionReplicationSink);
        ((RegionReplicationSink)Mockito.doAnswer(invocationOnMock -> {
            if (!testWALTimout || !USER_THREAD_NAME.equals(Thread.currentThread().getName())) {
                invocationOnMock.callRealMethod();
                return null;
            }
            WALKeyImpl walKey = (WALKeyImpl)invocationOnMock.getArgument(0);
            if (!walKey.getTableName().equals((Object)tableName)) {
                invocationOnMock.callRealMethod();
                return null;
            }
            counter.incrementAndGet();
            invocationOnMock.callRealMethod();
            return null;
        }).when((Object)spiedRegionReplicationSink)).add((WALKeyImpl)Mockito.any(), (WALEdit)Mockito.any(), (ServerCall)Mockito.any());
        primaryRegion.setRegionReplicationSink(spiedRegionReplicationSink);
        return spiedRegionReplicationSink;
    }

    private static boolean checkReplica(Table table, byte[] fam, byte[] qual, byte[] rowKey, byte[] expectValue, int replicaId) throws IOException {
        Get get = new Get(rowKey).setConsistency(Consistency.TIMELINE).setReplicaId(replicaId);
        Result result = table.get(get);
        byte[] value = result.getValue(fam, qual);
        return value != null && value.length > 0 && Arrays.equals(expectValue, value);
    }

    private HRegionForTest[] createTable() throws Exception {
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(2).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(MyRegionObserver.class.getName()).build();
        HTU.getAdmin().createTable(tableDescriptor);
        HRegionForTest[] regions = new HRegionForTest[2];
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                int replicaId = region.getRegionInfo().getReplicaId();
                Assert.assertTrue((regions[replicaId] == null ? 1 : 0) != 0);
                regions[region.getRegionInfo().getReplicaId()] = (HRegionForTest)region;
            }
        }
        for (HRegionForTest region : regions) {
            Assert.assertNotNull((Object)((Object)region));
        }
        return regions;
    }

    public static class MyRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        private static final String ERROR_MESSAGE = "Inject error!";

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            if (!testCP || !RegionReplicaUtil.isDefaultReplica((RegionInfo)((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo())) {
                return;
            }
            throw new DoNotRetryIOException(ERROR_MESSAGE);
        }
    }

    public static class SlowAsyncFSWALProvider
    extends AsyncFSWALProvider {
        protected AsyncFSWAL createWAL() throws IOException {
            return new SlowAsyncFSWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), this.abortable, CommonFSUtils.getWALRootDir((Configuration)this.conf), SlowAsyncFSWALProvider.getWALDirectoryName((String)this.factory.getFactoryId()), SlowAsyncFSWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.getFactoryId()), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null, this.eventLoopGroup, this.channelClass, this.factory.getExcludeDatanodeManager().getStreamSlowMonitor(this.providerId));
        }
    }

    public static class SlowAsyncFSWAL
    extends AsyncFSWAL {
        public SlowAsyncFSWAL(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, StreamSlowMonitor monitor) throws FailedLogCloseException, IOException {
            super(fs, abortable, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass, monitor);
        }

        public SlowAsyncFSWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass);
        }

        protected void atHeadOfRingBufferEventHandlerAppend() {
            if (testWALTimout) {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.atHeadOfRingBufferEventHandlerAppend();
        }
    }

    public static final class HRegionForTest
    extends HRegion {
        public HRegionForTest(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        public HRegionForTest(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public void setRegionReplicationSink(RegionReplicationSink regionReplicationSink) {
            this.regionReplicationSink = Optional.of(regionReplicationSink);
        }

        public RegionServerServices getRSServices() {
            return this.rsServices;
        }
    }
}

