/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestWideScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWideScanner.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestWideScanner.class);
    private static final byte[] A = Bytes.toBytes((String)"A");
    private static final byte[] B = Bytes.toBytes((String)"B");
    private static final byte[] C = Bytes.toBytes((String)"C");
    private static byte[][] COLUMNS = new byte[][]{A, B, C};
    private static final TableDescriptor TESTTABLEDESC;
    private static HRegion REGION;

    @BeforeClass
    public static void setUp() throws IOException {
        Path testDir = UTIL.getDataTestDir();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TESTTABLEDESC.getTableName()).build();
        REGION = HBaseTestingUtil.createRegionAndWAL(hri, testDir, UTIL.getConfiguration(), TESTTABLEDESC);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (REGION != null) {
            HBaseTestingUtil.closeRegionAndWAL(REGION);
            REGION = null;
        }
        UTIL.cleanupTestDir();
    }

    private int addWideContent(HRegion region) throws IOException {
        int count = 0;
        for (char c = 'a'; c <= 'c'; c = (char)(c + '\u0001')) {
            byte[] row = Bytes.toBytes((String)("ab" + c));
            long ts = EnvironmentEdgeManager.currentTime();
            for (int i = 0; i < 100; ++i) {
                byte[] b = Bytes.toBytes((String)String.format("%10d", i));
                for (int j = 0; j < 100; ++j) {
                    Put put = new Put(row);
                    put.setDurability(Durability.SKIP_WAL);
                    long ts1 = ++ts;
                    put.addColumn(COLUMNS[ThreadLocalRandom.current().nextInt(COLUMNS.length)], b, ts1, b);
                    region.put(put);
                    ++count;
                }
            }
        }
        return count;
    }

    @Test
    public void testWideScanBatching() throws IOException {
        int batch = 256;
        int inserted = this.addWideContent(REGION);
        ArrayList results = new ArrayList();
        Scan scan = new Scan();
        scan.addFamily(A);
        scan.addFamily(B);
        scan.addFamily(C);
        scan.readVersions(100);
        scan.setBatch(256);
        try (RegionScannerImpl s = REGION.getScanner(scan);){
            boolean more;
            int total = 0;
            int i = 0;
            do {
                more = s.next(results);
                LOG.info("iteration #" + ++i + ", results.size=" + results.size());
                Assert.assertTrue((results.size() <= 256 ? 1 : 0) != 0);
                total += results.size();
                if (results.size() > 0) {
                    byte[] row = CellUtil.cloneRow((Cell)((Cell)results.get(0)));
                    for (Cell kv : results) {
                        Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])CellUtil.cloneRow((Cell)kv)));
                    }
                }
                results.clear();
                for (StoreScanner ss : s.storeHeap.getHeap()) {
                    ss.updateReaders(Collections.emptyList(), Collections.emptyList());
                }
            } while (more);
            LOG.info("inserted " + inserted + ", scanned " + total);
            Assert.assertEquals((long)total, (long)inserted);
        }
    }

    static {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"testwidescan"));
        for (byte[] cfName : new byte[][]{A, B, C}) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cfName).setMaxVersions(100).setBlocksize(8192).build());
        }
        TESTTABLEDESC = builder.build();
    }
}

