/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestReplicasClient;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestSplitTransactionOnCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitTransactionOnCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitTransactionOnCluster.class);
    private Admin admin = null;
    private SingleProcessHBaseCluster cluster = null;
    private static final int NB_SERVERS = 3;
    static final HBaseTestingUtil TESTING_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        StartTestingClusterOption option = StartTestingClusterOption.builder().masterClass(MyMaster.class).numRegionServers(3).numDataNodes(3).build();
        TESTING_UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(3);
        this.admin = TESTING_UTIL.getAdmin();
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.admin.close();
        for (TableDescriptor htd : this.admin.listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            TESTING_UTIL.deleteTable(htd.getTableName());
        }
    }

    private RegionInfo getAndCheckSingleTableRegion(List<HRegion> regions) throws IOException, InterruptedException {
        Assert.assertEquals((long)1L, (long)regions.size());
        RegionInfo hri = regions.get(0).getRegionInfo();
        AssignmentTestingUtil.waitForAssignment(this.cluster.getMaster().getAssignmentManager(), hri);
        return hri;
    }

    private void requestSplitRegion(HRegionServer rsServer, Region region, byte[] midKey) throws IOException {
        long procId = this.cluster.getMaster().splitRegion(region.getRegionInfo(), midKey, 0L, 0L);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.cluster.getMaster().getMasterProcedureExecutor(), (long)procId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRITStateForRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = this.cluster.getMaster();
        try {
            Table t = this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            RegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            this.insertData(tableName, this.admin, t);
            t.close();
            this.admin.balancerSwitch(false, true);
            master.setCatalogJanitorEnabled(false);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            master.getMasterCoprocessorHost().load(FailingSplitMasterObserver.class, 0x3FFFFFFF, master.getConfiguration());
            this.admin.splitRegionAsync(region.getRegionInfo().getRegionName(), new byte[]{42});
            FailingSplitMasterObserver observer = (FailingSplitMasterObserver)master.getMasterCoprocessorHost().findCoprocessor(FailingSplitMasterObserver.class);
            Assert.assertNotNull((Object)observer);
            observer.latch.await();
            LOG.info("Waiting for region to come out of RIT");
            while (!this.cluster.getMaster().getAssignmentManager().getRegionStates().isRegionOnline(hri)) {
                Threads.sleep((long)100L);
            }
            Assert.assertTrue((boolean)this.cluster.getMaster().getAssignmentManager().getRegionStates().isRegionOnline(hri));
        }
        finally {
            this.admin.balancerSwitch(true, false);
            master.setCatalogJanitorEnabled(true);
            this.abortAndWaitForMaster();
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testSplitFailedCompactionAndSplit() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf = Bytes.toBytes((String)"cf");
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf)).build();
        this.admin.createTable(htd);
        for (int i = 0; this.cluster.getRegions(tableName).isEmpty() && i < 100; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)this.cluster.getRegions(tableName).size());
        HRegion region = this.cluster.getRegions(tableName).get(0);
        HStore store = region.getStore(cf);
        int regionServerIndex = this.cluster.getServerWith(region.getRegionInfo().getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        Table t = TESTING_UTIL.getConnection().getTable(tableName);
        this.insertData(tableName, this.admin, t);
        this.insertData(tableName, this.admin, t);
        int fileNum = store.getStorefiles().size();
        store.triggerMajorCompaction();
        Optional cc = store.requestCompaction();
        Assert.assertTrue((boolean)cc.isPresent());
        Assert.assertEquals((long)2L, (long)((List)region.close(false).get(cf)).size());
        region.initialize();
        Assert.assertFalse((boolean)region.compact((CompactionContext)cc.get(), store, (ThroughputController)NoLimitThroughputController.INSTANCE));
        Assert.assertTrue((fileNum > store.getStorefiles().size() ? 1 : 0) != 0);
        this.requestSplitRegion(regionServer, (Region)region, Bytes.toBytes((String)"row3"));
        Assert.assertEquals((long)2L, (long)this.cluster.getRegions(tableName).size());
    }

    @Test
    public void testSplitCompactWithPriority() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf = Bytes.toBytes((String)"cf");
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf)).build();
        this.admin.createTable(htd);
        Assert.assertNotEquals((String)"Unable to retrieve regions of the table", (long)-1L, (long)TESTING_UTIL.waitFor(10000L, () -> this.cluster.getRegions(tableName).size() == 1));
        HRegion region = this.cluster.getRegions(tableName).get(0);
        HStore store = region.getStore(cf);
        int regionServerIndex = this.cluster.getServerWith(region.getRegionInfo().getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        Table table = TESTING_UTIL.getConnection().getTable(tableName);
        this.insertData(tableName, this.admin, table);
        this.insertData(tableName, this.admin, table, 20);
        this.insertData(tableName, this.admin, table, 40);
        store.triggerMajorCompaction();
        Optional compactionContext = store.requestCompaction();
        Assert.assertTrue((boolean)compactionContext.isPresent());
        Assert.assertFalse((boolean)((CompactionContext)compactionContext.get()).getRequest().isAfterSplit());
        Assert.assertEquals((long)((CompactionContext)compactionContext.get()).getRequest().getPriority(), (long)13L);
        long procId = this.cluster.getMaster().splitRegion(region.getRegionInfo(), Bytes.toBytes((String)"row4"), 0L, 0L);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.cluster.getMaster().getMasterProcedureExecutor(), (long)procId);
        Thread.sleep(3000L);
        Assert.assertNotEquals((String)"Table is not split properly?", (long)-1L, (long)TESTING_UTIL.waitFor(3000L, () -> this.cluster.getRegions(tableName).size() == 2));
        HRegion hRegion1 = this.cluster.getRegions(tableName).get(0);
        HRegion hRegion2 = this.cluster.getRegions(tableName).get(1);
        HStore hStore1 = hRegion1.getStore(cf);
        HStore hStore2 = hRegion2.getStore(cf);
        StoreFileInfo storeFileInfo1 = ((HStoreFile)new ArrayList(hStore1.getStorefiles()).get(0)).getFileInfo();
        StoreFileInfo storeFileInfo2 = ((HStoreFile)new ArrayList(hStore2.getStorefiles()).get(0)).getFileInfo();
        Field field = StoreFileInfo.class.getDeclaredField("reference");
        field.setAccessible(true);
        field.set(storeFileInfo1, Mockito.mock(Reference.class));
        field.set(storeFileInfo2, Mockito.mock(Reference.class));
        hStore1.triggerMajorCompaction();
        hStore2.triggerMajorCompaction();
        compactionContext = hStore1.requestCompaction();
        Assert.assertTrue((boolean)compactionContext.isPresent());
        Assert.assertTrue((boolean)((CompactionContext)compactionContext.get()).getRequest().isAfterSplit());
        Assert.assertEquals((long)((CompactionContext)compactionContext.get()).getRequest().getPriority(), (long)-2147482648L);
        compactionContext = hStore2.requestCompaction(-2147483638, CompactionLifeCycleTracker.DUMMY, null);
        Assert.assertTrue((boolean)compactionContext.isPresent());
        Assert.assertTrue((boolean)((CompactionContext)compactionContext.get()).getRequest().isAfterSplit());
        Assert.assertEquals((long)((CompactionContext)compactionContext.get()).getRequest().getPriority(), (long)-2147483638L);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    @Test
    public void testContinuousSplitUsingLinkFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf = Bytes.toBytes((String)"cf");
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf));
        String splitPolicy = ConstantSizeRegionSplitPolicy.class.getName();
        builder.setValue("SPLIT_POLICY", splitPolicy);
        this.admin.createTable(builder.build());
        this.admin.compactionSwitch(false, new ArrayList());
        Assert.assertNotEquals((String)"Unable to retrieve regions of the table", (long)-1L, (long)TESTING_UTIL.waitFor(10000L, () -> this.cluster.getRegions(tableName).size() == 1));
        Table table = TESTING_UTIL.getConnection().getTable(tableName);
        this.insertData(tableName, this.admin, table, 10);
        this.insertData(tableName, this.admin, table, 20);
        this.insertData(tableName, this.admin, table, 40);
        int rowCount = 12;
        Scan scan = new Scan();
        TestSplitTransactionOnCluster.scanValidate(scan, rowCount, table);
        this.admin.splitRegionAsync(this.cluster.getRegions(tableName).get(0).getRegionInfo().getRegionName(), Bytes.toBytes((String)"row14"));
        Thread.sleep(3000L);
        Assert.assertNotEquals((String)"Table is not split properly?", (long)-1L, (long)TESTING_UTIL.waitFor(3000L, () -> this.cluster.getRegions(tableName).size() == 2));
        HRegion hRegion1 = this.cluster.getRegions(tableName).get(0);
        HRegion hRegion2 = this.cluster.getRegions(tableName).get(1);
        HStore hStore1 = hRegion1.getStore(cf);
        HStore hStore2 = hRegion2.getStore(cf);
        Assert.assertEquals((long)3L, (long)(hStore1.getStorefilesCount() + hStore2.getStorefilesCount()));
        for (StoreFile sf : hStore1.getStorefiles()) {
            Assert.assertTrue((boolean)HFileLink.isHFileLink((Path)sf.getPath()));
        }
        for (StoreFile sf : hStore2.getStorefiles()) {
            Assert.assertTrue((boolean)HFileLink.isHFileLink((Path)sf.getPath()));
        }
        scan = new Scan();
        TestSplitTransactionOnCluster.scanValidate(scan, rowCount, table);
        this.findRegionToSplit(tableName, "row24");
        Thread.sleep(3000L);
        Assert.assertNotEquals((String)"Table is not split properly?", (long)-1L, (long)TESTING_UTIL.waitFor(3000L, () -> this.cluster.getRegions(tableName).size() == 3));
        for (HRegion newRegion : this.cluster.getRegions(tableName)) {
            Assert.assertEquals((long)1L, (long)newRegion.getStore(cf).getStorefilesCount());
            Assert.assertTrue((boolean)HFileLink.isHFileLink((Path)((HStoreFile)newRegion.getStore(cf).getStorefiles().iterator().next()).getPath()));
        }
        scan = new Scan();
        TestSplitTransactionOnCluster.scanValidate(scan, rowCount, table);
        this.findRegionToSplit(tableName, "row11");
        Thread.sleep(3000L);
        Assert.assertNotEquals((String)"Table is not split properly?", (long)-1L, (long)TESTING_UTIL.waitFor(3000L, () -> this.cluster.getRegions(tableName).size() == 4));
        scan = new Scan();
        TestSplitTransactionOnCluster.scanValidate(scan, rowCount, table);
    }

    private void findRegionToSplit(TableName tableName, String splitRowKey) throws Exception {
        HRegion toSplit = null;
        byte[] toSplitKey = Bytes.toBytes((String)splitRowKey);
        for (HRegion rg : this.cluster.getRegions(tableName)) {
            LOG.debug("startKey=" + Bytes.toStringBinary((byte[])rg.getRegionInfo().getStartKey()) + ", getEndKey()=" + Bytes.toStringBinary((byte[])rg.getRegionInfo().getEndKey()) + ", row=" + splitRowKey);
            if (rg.getRegionInfo().getStartKey().length != 0 && CellComparator.getInstance().compare(PrivateCellUtil.createFirstOnRow((byte[])rg.getRegionInfo().getStartKey()), PrivateCellUtil.createFirstOnRow((byte[])toSplitKey)) > 0 || rg.getRegionInfo().getEndKey().length != 0 && CellComparator.getInstance().compare(PrivateCellUtil.createFirstOnRow((byte[])rg.getRegionInfo().getEndKey()), PrivateCellUtil.createFirstOnRow((byte[])toSplitKey)) < 0) continue;
            toSplit = rg;
        }
        Assert.assertNotNull(toSplit);
        this.admin.splitRegionAsync(toSplit.getRegionInfo().getRegionName(), toSplitKey);
    }

    private static void scanValidate(Scan scan, int expectedRowCount, Table table) throws IOException {
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        Assert.assertEquals((long)expectedRowCount, (long)rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitRollbackOnRegionClosing() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        RegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
        this.admin.balancerSwitch(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = this.cluster.getRegions(hri.getTable()).size();
            regionStates.updateRegionState(hri, RegionState.State.CLOSING);
            try {
                FutureUtils.get((Future)this.admin.splitRegionAsync(hri.getRegionName()));
                Assert.fail();
            }
            catch (DoNotRetryRegionException doNotRetryRegionException) {
                // empty catch block
            }
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                Assert.assertEquals((long)regionCount, (long)this.cluster.getRegions(hri.getTable()).size());
            }
            regionStates.updateRegionState(hri, RegionState.State.OPEN);
            this.admin.splitRegionAsync(hri.getRegionName()).get(2L, TimeUnit.MINUTES);
            this.checkAndGetDaughters(tableName);
        }
        finally {
            this.admin.balancerSwitch(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdownFixupWhenDaughterHasSplit() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        RegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.balancerSwitch(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            this.admin.splitRegionAsync(hri.getRegionName()).get(2L, TimeUnit.MINUTES);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            HRegion daughterRegion = daughters.get(0);
            RegionInfo daughter = daughterRegion.getRegionInfo();
            LOG.info("Daughter we are going to split: " + daughter);
            this.clearReferences(daughterRegion);
            LOG.info("Finished {} references={}", (Object)daughterRegion, (Object)daughterRegion.hasReferences());
            this.admin.splitRegionAsync(daughter.getRegionName()).get(2L, TimeUnit.MINUTES);
            daughters = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info("Regions before crash: " + d);
            }
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info("Regions after crash: " + d);
            }
            if (daughters.size() != regions.size()) {
                LOG.info("Daughters=" + daughters.size() + ", regions=" + regions.size());
            }
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                LOG.info("Regions post crash " + r + ", contains=" + daughters.contains(r));
                Assert.assertTrue((String)("Missing region post crash " + r), (boolean)daughters.contains(r));
            }
        }
        finally {
            LOG.info("EXITING");
            this.admin.balancerSwitch(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    private void clearReferences(HRegion region) throws IOException {
        Assert.assertEquals((long)1L, (long)region.getStores().size());
        HStore store = (HStore)region.getStores().get(0);
        while (store.hasReferences()) {
            while (store.storeEngine.getCompactor().isCompacting()) {
                Threads.sleep((long)100L);
            }
            region.compact(true);
            store.closeAndArchiveCompactedFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles() throws Exception {
        TableName userTableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)userTableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"col")).build();
        this.admin.createTable(htd);
        try (Table table = TESTING_UTIL.getConnection().getTable(userTableName);){
            Put p;
            for (int i = 0; i <= 5; ++i) {
                String row = "row" + i;
                p = new Put(Bytes.toBytes((String)row));
                String val = "Val" + i;
                p.addColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)val));
                table.put(p);
                this.admin.flush(userTableName);
                Delete d = new Delete(Bytes.toBytes((String)row));
                table.delete(d);
                this.admin.flush(userTableName);
            }
            this.admin.majorCompact(userTableName);
            List regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            Assert.assertEquals((long)1L, (long)regionsOfTable.size());
            RegionInfo hRegionInfo = (RegionInfo)regionsOfTable.get(0);
            p = new Put(Bytes.toBytes((String)"row6"));
            p.addColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)"val"));
            table.put(p);
            p = new Put(Bytes.toBytes((String)"row7"));
            p.addColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)"val"));
            table.put(p);
            p = new Put(Bytes.toBytes((String)"row8"));
            p.addColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)"val"));
            table.put(p);
            this.admin.flush(userTableName);
            this.admin.splitRegionAsync(hRegionInfo.getRegionName(), Bytes.toBytes((String)"row7"));
            regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            while (regionsOfTable.size() != 2) {
                Thread.sleep(1000L);
                regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
                LOG.debug("waiting 2 regions to be available, got " + regionsOfTable.size() + ": " + regionsOfTable);
            }
            Assert.assertEquals((long)2L, (long)regionsOfTable.size());
            Scan s = new Scan();
            ResultScanner scanner = table.getScanner(s);
            int mainTableCount = 0;
            Result rr = scanner.next();
            while (rr != null) {
                ++mainTableCount;
                rr = scanner.next();
            }
            Assert.assertEquals((long)3L, (long)mainTableCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterRestartAtRegionSplitPendingCatalogJanitor() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException, ExecutionException, TimeoutException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);){
            List<HRegion> regions = this.cluster.getRegions(tableName);
            RegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
            this.admin.balancerSwitch(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            this.admin.splitRegionAsync(hri.getRegionName()).get(2L, TimeUnit.MINUTES);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            HMaster master = this.abortAndWaitForMaster();
            for (HRegion daughter : daughters) {
                this.clearReferences(daughter);
                Assert.assertFalse((boolean)daughter.hasReferences());
            }
            for (JVMClusterUtil.RegionServerThread rst : this.cluster.getRegionServerThreads()) {
                boolean oldSetting = rst.getRegionServer().compactedFileDischarger.setUseExecutor(false);
                rst.getRegionServer().compactedFileDischarger.run();
                rst.getRegionServer().compactedFileDischarger.setUseExecutor(oldSetting);
            }
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            ProcedureTestingUtility.waitAllProcedures((ProcedureExecutor)this.cluster.getMaster().getMasterProcedureExecutor());
            LOG.info("Starting run of CatalogJanitor");
            this.cluster.getMaster().getCatalogJanitor().run();
            ProcedureTestingUtility.waitAllProcedures((ProcedureExecutor)this.cluster.getMaster().getMasterProcedureExecutor());
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            ServerName regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertEquals(null, (Object)regionServerOfRegion);
        }
        finally {
            TESTING_UTIL.getAdmin().balancerSwitch(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitWithRegionReplicas() throws Exception {
        List<HRegion> oldRegions;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TESTING_UTIL.createModifyableTableDescriptor(TableName.valueOf((String)this.name.getMethodName()), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED).setRegionReplication(2).setCoprocessor(TestReplicasClient.SlowMeCopro.class.getName()).build();
        Table t = TESTING_UTIL.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"cf")}, null);
        do {
            oldRegions = this.cluster.getRegions(tableName);
            Thread.sleep(10L);
        } while (oldRegions.size() != 2);
        for (HRegion h : oldRegions) {
            LOG.debug("OLDREGION " + h.getRegionInfo());
        }
        try {
            List<HRegion> newRegions;
            int regionServerIndex = this.cluster.getServerWith(oldRegions.get(0).getRegionInfo().getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName, this.admin, t);
            this.admin.balancerSwitch(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = TESTING_UTIL.getAdmin().tableExists(tableName);
            Assert.assertEquals((String)"The specified table should be present.", (Object)true, (Object)tableExists);
            HRegion region = this.findSplittableRegion(oldRegions);
            regionServerIndex = this.cluster.getServerWith(region.getRegionInfo().getRegionName());
            regionServer = this.cluster.getRegionServer(regionServerIndex);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            try {
                this.requestSplitRegion(regionServer, (Region)region, Bytes.toBytes((String)"row2"));
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("Split execution should have succeeded with no exceptions thrown " + e));
            }
            do {
                newRegions = this.cluster.getRegions(tableName);
                for (HRegion h : newRegions) {
                    LOG.debug("NEWREGION " + h.getRegionInfo());
                }
                Thread.sleep(1000L);
            } while (newRegions.contains(oldRegions.get(0)) || newRegions.contains(oldRegions.get(1)) || newRegions.size() != 4);
            tableExists = TESTING_UTIL.getAdmin().tableExists(tableName);
            Assert.assertEquals((String)"The specified table should be present.", (Object)true, (Object)tableExists);
            byte[] b1 = Bytes.toBytes((String)"row1");
            Get g = new Get(b1);
            g.setConsistency(Consistency.STRONG);
            Result r = t.get(g);
            Assert.assertFalse((boolean)r.isStale());
            LOG.info("exists stale after flush done");
            TestReplicasClient.SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = t.get(g);
            Assert.assertTrue((boolean)r.isStale());
            TestReplicasClient.SlowMeCopro.getPrimaryCdl().get().countDown();
        }
        finally {
            TestReplicasClient.SlowMeCopro.getPrimaryCdl().get().countDown();
            this.admin.balancerSwitch(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    private void insertData(TableName tableName, Admin admin, Table t) throws IOException {
        this.insertData(tableName, admin, t, 1);
    }

    private void insertData(TableName tableName, Admin admin, Table t, int i) throws IOException {
        Put p = new Put(Bytes.toBytes((String)("row" + i)));
        p.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"1"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)("row" + (i + 1))));
        p.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"2"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)("row" + (i + 2))));
        p.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"3"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)("row" + (i + 3))));
        p.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"4"));
        t.put(p);
        admin.flush(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitRegionWithNoStoreFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        RegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        this.admin.balancerSwitch(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            this.printOutRegions(regionServer, "Initial regions: ");
            Configuration conf = this.cluster.getConfiguration();
            HBaseFsck.debugLsr((Configuration)conf, (Path)new Path("/"));
            Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
            DistributedFileSystem fs = TESTING_UTIL.getDFSCluster().getFileSystem();
            Map storefiles = FSUtils.getTableStoreFilePathMap(null, (FileSystem)fs, (Path)rootDir, (TableName)tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefiles.toString()), (long)0L, (long)storefiles.size());
            regions = this.cluster.getRegions(tableName);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            try {
                this.requestSplitRegion(regionServer, (Region)region, Bytes.toBytes((String)"row2"));
            }
            catch (IOException e) {
                Assert.fail((String)"Split execution should have succeeded with no exceptions thrown");
            }
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertEquals((long)2L, (long)daughters.size());
            HBaseFsck.debugLsr((Configuration)conf, (Path)new Path("/"));
            Map storefilesAfter = FSUtils.getTableStoreFilePathMap(null, (FileSystem)fs, (Path)rootDir, (TableName)tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefilesAfter.toString()), (long)0L, (long)storefilesAfter.size());
            hri = region.getRegionInfo();
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            long start = EnvironmentEdgeManager.currentTime();
            while (!regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT})) {
                LOG.debug("Waiting for SPLIT state on: " + hri);
                Assert.assertFalse((String)"Timed out in waiting split parent to be in state SPLIT", (EnvironmentEdgeManager.currentTime() - start > 60000L ? 1 : 0) != 0);
                Thread.sleep(500L);
            }
            Assert.assertTrue((boolean)regionStates.isRegionInState(daughters.get(0).getRegionInfo(), new RegionState.State[]{RegionState.State.OPEN}));
            Assert.assertTrue((boolean)regionStates.isRegionInState(daughters.get(1).getRegionInfo(), new RegionState.State[]{RegionState.State.OPEN}));
            try {
                am.assign(hri);
            }
            catch (DoNotRetryIOException doNotRetryIOException) {
                // empty catch block
            }
            Assert.assertFalse((String)"Split region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            try {
                am.unassign(hri);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (DoNotRetryIOException doNotRetryIOException) {
                // empty catch block
            }
            Assert.assertFalse((String)"Split region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
        }
        finally {
            this.admin.balancerSwitch(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreFileReferenceCreationWhenSplitPolicySaysToSkipRangeCheck() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            byte[] cf = Bytes.toBytes((String)"f");
            byte[] cf1 = Bytes.toBytes((String)"i_f");
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf1)).setRegionSplitPolicyClassName(CustomSplitPolicy.class.getName()).build();
            this.admin.createTable(htd);
            List<HRegion> regions = this.awaitTableRegions(tableName);
            HRegion region = regions.get(0);
            for (int i = 3; i < 9; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(cf, Bytes.toBytes((String)"q"), Bytes.toBytes((String)("value" + i)));
                p.addColumn(cf1, Bytes.toBytes((String)"q"), Bytes.toBytes((String)("value" + i)));
                region.put(p);
            }
            region.flush(true);
            HStore store = region.getStore(cf);
            Collection storefiles = store.getStorefiles();
            Assert.assertEquals((long)1L, (long)storefiles.size());
            Assert.assertFalse((boolean)region.hasReferences());
            Path referencePath = region.getRegionFileSystem().splitStoreFile(region.getRegionInfo(), "f", (HStoreFile)storefiles.iterator().next(), Bytes.toBytes((String)"row1"), false, region.getSplitPolicy());
            Assert.assertNull((Object)referencePath);
            referencePath = region.getRegionFileSystem().splitStoreFile(region.getRegionInfo(), "i_f", (HStoreFile)storefiles.iterator().next(), Bytes.toBytes((String)"row1"), false, region.getSplitPolicy());
            Assert.assertNotNull((Object)referencePath);
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    private HRegion findSplittableRegion(List<HRegion> regions) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            for (HRegion r : regions) {
                if (!r.isSplittable() || r.getRegionInfo().getReplicaId() != 0) continue;
                return r;
            }
            Thread.sleep(100L);
        }
        return null;
    }

    private List<HRegion> checkAndGetDaughters(TableName tableName) throws InterruptedException {
        List<HRegion> daughters = null;
        for (int i = 0; i < 100 && (daughters = this.cluster.getRegions(tableName)).size() < 2; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
        return daughters;
    }

    private HMaster abortAndWaitForMaster() throws IOException, InterruptedException {
        this.cluster.abortMaster(0);
        this.cluster.waitOnMaster(0);
        HMaster master = this.cluster.startMaster().getMaster();
        this.cluster.waitForActiveAndReadyMaster();
        Closeables.close((Closeable)this.admin, (boolean)true);
        TESTING_UTIL.invalidateConnection();
        this.admin = TESTING_UTIL.getAdmin();
        return master;
    }

    private int ensureTableRegionNotOnSameServerAsMeta(Admin admin, RegionInfo hri) throws IOException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        int metaServerIndex = this.cluster.getServerWithMeta();
        HRegionServer metaRegionServer = this.cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = this.cluster.getRegionServer(tableRegionIndex);
        LOG.info("MetaRegionServer=" + metaRegionServer.getServerName() + ", other=" + tableRegionServer.getServerName());
        if (metaRegionServer.getServerName().equals((Object)tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(this.cluster, metaRegionServer);
            Assert.assertNotNull((Object)hrs);
            Assert.assertNotNull((Object)hri);
            LOG.info("Moving " + hri.getRegionNameAsString() + " from " + metaRegionServer.getServerName() + " to " + hrs.getServerName() + "; metaServerIndex=" + metaServerIndex);
            admin.move(hri.getEncodedNameAsBytes(), hrs.getServerName());
        }
        for (int i = 0; i < 100 && ((tableRegionIndex = this.cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex); ++i) {
            LOG.debug("Waiting on region move off the hbase:meta server; current index " + tableRegionIndex + " and metaServerIndex=" + metaServerIndex);
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)("Region not moved off hbase:meta server, tableRegionIndex=" + tableRegionIndex), (tableRegionIndex != -1 && tableRegionIndex != metaServerIndex ? 1 : 0) != 0);
        tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(SingleProcessHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals((Object)notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        for (RegionInfo region : regions) {
            LOG.info(prefix + region.getRegionNameAsString());
        }
    }

    private void waitUntilRegionServerDead() throws InterruptedException, IOException {
        for (int i = 0; (this.cluster.getMaster().getClusterMetrics().getLiveServerMetrics().size() > 3 || this.cluster.getLiveRegionServerThreads().size() > 3) && i < 100; ++i) {
            LOG.info("Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (this.cluster.getMaster().getClusterMetrics().getLiveServerMetrics().size() > 3 || this.cluster.getLiveRegionServerThreads().size() > 3 ? 1 : 0) != 0);
    }

    private void awaitDaughters(TableName tableName, int numDaughters) throws InterruptedException {
        for (int i = 0; this.cluster.getRegions(tableName).size() < numDaughters && i < 60; ++i) {
            LOG.info("Waiting for repair to happen");
            Thread.sleep(1000L);
        }
        if (this.cluster.getRegions(tableName).size() < numDaughters) {
            Assert.fail((String)"Waiting too long for daughter regions");
        }
    }

    private List<HRegion> awaitTableRegions(TableName tableName) throws InterruptedException {
        List<HRegion> regions = null;
        for (int i = 0; i < 100 && (regions = this.cluster.getRegions(tableName)).size() <= 0; ++i) {
            Thread.sleep(100L);
        }
        return regions;
    }

    private Table createTableAndWait(TableName tableName, byte[] cf) throws IOException, InterruptedException {
        Table t = TESTING_UTIL.createTable(tableName, cf);
        this.awaitTableRegions(tableName);
        Assert.assertTrue((String)("Table not online: " + tableName), (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        return t;
    }

    static class CustomSplitPolicy
    extends IncreasingToUpperBoundRegionSplitPolicy {
        CustomSplitPolicy() {
        }

        protected boolean shouldSplit() {
            return true;
        }

        public boolean skipStoreFileRangeCheck(String familyName) {
            return familyName.startsWith("i_");
        }
    }

    static class MyMasterRpcServices
    extends MasterRpcServices {
        static AtomicBoolean enabled = new AtomicBoolean(false);
        private HMaster myMaster;

        public MyMasterRpcServices(HMaster master) throws IOException {
            super(master);
            this.myMaster = master;
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController c, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
            RegionServerStatusProtos.ReportRegionStateTransitionResponse resp = super.reportRegionStateTransition(c, req);
            if (enabled.get() && req.getTransition(0).getTransitionCode().equals((Object)RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT) && !resp.hasErrorMessage()) {
                RegionStates regionStates = this.myMaster.getAssignmentManager().getRegionStates();
                for (RegionStateNode regionStateNode : regionStates.getRegionsInTransition()) {
                }
            }
            return resp;
        }
    }

    public static class MyMaster
    extends HMaster {
        public MyMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected MasterRpcServices createRpcServices() throws IOException {
            return new MyMasterRpcServices(this);
        }
    }

    public static class FailingSplitMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        volatile CountDownLatch latch;

        public void start(CoprocessorEnvironment e) throws IOException {
            this.latch = new CountDownLatch(1);
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preSplitRegionBeforeMETAAction(ObserverContext<MasterCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            this.latch.countDown();
            throw new IOException("Causing rollback of region split");
        }
    }
}

