/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanPerNextResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ReversedRegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestScannerHeartbeatMessages {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerHeartbeatMessages.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static AsyncConnection CONN;
    private static TableName TABLE_NAME;
    private static int NUM_ROWS;
    private static byte[] ROW;
    private static byte[][] ROWS;
    private static int NUM_FAMILIES;
    private static byte[] FAMILY;
    private static byte[][] FAMILIES;
    private static int NUM_QUALIFIERS;
    private static byte[] QUALIFIER;
    private static byte[][] QUALIFIERS;
    private static int VALUE_SIZE;
    private static byte[] VALUE;
    private static int SERVER_TIMEOUT;
    private static int CLIENT_TIMEOUT;
    private static int DEFAULT_ROW_SLEEP_TIME;
    private static int DEFAULT_CF_SLEEP_TIME;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.hregion.impl", new String[]{HeartbeatHRegion.class.getName()});
        conf.setStrings("hbase.regionserver.impl", new String[]{HeartbeatHRegionServer.class.getName()});
        conf.setInt("hbase.client.scanner.timeout.period", SERVER_TIMEOUT);
        conf.setInt("hbase.rpc.timeout", SERVER_TIMEOUT);
        conf.setInt("hbase.client.pause", 1);
        conf.setLong("hbase.cells.scanned.per.heartbeat.check", 1L);
        TEST_UTIL.startMiniCluster(1);
        TestScannerHeartbeatMessages.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
        Configuration newConf = new Configuration(conf);
        newConf.setInt("hbase.client.scanner.timeout.period", CLIENT_TIMEOUT);
        newConf.setInt("hbase.rpc.timeout", CLIENT_TIMEOUT);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)newConf).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeLimitAccountsForQueueTime() throws IOException, InterruptedException {
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        RSRpcServices services = new RSRpcServices(rs);
        RpcCall mockRpcCall = (RpcCall)Mockito.mock(RpcCall.class);
        Mockito.when((Object)mockRpcCall.getReceiveTime()).thenReturn((Object)180L, (Object[])new Long[]{120L, 101L, 25L});
        HBaseRpcController mockController = (HBaseRpcController)Mockito.mock(HBaseRpcController.class);
        Mockito.when((Object)mockController.getCallTimeout()).thenReturn((Object)100);
        EnvironmentEdgeManager.injectEdge(() -> 200L);
        try {
            Assert.assertEquals((long)240L, (long)services.getTimeLimit(mockRpcCall, mockController, true));
            Assert.assertEquals((long)210L, (long)services.getTimeLimit(mockRpcCall, mockController, true));
            Assert.assertEquals((long)210L, (long)services.getTimeLimit(mockRpcCall, mockController, true));
            Assert.assertEquals((long)210L, (long)services.getTimeLimit(mockRpcCall, mockController, true));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    static void createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        Table ht = TEST_UTIL.createTable(name, families);
        ArrayList<Put> puts = TestScannerHeartbeatMessages.createPuts(rows, families, qualifiers, cellValue);
        ht.put(puts);
    }

    static ArrayList<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add((Cell)kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setupBeforeTest() throws Exception {
        TestScannerHeartbeatMessages.disableSleeping();
    }

    @After
    public void teardownAfterTest() throws Exception {
        TestScannerHeartbeatMessages.disableSleeping();
    }

    private void testImportanceOfHeartbeats(Callable<Void> testCallable) throws InterruptedException {
        HeartbeatRPCServices.heartbeatsEnabled = true;
        try {
            testCallable.call();
        }
        catch (Exception e) {
            Assert.fail((String)("Heartbeat messages are enabled, exceptions should NOT be thrown. Exception trace:" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
        HeartbeatRPCServices.heartbeatsEnabled = false;
        try {
            testCallable.call();
        }
        catch (Exception e) {
            return;
        }
        finally {
            HeartbeatRPCServices.heartbeatsEnabled = true;
        }
        Assert.fail((String)"Heartbeats messages are disabled, an exception should be thrown. If an exception  is not thrown, the test case is not testing the importance of heartbeat messages");
    }

    @Test
    public void testHeartbeatBetweenRows() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Scan scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                TestScannerHeartbeatMessages.this.testEquivalenceOfScanWithHeartbeats(scan, DEFAULT_ROW_SLEEP_TIME, -1, false);
                return null;
            }
        });
    }

    @Test
    public void testHeartbeatBetweenColumnFamilies() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Scan baseScan = new Scan();
                baseScan.setMaxResultSize(Long.MAX_VALUE);
                baseScan.setCaching(Integer.MAX_VALUE);
                Scan scanCopy = new Scan(baseScan);
                TestScannerHeartbeatMessages.this.testEquivalenceOfScanWithHeartbeats(scanCopy, -1, DEFAULT_CF_SLEEP_TIME, false);
                scanCopy = new Scan(baseScan);
                TestScannerHeartbeatMessages.this.testEquivalenceOfScanWithHeartbeats(scanCopy, -1, DEFAULT_CF_SLEEP_TIME, true);
                return null;
            }
        });
    }

    @Test
    public void testHeartbeatWithSparseCellFilter() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int num;
                Scan scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                scan.setFilter((Filter)new SparseCellFilter());
                try (ScanPerNextResultScanner scanner = new ScanPerNextResultScanner((AsyncTable<AdvancedScanResultConsumer>)CONN.getTable(TABLE_NAME), scan);){
                    num = 0;
                    while (scanner.next() != null) {
                        ++num;
                    }
                    Assert.assertEquals((long)1L, (long)num);
                }
                scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                scan.setFilter((Filter)new SparseCellFilter());
                scan.setAllowPartialResults(true);
                scanner = new ScanPerNextResultScanner((AsyncTable<AdvancedScanResultConsumer>)CONN.getTable(TABLE_NAME), scan);
                var3_3 = null;
                try {
                    num = 0;
                    while (scanner.next() != null) {
                        ++num;
                    }
                    Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)num);
                }
                catch (Throwable throwable) {
                    var3_3 = throwable;
                    throw throwable;
                }
                finally {
                    if (scanner != null) {
                        if (var3_3 != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            scanner.close();
                        }
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testHeartbeatWithSparseRowFilter() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Scan scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                scan.setFilter((Filter)new SparseRowFilter());
                try (ScanPerNextResultScanner scanner = new ScanPerNextResultScanner((AsyncTable<AdvancedScanResultConsumer>)CONN.getTable(TABLE_NAME), scan);){
                    int num = 0;
                    while (scanner.next() != null) {
                        ++num;
                    }
                    Assert.assertEquals((long)1L, (long)num);
                }
                return null;
            }
        });
    }

    private void testEquivalenceOfScanWithHeartbeats(Scan scan, int rowSleepTime, int cfSleepTime, boolean sleepBeforeCf) throws Exception {
        TestScannerHeartbeatMessages.disableSleeping();
        AsyncTable table = CONN.getTable(TABLE_NAME);
        ScanPerNextResultScanner scanner = new ScanPerNextResultScanner((AsyncTable<AdvancedScanResultConsumer>)table, scan);
        ScanPerNextResultScanner scannerWithHeartbeats = new ScanPerNextResultScanner((AsyncTable<AdvancedScanResultConsumer>)table, scan);
        Result r1 = null;
        Result r2 = null;
        while ((r1 = scanner.next()) != null) {
            TestScannerHeartbeatMessages.configureSleepTime(rowSleepTime, cfSleepTime, sleepBeforeCf);
            r2 = scannerWithHeartbeats.next();
            TestScannerHeartbeatMessages.disableSleeping();
            Assert.assertTrue((r2 != null ? 1 : 0) != 0);
            try {
                Result.compareResults((Result)r1, (Result)r2);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
        Assert.assertTrue((scannerWithHeartbeats.next() == null ? 1 : 0) != 0);
        scanner.close();
        scannerWithHeartbeats.close();
    }

    private static void configureSleepTime(int rowSleepTime, int cfSleepTime, boolean sleepBeforeCf) {
        HeartbeatHRegion.sleepBetweenRows = rowSleepTime > 0;
        HeartbeatHRegion.rowSleepTime = rowSleepTime;
        HeartbeatHRegion.sleepBetweenColumnFamilies = cfSleepTime > 0;
        HeartbeatHRegion.columnFamilySleepTime = cfSleepTime;
        HeartbeatHRegion.sleepBeforeColumnFamily = sleepBeforeCf;
    }

    private static void disableSleeping() {
        HeartbeatHRegion.sleepBetweenRows = false;
        HeartbeatHRegion.sleepBetweenColumnFamilies = false;
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"testScannerHeartbeatMessagesTable");
        NUM_ROWS = 5;
        ROW = Bytes.toBytes((String)"testRow");
        ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
        NUM_FAMILIES = 4;
        FAMILY = Bytes.toBytes((String)"testFamily");
        FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
        NUM_QUALIFIERS = 3;
        QUALIFIER = Bytes.toBytes((String)"testQualifier");
        QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
        VALUE_SIZE = 128;
        VALUE = Bytes.createMaxByteArray((int)VALUE_SIZE);
        SERVER_TIMEOUT = 60000;
        CLIENT_TIMEOUT = 1000;
        DEFAULT_ROW_SLEEP_TIME = 300;
        DEFAULT_CF_SLEEP_TIME = 300;
    }

    private static final class HeartbeatReversedKVHeap
    extends ReversedKeyValueHeap {
        public HeartbeatReversedKVHeap(List<? extends KeyValueScanner> scanners, CellComparatorImpl comparator) throws IOException {
            super(scanners, (CellComparator)comparator);
        }

        public boolean next(List<Cell> result, ScannerContext context) throws IOException {
            if (HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            boolean moreRows = super.next(result, context);
            if (!HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            return moreRows;
        }
    }

    private static final class HeartbeatKVHeap
    extends KeyValueHeap {
        public HeartbeatKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
            super(scanners, comparator);
        }

        HeartbeatKVHeap(List<? extends KeyValueScanner> scanners, KeyValueHeap.KVScannerComparator comparator) throws IOException {
            super(scanners, comparator);
        }

        public boolean next(List<Cell> result, ScannerContext context) throws IOException {
            if (HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            boolean moreRows = super.next(result, context);
            if (!HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            return moreRows;
        }
    }

    private static class HeartbeatRegionScanner
    extends RegionScannerImpl {
        HeartbeatRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            super(scan, additionalScanners, region, 0L, 0L);
        }

        public boolean nextRaw(List<Cell> outResults, ScannerContext context) throws IOException {
            boolean moreRows = super.nextRaw(outResults, context);
            HeartbeatHRegion.rowSleep();
            return moreRows;
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new HeartbeatKVHeap(scanners, region.getCellComparator());
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new HeartbeatKVHeap(joinedScanners, region.getCellComparator());
            }
        }
    }

    private static class HeartbeatReversedRegionScanner
    extends ReversedRegionScannerImpl {
        HeartbeatReversedRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            super(scan, additionalScanners, region, 0L, 0L);
        }

        public boolean nextRaw(List<Cell> outResults, ScannerContext context) throws IOException {
            boolean moreRows = super.nextRaw(outResults, context);
            HeartbeatHRegion.rowSleep();
            return moreRows;
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new HeartbeatReversedKVHeap(scanners, (CellComparatorImpl)region.getCellComparator());
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new HeartbeatReversedKVHeap(joinedScanners, (CellComparatorImpl)region.getCellComparator());
            }
        }
    }

    private static class HeartbeatHRegion
    extends HRegion {
        private static volatile int rowSleepTime = TestScannerHeartbeatMessages.access$100();
        private static volatile boolean sleepBetweenRows = false;
        private static volatile boolean sleepBeforeColumnFamily = false;
        private static volatile int columnFamilySleepTime = TestScannerHeartbeatMessages.access$300();
        private static volatile boolean sleepBetweenColumnFamilies = false;

        public HeartbeatHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public HeartbeatHRegion(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        private static void columnFamilySleep() {
            if (sleepBetweenColumnFamilies) {
                Threads.sleepWithoutInterrupt((long)columnFamilySleepTime);
            }
        }

        private static void rowSleep() {
            if (sleepBetweenRows) {
                Threads.sleepWithoutInterrupt((long)rowSleepTime);
            }
        }

        protected RegionScannerImpl instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, long nonceGroup, long nonce) throws IOException {
            if (scan.isReversed()) {
                if (scan.getFilter() != null) {
                    scan.getFilter().setReversed(true);
                }
                return new HeartbeatReversedRegionScanner(scan, additionalScanners, this);
            }
            return new HeartbeatRegionScanner(scan, additionalScanners, this);
        }
    }

    private static class HeartbeatRPCServices
    extends RSRpcServices {
        private static volatile boolean heartbeatsEnabled = true;

        public HeartbeatRPCServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder((ClientProtos.ScanRequest)request);
            builder.setClientHandlesHeartbeats(heartbeatsEnabled);
            return super.scan(controller, builder.build());
        }
    }

    private static class HeartbeatHRegionServer
    extends HRegionServer {
        public HeartbeatHRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new HeartbeatRPCServices(this);
        }
    }

    public static class SparseRowFilter
    extends FilterBase {
        public boolean filterRowKey(Cell cell) throws IOException {
            try {
                Thread.sleep(CLIENT_TIMEOUT / 2 - 100);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return !Bytes.equals((byte[])CellUtil.cloneRow((Cell)cell), (byte[])ROWS[NUM_ROWS - 1]);
        }

        public static Filter parseFrom(byte[] pbBytes) {
            return new SparseRowFilter();
        }
    }

    public static class SparseCellFilter
    extends FilterBase {
        public Filter.ReturnCode filterCell(Cell v) throws IOException {
            try {
                Thread.sleep(CLIENT_TIMEOUT / 2 + 100);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return Bytes.equals((byte[])CellUtil.cloneRow((Cell)v), (byte[])ROWS[NUM_ROWS - 1]) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }

        public static Filter parseFrom(byte[] pbBytes) {
            return new SparseCellFilter();
        }
    }
}

