/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerCrashDisableWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerCrashDisableWAL.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        UTIL.getConfiguration().setBoolean("hbase.regionserver.hlog.enabled", false);
        UTIL.startMiniCluster(2);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.waitTableAvailable(TABLE_NAME);
        HRegionServer rs = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        if (!rs.getRegions(TableName.META_TABLE_NAME).isEmpty()) {
            HRegionServer rs1 = UTIL.getOtherRegionServer(rs);
            UTIL.moveRegionAndWait(UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0).getRegionInfo(), rs1.getServerName());
        }
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, IOException {
        HMaster master = UTIL.getMiniHBaseCluster().stopMaster(0).getMaster();
        UTIL.waitFor(30000L, () -> !master.isAlive());
        JVMClusterUtil.RegionServerThread thread = null;
        for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            if (t.getRegionServer().getRegions(TABLE_NAME).isEmpty()) continue;
            thread = t;
            break;
        }
        thread.getRegionServer().abort("For testing");
        thread.join();
        UTIL.getMiniHBaseCluster().startMaster();
        try (Table table = UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setOperationTimeout(30000).build();){
            table.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, CQ, Bytes.toBytes((int)1)));
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])table.get(new Get(Bytes.toBytes((int)1))).getValue(CF, CQ)));
        }
    }
}

