/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.FlushAllLargeStoresPolicy;
import org.apache.hadoop.hbase.regionserver.FlushAllStoresPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.hash.Hashing;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestPerColumnFamilyFlush {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPerColumnFamilyFlush.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestPerColumnFamilyFlush.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Path DIR = TEST_UTIL.getDataTestDir("TestHRegion");
    public static final TableName TABLENAME = TableName.valueOf((String)"TestPerColumnFamilyFlush", (String)"t1");
    public static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"f3"), Bytes.toBytes((String)"f4"), Bytes.toBytes((String)"f5")};
    public static final byte[] FAMILY1 = FAMILIES[0];
    public static final byte[] FAMILY2 = FAMILIES[1];
    public static final byte[] FAMILY3 = FAMILIES[2];

    private HRegion initHRegion(String callingMethod, Configuration conf) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TABLENAME);
        for (byte[] family : FAMILIES) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)TABLENAME).build();
        Path path = new Path(DIR, callingMethod);
        return HBaseTestingUtil.createRegionAndWAL(info, path, conf, builder.build());
    }

    private Put createPut(int familyNum, int putNum) {
        byte[] qf = Bytes.toBytes((String)("q" + familyNum));
        byte[] row = Bytes.toBytes((String)("row" + familyNum + "-" + putNum));
        byte[] val = Bytes.toBytes((String)("val" + familyNum + "-" + putNum));
        Put p = new Put(row);
        p.addColumn(FAMILIES[familyNum - 1], qf, val);
        return p;
    }

    private Get createGet(int familyNum, int putNum) {
        byte[] row = Bytes.toBytes((String)("row" + familyNum + "-" + putNum));
        return new Get(row);
    }

    void verifyEdit(int familyNum, int putNum, Table table) throws IOException {
        Result r = table.get(this.createGet(familyNum, putNum));
        byte[] family = FAMILIES[familyNum - 1];
        byte[] qf = Bytes.toBytes((String)("q" + familyNum));
        byte[] val = Bytes.toBytes((String)("val" + familyNum + "-" + putNum));
        Assert.assertNotNull((String)("Missing Put#" + putNum + " for CF# " + familyNum), (Object)r.getFamilyMap(family));
        Assert.assertNotNull((String)("Missing Put#" + putNum + " for CF# " + familyNum), r.getFamilyMap(family).get(qf));
        Assert.assertTrue((String)("Incorrect value for Put#" + putNum + " for CF# " + familyNum), (boolean)Arrays.equals((byte[])r.getFamilyMap(family).get(qf), val));
    }

    @Test
    public void testSelectiveFlushWhenEnabled() throws IOException {
        int i;
        Configuration conf = new HBaseTestingUtil().getConfiguration();
        conf.setLong("hbase.hregion.memstore.flush.size", 204800L);
        conf.set("hbase.regionserver.flush.policy", FlushAllLargeStoresPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 40960L);
        HRegion region = this.initHRegion("testSelectiveFlushWithDataCompaction", conf);
        for (int i2 = 1; i2 <= 1200; ++i2) {
            region.put(this.createPut(1, i2));
            if (i2 > 100) continue;
            region.put(this.createPut(2, i2));
            if (i2 > 50) continue;
            region.put(this.createPut(3, i2));
        }
        long totalMemstoreSize = region.getMemStoreDataSize();
        long smallestSeqCF1 = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2 = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3 = region.getOldestSeqIdOfStore(FAMILY3);
        MemStoreSize cf1MemstoreSize = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSize = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSize = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstore = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)smallestSeqCF1, (long)smallestSeqInRegionCurrentMemstore);
        Assert.assertTrue((smallestSeqCF1 < smallestSeqCF2 ? 1 : 0) != 0);
        Assert.assertTrue((smallestSeqCF2 < smallestSeqCF3 ? 1 : 0) != 0);
        Assert.assertTrue((cf1MemstoreSize.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf2MemstoreSize.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSize.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)totalMemstoreSize, (long)(cf1MemstoreSize.getDataSize() + cf2MemstoreSize.getDataSize() + cf3MemstoreSize.getDataSize()));
        region.flush(false);
        MemStoreSize oldCF2MemstoreSize = cf2MemstoreSize;
        MemStoreSize oldCF3MemstoreSize = cf3MemstoreSize;
        cf1MemstoreSize = region.getStore(FAMILY1).getMemStoreSize();
        cf2MemstoreSize = region.getStore(FAMILY2).getMemStoreSize();
        cf3MemstoreSize = region.getStore(FAMILY3).getMemStoreSize();
        totalMemstoreSize = region.getMemStoreDataSize();
        smallestSeqInRegionCurrentMemstore = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)0L, (long)cf1MemstoreSize.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf1MemstoreSize.getHeapSize());
        Assert.assertEquals((Object)cf2MemstoreSize, (Object)oldCF2MemstoreSize);
        Assert.assertEquals((Object)cf3MemstoreSize, (Object)oldCF3MemstoreSize);
        Assert.assertEquals((long)smallestSeqInRegionCurrentMemstore, (long)smallestSeqCF2);
        Assert.assertEquals((long)totalMemstoreSize, (long)(cf2MemstoreSize.getDataSize() + cf3MemstoreSize.getDataSize()));
        for (i = 1200; i < 2400; ++i) {
            region.put(this.createPut(2, i));
            if (i - 1200 >= 100) continue;
            region.put(this.createPut(3, i));
        }
        oldCF3MemstoreSize = region.getStore(FAMILY3).getMemStoreSize();
        region.flush(false);
        cf1MemstoreSize = region.getStore(FAMILY1).getMemStoreSize();
        cf2MemstoreSize = region.getStore(FAMILY2).getMemStoreSize();
        cf3MemstoreSize = region.getStore(FAMILY3).getMemStoreSize();
        totalMemstoreSize = region.getMemStoreDataSize();
        smallestSeqInRegionCurrentMemstore = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)0L, (long)cf1MemstoreSize.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf1MemstoreSize.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf2MemstoreSize.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSize.getHeapSize());
        Assert.assertEquals((Object)cf3MemstoreSize, (Object)oldCF3MemstoreSize);
        Assert.assertEquals((long)totalMemstoreSize, (long)cf3MemstoreSize.getDataSize());
        region.flush(true);
        for (i = 1; i <= 300; ++i) {
            region.put(this.createPut(1, i));
            region.put(this.createPut(2, i));
            region.put(this.createPut(3, i));
            region.put(this.createPut(4, i));
            region.put(this.createPut(5, i));
        }
        region.flush(false);
        Assert.assertEquals((long)0L, (long)region.getMemStoreDataSize());
        HBaseTestingUtil.closeRegionAndWAL(region);
    }

    @Test
    public void testSelectiveFlushWhenNotEnabled() throws IOException {
        Configuration conf = new HBaseTestingUtil().getConfiguration();
        conf.setLong("hbase.hregion.memstore.flush.size", 204800L);
        conf.set("hbase.regionserver.flush.policy", FlushAllStoresPolicy.class.getName());
        HRegion region = this.initHRegion("testSelectiveFlushWhenNotEnabled", conf);
        for (int i = 1; i <= 1200; ++i) {
            region.put(this.createPut(1, i));
            if (i > 100) continue;
            region.put(this.createPut(2, i));
            if (i > 50) continue;
            region.put(this.createPut(3, i));
        }
        long totalMemstoreSize = region.getMemStoreDataSize();
        MemStoreSize cf1MemstoreSize = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSize = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSize = region.getStore(FAMILY3).getMemStoreSize();
        Assert.assertTrue((cf1MemstoreSize.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf2MemstoreSize.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSize.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)totalMemstoreSize, (long)(cf1MemstoreSize.getDataSize() + cf2MemstoreSize.getDataSize() + cf3MemstoreSize.getDataSize()));
        region.flush(false);
        cf1MemstoreSize = region.getStore(FAMILY1).getMemStoreSize();
        cf2MemstoreSize = region.getStore(FAMILY2).getMemStoreSize();
        cf3MemstoreSize = region.getStore(FAMILY3).getMemStoreSize();
        totalMemstoreSize = region.getMemStoreDataSize();
        long smallestSeqInRegionCurrentMemstore = region.getWAL().getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)0L, (long)cf1MemstoreSize.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf1MemstoreSize.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf2MemstoreSize.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSize.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf3MemstoreSize.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf3MemstoreSize.getHeapSize());
        Assert.assertEquals((long)0L, (long)totalMemstoreSize);
        Assert.assertEquals((long)-1L, (long)smallestSeqInRegionCurrentMemstore);
        HBaseTestingUtil.closeRegionAndWAL(region);
    }

    private static Pair<HRegion, HRegionServer> getRegionWithName(TableName tableName) {
        SingleProcessHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator iterator = hrs.getRegions(tableName).iterator();
            if (!iterator.hasNext()) continue;
            HRegion region = (HRegion)iterator.next();
            return Pair.newPair((Object)region, (Object)hrs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestLogReplay() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.hregion.memstore.flush.size", 10000L);
        conf.set("hbase.regionserver.flush.policy", FlushAllLargeStoresPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 2500L);
        int numRegionServers = 4;
        try {
            TEST_UTIL.startMiniCluster(4);
            TEST_UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)TABLENAME.getNamespaceAsString()).build());
            Table table = TEST_UTIL.createTable(TABLENAME, FAMILIES);
            for (int i = 1; i <= 80; ++i) {
                table.put(this.createPut(1, i));
                if (i > 10) continue;
                table.put(this.createPut(2, i));
                table.put(this.createPut(3, i));
            }
            Thread.sleep(1000L);
            Pair<HRegion, HRegionServer> desiredRegionAndServer = TestPerColumnFamilyFlush.getRegionWithName(TABLENAME);
            HRegion desiredRegion = (HRegion)desiredRegionAndServer.getFirst();
            Assert.assertTrue((String)"Could not find a region which hosts the new region.", (desiredRegion != null ? 1 : 0) != 0);
            desiredRegion.flush(false);
            long totalMemstoreSize = desiredRegion.getMemStoreDataSize();
            long cf1MemstoreSize = desiredRegion.getStore(FAMILY1).getMemStoreSize().getDataSize();
            long cf2MemstoreSize = desiredRegion.getStore(FAMILY2).getMemStoreSize().getDataSize();
            long cf3MemstoreSize = desiredRegion.getStore(FAMILY3).getMemStoreSize().getDataSize();
            Assert.assertEquals((long)0L, (long)cf1MemstoreSize);
            Assert.assertTrue((cf2MemstoreSize >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((cf3MemstoreSize >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)totalMemstoreSize, (long)(cf2MemstoreSize + cf3MemstoreSize));
            Thread.sleep(2000L);
            HRegionServer rs = (HRegionServer)desiredRegionAndServer.getSecond();
            rs.abort("testing");
            for (int i = 1; i <= 80; ++i) {
                this.verifyEdit(1, i, table);
                if (i > 10) continue;
                this.verifyEdit(2, i, table);
                this.verifyEdit(3, i, table);
            }
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test
    public void testLogReplayWithDistributedLogSplit() throws Exception {
        this.doTestLogReplay();
    }

    private WAL getWAL(Region region) {
        return ((HRegion)region).getWAL();
    }

    private int getNumRolledLogFiles(Region region) {
        return AbstractFSWALProvider.getNumRolledLogFiles((WAL)this.getWAL(region));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushingWhenLogRolling() throws Exception {
        TableName tableName = TableName.valueOf((String)"testFlushingWhenLogRolling");
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        conf.set("hbase.regionserver.flush.policy", FlushAllLargeStoresPolicy.class.getName());
        long cfFlushSizeLowerBound = 2048L;
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", cfFlushSizeLowerBound);
        conf.setLong("hbase.regionserver.logroll.period", 3600000L);
        conf.setLong("hbase.regionserver.hlog.blocksize", 0x8000000L);
        int maxLogs = 10;
        conf.setInt("hbase.regionserver.maxlogs", 10);
        boolean numRegionServers = true;
        TEST_UTIL.startMiniCluster(1);
        try {
            int i;
            Table table = TEST_UTIL.createTable(tableName, FAMILIES);
            Pair<HRegion, HRegionServer> desiredRegionAndServer = TestPerColumnFamilyFlush.getRegionWithName(tableName);
            final HRegion desiredRegion = (HRegion)desiredRegionAndServer.getFirst();
            Assert.assertTrue((String)"Could not find a region which hosts the new region.", (desiredRegion != null ? 1 : 0) != 0);
            LOG.info("Writing to region=" + desiredRegion);
            for (i = 1; i <= 3; ++i) {
                table.put(this.createPut(i, 0));
            }
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < 100; ++j) {
                    table.put(this.createPut(1, i * 100 + j));
                }
                int currentNumRolledLogFiles = this.getNumRolledLogFiles((Region)desiredRegion);
                Assert.assertNull((Object)this.getWAL((Region)desiredRegion).rollWriter());
                TEST_UTIL.waitFor(60000L, () -> this.getNumRolledLogFiles((Region)desiredRegion) > currentNumRolledLogFiles);
            }
            Assert.assertEquals((long)10L, (long)this.getNumRolledLogFiles((Region)desiredRegion));
            Assert.assertTrue((desiredRegion.getStore(FAMILY1).getMemStoreSize().getHeapSize() > cfFlushSizeLowerBound ? 1 : 0) != 0);
            Assert.assertTrue((desiredRegion.getStore(FAMILY2).getMemStoreSize().getHeapSize() < cfFlushSizeLowerBound ? 1 : 0) != 0);
            Assert.assertTrue((desiredRegion.getStore(FAMILY3).getMemStoreSize().getHeapSize() < cfFlushSizeLowerBound ? 1 : 0) != 0);
            table.put(this.createPut(1, 12345678));
            ((HRegionServer)desiredRegionAndServer.getSecond()).getWalRoller().requestRollAll();
            TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return desiredRegion.getMemStoreDataSize() == 0L;
                }

                public String explainFailure() throws Exception {
                    long memstoreSize = desiredRegion.getMemStoreDataSize();
                    if (memstoreSize > 0L) {
                        return "Still have unflushed entries in memstore, memstore size is " + memstoreSize;
                    }
                    return "Unknown";
                }
            });
            LOG.info("Finished waiting on flush after too many WALs...");
            Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)desiredRegion.getStore(FAMILY1).getMemStoreSize().getHeapSize());
            Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)desiredRegion.getStore(FAMILY2).getMemStoreSize().getHeapSize());
            Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)desiredRegion.getStore(FAMILY3).getMemStoreSize().getHeapSize());
            Assert.assertNull((Object)this.getWAL((Region)desiredRegion).rollWriter(true));
            TEST_UTIL.waitFor(60000L, () -> this.getNumRolledLogFiles((Region)desiredRegion) < 10);
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    private void doPut(Table table, long memstoreFlushSize) throws IOException, InterruptedException {
        Region region = (Region)TestPerColumnFamilyFlush.getRegionWithName(table.getName()).getFirst();
        byte[] qf = Bytes.toBytes((String)"qf");
        for (int i = 0; i < 10000; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row-" + i)));
            byte[] value1 = new byte[100];
            Bytes.random((byte[])value1);
            put.addColumn(FAMILY1, qf, value1);
            byte[] value2 = new byte[200];
            Bytes.random((byte[])value2);
            put.addColumn(FAMILY2, qf, value2);
            byte[] value3 = new byte[400];
            Bytes.random((byte[])value3);
            put.addColumn(FAMILY3, qf, value3);
            table.put(put);
            while (region.getMemStoreHeapSize() > memstoreFlushSize) {
                Thread.sleep(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareStoreFileCount() throws Exception {
        Region region;
        Table table;
        Connection conn;
        long memstoreFlushSize = 0x100000L;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.hregion.memstore.flush.size", memstoreFlushSize);
        conf.set("hbase.regionserver.flush.policy", FlushAllStoresPolicy.class.getName());
        conf.setInt("hbase.hstore.blockingStoreFiles", 10000);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setCompactionEnabled(false).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY1)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY2)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY3)).build();
        LOG.info("==============Test with selective flush disabled===============");
        int cf1StoreFileCount = -1;
        int cf2StoreFileCount = -1;
        int cf3StoreFileCount = -1;
        int cf1StoreFileCount1 = -1;
        int cf2StoreFileCount1 = -1;
        int cf3StoreFileCount1 = -1;
        try {
            TEST_UTIL.startMiniCluster(1);
            TEST_UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)TABLENAME.getNamespaceAsString()).build());
            TEST_UTIL.getAdmin().createTable(tableDescriptor);
            TEST_UTIL.waitTableAvailable(TABLENAME);
            conn = ConnectionFactory.createConnection((Configuration)conf);
            table = conn.getTable(TABLENAME);
            this.doPut(table, memstoreFlushSize);
            table.close();
            conn.close();
            region = (Region)TestPerColumnFamilyFlush.getRegionWithName(TABLENAME).getFirst();
            cf1StoreFileCount = region.getStore(FAMILY1).getStorefilesCount();
            cf2StoreFileCount = region.getStore(FAMILY2).getStorefilesCount();
            cf3StoreFileCount = region.getStore(FAMILY3).getStorefilesCount();
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
        LOG.info("==============Test with selective flush enabled===============");
        conf.set("hbase.regionserver.flush.policy", FlushAllLargeStoresPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 0L);
        try {
            TEST_UTIL.startMiniCluster(1);
            TEST_UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)TABLENAME.getNamespaceAsString()).build());
            TEST_UTIL.getAdmin().createTable(tableDescriptor);
            conn = ConnectionFactory.createConnection((Configuration)conf);
            table = conn.getTable(TABLENAME);
            this.doPut(table, memstoreFlushSize);
            table.close();
            conn.close();
            region = (Region)TestPerColumnFamilyFlush.getRegionWithName(TABLENAME).getFirst();
            cf1StoreFileCount1 = region.getStore(FAMILY1).getStorefilesCount();
            cf2StoreFileCount1 = region.getStore(FAMILY2).getStorefilesCount();
            cf3StoreFileCount1 = region.getStore(FAMILY3).getStorefilesCount();
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
        LOG.info("disable selective flush: " + Bytes.toString((byte[])FAMILY1) + "=>" + cf1StoreFileCount + ", " + Bytes.toString((byte[])FAMILY2) + "=>" + cf2StoreFileCount + ", " + Bytes.toString((byte[])FAMILY3) + "=>" + cf3StoreFileCount);
        LOG.info("enable selective flush: " + Bytes.toString((byte[])FAMILY1) + "=>" + cf1StoreFileCount1 + ", " + Bytes.toString((byte[])FAMILY2) + "=>" + cf2StoreFileCount1 + ", " + Bytes.toString((byte[])FAMILY3) + "=>" + cf3StoreFileCount1);
        Assert.assertTrue((cf1StoreFileCount1 < cf1StoreFileCount ? 1 : 0) != 0);
        Assert.assertTrue((cf2StoreFileCount1 < cf2StoreFileCount ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws Exception {
        int numRegions = Integer.parseInt(args[0]);
        long numRows = Long.parseLong(args[1]);
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(0x280000000L).setValue("SPLIT_POLICY", ConstantSizeRegionSplitPolicy.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY1)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY2)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY3)).build();
        Configuration conf = HBaseConfiguration.create();
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = conn.getAdmin();
        if (admin.tableExists(TABLENAME)) {
            admin.disableTable(TABLENAME);
            admin.deleteTable(TABLENAME);
        }
        if (numRegions >= 3) {
            byte[] startKey = new byte[16];
            byte[] endKey = new byte[16];
            Arrays.fill(endKey, (byte)-1);
            admin.createTable(tableDescriptor, startKey, endKey, numRegions);
        } else {
            admin.createTable(tableDescriptor);
        }
        admin.close();
        Table table = conn.getTable(TABLENAME);
        byte[] qf = Bytes.toBytes((String)"qf");
        byte[] value1 = new byte[16];
        byte[] value2 = new byte[256];
        byte[] value3 = new byte[4096];
        for (long i = 0L; i < numRows; ++i) {
            Put put = new Put(Hashing.md5().hashLong(i).asBytes());
            Bytes.random((byte[])value1);
            Bytes.random((byte[])value2);
            Bytes.random((byte[])value3);
            put.addColumn(FAMILY1, qf, value1);
            put.addColumn(FAMILY2, qf, value2);
            put.addColumn(FAMILY3, qf, value3);
            table.put(put);
            if (i % 10000L != 0L) continue;
            LOG.info(i + " rows put");
        }
        table.close();
        conn.close();
    }
}

