/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, RegionServerTests.class})
public class TestNotCleanupCompactedFileWhenRegionWarmup {
    private static final Logger LOG = LoggerFactory.getLogger(TestNotCleanupCompactedFileWhenRegionWarmup.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNotCleanupCompactedFileWhenRegionWarmup.class);
    private static HBaseTestingUtil TEST_UTIL;
    private static Admin admin;
    private static Table table;
    private static TableName TABLE_NAME;
    private static byte[] ROW;
    private static byte[] FAMILY;
    private static byte[] QUALIFIER;
    private static byte[] VALUE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", 1200000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 100);
        TEST_UTIL.getConfiguration().set("dfs.blocksize", "64000");
        TEST_UTIL.getConfiguration().set("dfs.namenode.fs-limits.min-block-size", "1024");
        TEST_UTIL.getConfiguration().set("hbase.master.hfilecleaner.ttl", "0");
        TEST_UTIL.startMiniCluster(1);
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        admin.createTable(builder.build());
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        table = TEST_UTIL.getConnection().getTable(TABLE_NAME);
    }

    @After
    public void after() throws Exception {
        admin.disableTable(TABLE_NAME);
        admin.deleteTable(TABLE_NAME);
    }

    @Test
    public void testRegionWarmup() throws Exception {
        ArrayList regions = new ArrayList();
        for (JVMClusterUtil.RegionServerThread rsThread : TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads()) {
            HRegionServer rs = rsThread.getRegionServer();
            if (!rs.getOnlineTables().contains(TABLE_NAME)) continue;
            regions.addAll(rs.getRegions(TABLE_NAME));
        }
        Assert.assertEquals((String)"Table should only have one region", (long)1L, (long)regions.size());
        HRegion region = (HRegion)regions.get(0);
        HStore store = region.getStore(FAMILY);
        this.writeDataAndFlush(3, region);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        store.getScanner(new Scan(), null, 0L);
        region.compact(true);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        Assert.assertEquals((long)3L, (long)store.getStoreEngine().getStoreFileManager().getCompactedfiles().size());
        HStore newStore = region.instantiateHStore(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY), true);
        Assert.assertEquals((long)4L, (long)newStore.getStorefilesCount());
        newStore = region.instantiateHStore(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY), false);
        Assert.assertEquals((long)1L, (long)newStore.getStorefilesCount());
    }

    private void writeDataAndFlush(int fileNum, HRegion region) throws Exception {
        for (int i = 0; i < fileNum; ++i) {
            for (int j = 0; j < 100; ++j) {
                table.put(new Put(this.concat(ROW, j)).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, j)));
            }
            region.flush(true);
        }
    }

    private byte[] concat(byte[] base, int index) {
        return Bytes.toBytes((String)(Bytes.toString((byte[])base) + "-" + index));
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"TestCleanupCompactedFileAfterFailover");
        ROW = Bytes.toBytes((String)"row");
        FAMILY = Bytes.toBytes((String)"cf");
        QUALIFIER = Bytes.toBytes((String)"cq");
        VALUE = Bytes.toBytes((String)"value");
    }
}

