/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, FilterTests.class, MediumTests.class})
public class TestIsDeleteFailure {
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIsDeleteFailure.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIsDeleteFailure() throws Exception {
        Delete del;
        Put put;
        byte[] row;
        int i;
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        byte[] family = Bytes.toBytes((String)"0");
        byte[] c1 = Bytes.toBytes((String)"C01");
        byte[] c2 = Bytes.toBytes((String)"C02");
        byte[] c3 = Bytes.toBytes((String)"C03");
        byte[] c4 = Bytes.toBytes((String)"C04");
        byte[] c5 = Bytes.toBytes((String)"C05");
        byte[] c6 = Bytes.toBytes((String)"C07");
        byte[] c7 = Bytes.toBytes((String)"C07");
        byte[] c8 = Bytes.toBytes((String)"C08");
        byte[] c9 = Bytes.toBytes((String)"C09");
        byte[] c10 = Bytes.toBytes((String)"C10");
        byte[] c11 = Bytes.toBytes((String)"C11");
        byte[] c12 = Bytes.toBytes((String)"C12");
        byte[] c13 = Bytes.toBytes((String)"C13");
        byte[] c14 = Bytes.toBytes((String)"C14");
        byte[] c15 = Bytes.toBytes((String)"C15");
        byte[] val = Bytes.toBytes((String)"foo");
        ArrayList<byte[]> fams = new ArrayList<byte[]>(1);
        fams.add(family);
        Table ht = TEST_UTIL.createTable(table, (byte[][])fams.toArray((T[])new byte[0][]), null, BloomType.ROWCOL, 10000, new Configuration(TEST_UTIL.getConfiguration()));
        ArrayList<Object> pending = new ArrayList<Object>();
        for (i = 0; i < 1000; ++i) {
            row = Bytes.toBytes((String)("key" + Integer.toString(i)));
            put = new Put(row);
            put.addColumn(family, c3, val);
            put.addColumn(family, c4, val);
            put.addColumn(family, c5, val);
            put.addColumn(family, c6, val);
            put.addColumn(family, c7, val);
            put.addColumn(family, c8, val);
            put.addColumn(family, c12, val);
            put.addColumn(family, c13, val);
            put.addColumn(family, c15, val);
            pending.add(put);
            del = new Delete(row);
            del.addColumns(family, c2);
            del.addColumns(family, c9);
            del.addColumns(family, c10);
            del.addColumns(family, c14);
            pending.add(del);
        }
        ht.batch(pending, new Object[pending.size()]);
        TEST_UTIL.flush();
        TEST_UTIL.compact(true);
        for (i = 20; i < 300; ++i) {
            row = Bytes.toBytes((String)("key" + Integer.toString(i)));
            put = new Put(row);
            put.addColumn(family, c3, val);
            put.addColumn(family, c4, val);
            put.addColumn(family, c5, val);
            put.addColumn(family, c6, val);
            put.addColumn(family, c7, val);
            put.addColumn(family, c8, val);
            put.addColumn(family, c12, val);
            put.addColumn(family, c13, val);
            put.addColumn(family, c15, val);
            pending.add(put);
            del = new Delete(row);
            del.addColumns(family, c2);
            del.addColumns(family, c9);
            del.addColumns(family, c10);
            del.addColumns(family, c14);
            pending.add(del);
        }
        ht.batch(pending, new Object[pending.size()]);
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.addColumn(family, c9);
        scan.addColumn(family, c15);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(family, c15, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(c15));
        scan.setFilter((Filter)filter);
        for (Result result : ht.getScanner(scan)) {
            result.advance();
        }
        ht.close();
    }
}

