/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHdfsSnapshotHRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHdfsSnapshotHRegion.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final String SNAPSHOT_NAME = "foo_snapshot";
    private Table table;
    public static final TableName TABLE_NAME = TableName.valueOf((String)"foo");
    public static final byte[] FAMILY = Bytes.toBytes((String)"f1");
    private DFSClient client;
    private String baseDir;

    @Before
    public void setUp() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(1);
        this.table = TEST_UTIL.createMultiRegionTable(TABLE_NAME, FAMILY);
        TEST_UTIL.loadTable(this.table, FAMILY);
        this.client = new DFSClient(TEST_UTIL.getDFSCluster().getURI(), TEST_UTIL.getConfiguration());
        String fullUrIPath = TEST_UTIL.getDefaultRootDirPath().toString();
        String uriString = TEST_UTIL.getTestFileSystem().getUri().toString();
        this.baseDir = StringUtils.removeStart((String)fullUrIPath, (String)uriString);
        this.client.allowSnapshot(this.baseDir);
    }

    @After
    public void tearDown() throws Exception {
        this.client.deleteSnapshot(this.baseDir, SNAPSHOT_NAME);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testOpeningReadOnlyRegionBasic() throws Exception {
        String snapshotDir = this.client.createSnapshot(this.baseDir, SNAPSHOT_NAME);
        RegionInfo firstRegion = ((HRegionLocation)TEST_UTIL.getConnection().getRegionLocator(this.table.getName()).getAllRegionLocations().stream().findFirst().get()).getRegion();
        Path tableDir = CommonFSUtils.getTableDir((Path)new Path(snapshotDir), (TableName)TABLE_NAME);
        HRegion snapshottedRegion = this.openSnapshotRegion(firstRegion, tableDir);
        Assert.assertNotNull((Object)snapshottedRegion);
        snapshottedRegion.close();
    }

    @Test
    public void testSnapshottingWithTmpSplitsAndMergeDirectoriesPresent() throws Exception {
        RegionInfo firstRegion = ((HRegionLocation)TEST_UTIL.getConnection().getRegionLocator(this.table.getName()).getAllRegionLocations().stream().findFirst().get()).getRegion();
        String encodedName = firstRegion.getEncodedName();
        Path tableDir = CommonFSUtils.getTableDir((Path)TEST_UTIL.getDefaultRootDirPath(), (TableName)TABLE_NAME);
        Path regionDirectoryPath = new Path(tableDir, encodedName);
        TEST_UTIL.getTestFileSystem().create(new Path(regionDirectoryPath, ".tmp"));
        TEST_UTIL.getTestFileSystem().create(new Path(regionDirectoryPath, ".splits"));
        TEST_UTIL.getTestFileSystem().create(new Path(regionDirectoryPath, ".merges"));
        String snapshotDir = this.client.createSnapshot(this.baseDir, SNAPSHOT_NAME);
        HRegion snapshottedRegion = this.openSnapshotRegion(firstRegion, CommonFSUtils.getTableDir((Path)new Path(snapshotDir), (TableName)TABLE_NAME));
        Assert.assertNotNull((Object)snapshottedRegion);
        snapshottedRegion.close();
    }

    private HRegion openSnapshotRegion(RegionInfo firstRegion, Path tableDir) throws IOException {
        return HRegion.openReadOnlyFileSystemHRegion((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)TEST_UTIL.getTestFileSystem(), (Path)tableDir, (RegionInfo)firstRegion, (TableDescriptor)this.table.getDescriptor());
    }
}

