/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeSet;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.PreviousBlockCompressionRatePredicator;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.io.hfile.UncompressedBlockSizePredicator;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHStoreFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHStoreFile.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHStoreFile.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
    private static Path ROOT_DIR = TEST_UTIL.getDataTestDir("TestStoreFile");
    private static final ChecksumType CKTYPE = ChecksumType.CRC32C;
    private static final int CKBYTES = 512;
    private static String TEST_FAMILY = "cf";
    private static final char FIRST_CHAR = 'a';
    private static final char LAST_CHAR = 'z';
    @Rule
    public TestName name = new TestName();
    private Configuration conf;
    private Path testDir;
    private FileSystem fs;
    byte[] SPLITKEY = new byte[]{109, 97};
    private static final String localFormatter = "%010d";
    private static final int BLOCKSIZE_SMALL = 8192;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.testDir = TEST_UTIL.getDataTestDir(this.name.getMethodName());
        this.fs = this.testDir.getFileSystem(this.conf);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testBasicHalfAndHFileLinkMapFile() throws Exception {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"testBasicHalfAndHFileLinkMapFile")).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)CommonFSUtils.getTableDir((Path)CommonFSUtils.getRootDir((Configuration)this.conf), (TableName)hri.getTable()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path sfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        HStoreFile sf = new HStoreFile(this.fs, sfPath, this.conf, this.cacheConf, BloomType.NONE, true);
        this.checkHalfHFile(regionFs, sf);
    }

    private void writeStoreFile(StoreFileWriter writer) throws IOException {
        TestHStoreFile.writeStoreFile(writer, Bytes.toBytes((String)this.name.getMethodName()), Bytes.toBytes((String)this.name.getMethodName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStoreFile(StoreFileWriter writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append((Cell)new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLargeStoreFile(StoreFileWriter writer, byte[] fam, byte[] qualifier, int rounds) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        try {
            for (int i = 0; i < rounds; ++i) {
                for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                    for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                        byte[] b = new byte[]{(byte)d, (byte)e};
                        byte[] key = new byte[]{(byte)i};
                        writer.append((Cell)new KeyValue(key, fam, qualifier, now, b));
                    }
                }
            }
        }
        finally {
            writer.close();
        }
    }

    @Test
    public void testReference() throws IOException {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"testReferenceTb")).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)new Path(this.testDir, hri.getTable().getNameAsString()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path hsfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        HStoreFile hsf = new HStoreFile(this.fs, hsfPath, this.conf, this.cacheConf, BloomType.NONE, true);
        hsf.initReader();
        StoreFileReader reader = hsf.getReader();
        byte[] midRow = CellUtil.cloneRow((Cell)((Cell)reader.midKey().get()));
        byte[] finalRow = CellUtil.cloneRow((Cell)((Cell)reader.getLastKey().get()));
        hsf.closeStoreFile(true);
        RegionInfo splitHri = RegionInfoBuilder.newBuilder((TableName)hri.getTable()).setEndKey(midRow).build();
        Path refPath = this.splitStoreFile(regionFs, splitHri, TEST_FAMILY, hsf, midRow, true);
        HStoreFile refHsf = new HStoreFile(this.fs, refPath, this.conf, this.cacheConf, BloomType.NONE, true);
        refHsf.initReader();
        HFileScanner s = refHsf.getReader().getScanner(false, false);
        KeyValue kv = null;
        boolean first = true;
        while (!s.isSeeked() && s.seekTo() || s.next()) {
            ByteBuffer bb = ByteBuffer.wrap(((KeyValue)s.getKey()).getKey());
            kv = KeyValueUtil.createKeyValueFromKey((ByteBuffer)bb);
            if (!first) continue;
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])midRow, (int)0, (int)midRow.length));
            first = false;
        }
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])finalRow, (int)0, (int)finalRow.length));
    }

    @Test
    public void testStoreFileReference() throws Exception {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"testStoreFileReference")).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)new Path(this.testDir, hri.getTable().getNameAsString()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path hsfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        writer.close();
        HStoreFile file = new HStoreFile(this.fs, hsfPath, this.conf, this.cacheConf, BloomType.NONE, true);
        file.initReader();
        StoreFileReader r = file.getReader();
        Assert.assertNotNull((Object)r);
        StoreFileScanner scanner = new StoreFileScanner(r, (HFileScanner)Mockito.mock(HFileScanner.class), false, false, 0L, 0L, false);
        Assert.assertTrue((String)"Verify file is being referenced", (boolean)file.isReferencedInReads());
        scanner.close();
        Assert.assertFalse((String)"Verify file is not being referenced", (boolean)file.isReferencedInReads());
    }

    @Test
    public void testEmptyStoreFileRestrictKeyRanges() throws Exception {
        StoreFileReader reader = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        HStore store = (HStore)Mockito.mock(HStore.class);
        byte[] cf = Bytes.toBytes((String)"ty");
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])cf);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)cfd);
        try (StoreFileScanner scanner = new StoreFileScanner(reader, (HFileScanner)Mockito.mock(HFileScanner.class), false, false, 0L, 0L, true);){
            Scan scan = new Scan();
            scan.setColumnFamilyTimeRange(cf, 0L, 1L);
            Assert.assertFalse((boolean)scanner.shouldUseScanner(scan, store, 0L));
        }
    }

    @Test
    public void testHFileLink() throws IOException {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"testHFileLinkTb")).build();
        Configuration testConf = new Configuration(this.conf);
        CommonFSUtils.setRootDir((Configuration)testConf, (Path)this.testDir);
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)this.fs, (Path)CommonFSUtils.getTableDir((Path)this.testDir, (TableName)hri.getTable()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path storeFilePath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        Path dstPath = new Path(regionFs.getTableDir(), new Path("test-region", TEST_FAMILY));
        HFileLink.create((Configuration)testConf, (FileSystem)this.fs, (Path)dstPath, (RegionInfo)hri, (String)storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName((RegionInfo)hri, (String)storeFilePath.getName()));
        StoreFileInfo storeFileInfo = new StoreFileInfo(testConf, this.fs, linkFilePath, true);
        HStoreFile hsf = new HStoreFile(storeFileInfo, BloomType.NONE, this.cacheConf);
        Assert.assertTrue((boolean)storeFileInfo.isLink());
        hsf.initReader();
        int count = 1;
        HFileScanner s = hsf.getReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        Assert.assertEquals((long)676L, (long)count);
    }

    @Test
    public void testReferenceToHFileLink() throws IOException {
        Configuration testConf = new Configuration(this.conf);
        CommonFSUtils.setRootDir((Configuration)testConf, (Path)this.testDir);
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"_original-evil-name")).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)this.fs, (Path)CommonFSUtils.getTableDir((Path)this.testDir, (TableName)hri.getTable()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(testConf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path storeFilePath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        RegionInfo hriClone = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"clone")).build();
        HRegionFileSystem cloneRegionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)this.fs, (Path)CommonFSUtils.getTableDir((Path)this.testDir, (TableName)hri.getTable()), (RegionInfo)hriClone);
        Path dstPath = cloneRegionFs.getStoreDir(TEST_FAMILY);
        HFileLink.create((Configuration)testConf, (FileSystem)this.fs, (Path)dstPath, (RegionInfo)hri, (String)storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName((RegionInfo)hri, (String)storeFilePath.getName()));
        RegionInfo splitHriA = RegionInfoBuilder.newBuilder((TableName)hri.getTable()).setEndKey(this.SPLITKEY).build();
        RegionInfo splitHriB = RegionInfoBuilder.newBuilder((TableName)hri.getTable()).setStartKey(this.SPLITKEY).build();
        HStoreFile f = new HStoreFile(this.fs, linkFilePath, testConf, this.cacheConf, BloomType.NONE, true);
        f.initReader();
        Path pathA = this.splitStoreFile(cloneRegionFs, splitHriA, TEST_FAMILY, f, this.SPLITKEY, true);
        Path pathB = this.splitStoreFile(cloneRegionFs, splitHriB, TEST_FAMILY, f, this.SPLITKEY, false);
        f.closeStoreFile(true);
        CommonFSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.testDir, (Logger)LOG);
        HStoreFile hsfA = new HStoreFile(this.fs, pathA, testConf, this.cacheConf, BloomType.NONE, true);
        hsfA.initReader();
        int count = 1;
        HFileScanner s = hsfA.getReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        HStoreFile hsfB = new HStoreFile(this.fs, pathB, testConf, this.cacheConf, BloomType.NONE, true);
        hsfB.initReader();
        HFileScanner sB = hsfB.getReader().getScanner(false, false);
        sB.seekTo();
        ++count;
        while (sB.next()) {
            ++count;
        }
        Assert.assertEquals((long)676L, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHalfHFile(HRegionFileSystem regionFs, HStoreFile f) throws IOException {
        f.initReader();
        Cell midkey = (Cell)f.getReader().midKey().get();
        KeyValue midKV = (KeyValue)midkey;
        byte[] midRow = CellUtil.cloneRow((Cell)midKV);
        RegionInfo topHri = RegionInfoBuilder.newBuilder((TableName)regionFs.getRegionInfo().getTable()).setEndKey(this.SPLITKEY).build();
        Path topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, midRow, true);
        RegionInfo bottomHri = RegionInfoBuilder.newBuilder((TableName)regionFs.getRegionInfo().getTable()).setStartKey(this.SPLITKEY).build();
        Path bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, midRow, false);
        HStoreFile topF = new HStoreFile(this.fs, topPath, this.conf, this.cacheConf, BloomType.NONE, true);
        topF.initReader();
        StoreFileReader top = topF.getReader();
        HStoreFile bottomF = new HStoreFile(this.fs, bottomPath, this.conf, this.cacheConf, BloomType.NONE, true);
        bottomF.initReader();
        StoreFileReader bottom = bottomF.getReader();
        ByteBuffer previous = null;
        LOG.info("Midkey: " + midKV.toString());
        ByteBuffer bbMidkeyBytes = ByteBuffer.wrap(midKV.getKey());
        try {
            int i;
            String tmp;
            KeyValue keyKV;
            boolean first = true;
            ByteBuffer key = null;
            HFileScanner topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                key = ByteBuffer.wrap(((KeyValue)topScanner.getKey()).getKey());
                if (PrivateCellUtil.compare((CellComparator)topScanner.getReader().getComparator(), (Cell)midKV, (byte[])key.array(), (int)key.arrayOffset(), (int)key.limit()) > 0) {
                    Assert.fail((String)("key=" + Bytes.toStringBinary((ByteBuffer)key) + " < midkey=" + midkey));
                }
                if (!first) continue;
                first = false;
                LOG.info("First in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key)));
            }
            LOG.info("Last in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key)));
            first = true;
            HFileScanner bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                previous = ByteBuffer.wrap(((KeyValue)bottomScanner.getKey()).getKey());
                key = ByteBuffer.wrap(((KeyValue)bottomScanner.getKey()).getKey());
                if (first) {
                    first = false;
                    LOG.info("First in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous)));
                }
                Assert.assertTrue((key.compareTo(bbMidkeyBytes) < 0 ? 1 : 0) != 0);
            }
            if (previous != null) {
                LOG.info("Last in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous)));
            }
            regionFs.cleanupDaughterRegion(topHri);
            regionFs.cleanupDaughterRegion(bottomHri);
            byte[] badmidkey = Bytes.toBytes((String)"  .");
            Assert.assertTrue((boolean)this.fs.exists(f.getPath()));
            topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, badmidkey, true);
            bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, badmidkey, false);
            Assert.assertNull((Object)bottomPath);
            topF = new HStoreFile(this.fs, topPath, this.conf, this.cacheConf, BloomType.NONE, true);
            topF.initReader();
            top = topF.getReader();
            first = true;
            topScanner = top.getScanner(false, false);
            KeyValue.KeyOnlyKeyValue keyOnlyKV = new KeyValue.KeyOnlyKeyValue();
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.next()) {
                key = ByteBuffer.wrap(((KeyValue)topScanner.getKey()).getKey());
                keyOnlyKV.setKey(key.array(), 0 + key.arrayOffset(), key.limit());
                Assert.assertTrue((PrivateCellUtil.compare((CellComparator)topScanner.getReader().getComparator(), (Cell)keyOnlyKV, (byte[])badmidkey, (int)0, (int)badmidkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
                LOG.info("First top when key < bottom: " + keyKV);
                tmp = Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength());
                for (i = 0; i < tmp.length(); ++i) {
                    Assert.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
            LOG.info("Last top when key < bottom: " + keyKV);
            tmp = Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength());
            for (i = 0; i < tmp.length(); ++i) {
                Assert.assertTrue((tmp.charAt(i) == 'z' ? 1 : 0) != 0);
            }
            regionFs.cleanupDaughterRegion(topHri);
            regionFs.cleanupDaughterRegion(bottomHri);
            badmidkey = Bytes.toBytes((String)"|||");
            topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, badmidkey, true);
            bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, badmidkey, false);
            Assert.assertNull((Object)topPath);
            bottomF = new HStoreFile(this.fs, bottomPath, this.conf, this.cacheConf, BloomType.NONE, true);
            bottomF.initReader();
            bottom = bottomF.getReader();
            first = true;
            bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                key = ByteBuffer.wrap(((KeyValue)bottomScanner.getKey()).getKey());
                if (!first) continue;
                first = false;
                keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
                LOG.info("First bottom when key > top: " + keyKV);
                tmp = Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength());
                for (i = 0; i < tmp.length(); ++i) {
                    Assert.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
            LOG.info("Last bottom when key > top: " + keyKV);
            for (i = 0; i < tmp.length(); ++i) {
                Assert.assertTrue((Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength()).charAt(i) == 'z' ? 1 : 0) != 0);
            }
        }
        finally {
            if (top != null) {
                top.close(true);
            }
            if (bottom != null) {
                bottom.close(true);
            }
            this.fs.delete(f.getPath(), true);
        }
    }

    private static StoreFileScanner getStoreFileScanner(StoreFileReader reader, boolean cacheBlocks, boolean pread) {
        return reader.getStoreFileScanner(cacheBlocks, pread, false, 0L, 0L, false);
    }

    private void bloomWriteRead(StoreFileWriter writer, FileSystem fs) throws Exception {
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = writer.getPath();
        long now = EnvironmentEdgeManager.currentTime();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"col"), now, Bytes.toBytes((String)"value"));
            writer.append((Cell)kv);
        }
        writer.close();
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, f).build();
        StoreFileInfo storeFileInfo = new StoreFileInfo(this.conf, fs, f, true);
        storeFileInfo.initHFileInfo(context);
        StoreFileReader reader = storeFileInfo.createReader(context, this.cacheConf);
        storeFileInfo.getHFileInfo().initMetaAndIndex(reader.getHFileReader());
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, false, false);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            columns.add(Bytes.toBytes((String)"family:col"));
            Scan scan = new Scan().withStartRow(Bytes.toBytes((String)row)).withStopRow(Bytes.toBytes((String)row), true);
            scan.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"family:col"));
            HStore store = (HStore)Mockito.mock(HStore.class);
            Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
            boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close(true);
        fs.delete(f, true);
        Assert.assertEquals((String)("False negatives: " + falseNeg), (long)0L, (long)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        Assert.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos + ")"), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    @Test
    public void testBloomFilter() throws Exception {
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        if (!this.fs.exists(ROOT_DIR)) {
            this.fs.mkdirs(ROOT_DIR);
        }
        Path f = StoreFileWriter.getUniqueFile((FileSystem)this.fs, (Path)ROOT_DIR);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withBloomType(BloomType.ROW).withMaxKeyCount(2000L).withFileContext(meta).build();
        this.bloomWriteRead(writer, this.fs);
    }

    @Test
    public void testDeleteFamilyBloomFilter() throws Exception {
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        if (!this.fs.exists(ROOT_DIR)) {
            this.fs.mkdirs(ROOT_DIR);
        }
        Path f = StoreFileWriter.getUniqueFile((FileSystem)this.fs, (Path)ROOT_DIR);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withMaxKeyCount(2000L).withFileContext(meta).build();
        long now = EnvironmentEdgeManager.currentTime();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"col"), now, KeyValue.Type.DeleteFamily, Bytes.toBytes((String)"value"));
            writer.append((Cell)kv);
        }
        writer.close();
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(this.fs, f).build();
        StoreFileInfo storeFileInfo = new StoreFileInfo(this.conf, this.fs, f, true);
        storeFileInfo.initHFileInfo(context);
        StoreFileReader reader = storeFileInfo.createReader(context, this.cacheConf);
        storeFileInfo.getHFileInfo().initMetaAndIndex(reader.getHFileReader());
        reader.loadFileInfo();
        reader.loadBloomfilter();
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            byte[] rowKey = Bytes.toBytes((String)row);
            boolean exists = reader.passesDeleteFamilyBloomFilter(rowKey, 0, rowKey.length);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        Assert.assertEquals((long)1000L, (long)reader.getDeleteFamilyCnt());
        reader.close(true);
        this.fs.delete(f, true);
        Assert.assertEquals((String)("False negatives: " + falseNeg), (long)0L, (long)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        Assert.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    @Test
    public void testReseek() throws Exception {
        if (!this.fs.exists(ROOT_DIR)) {
            this.fs.mkdirs(ROOT_DIR);
        }
        Path f = StoreFileWriter.getUniqueFile((FileSystem)this.fs, (Path)ROOT_DIR);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withFileContext(meta).build();
        this.writeStoreFile(writer);
        writer.close();
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(this.fs, f).build();
        StoreFileInfo storeFileInfo = new StoreFileInfo(this.conf, this.fs, f, true);
        storeFileInfo.initHFileInfo(context);
        StoreFileReader reader = storeFileInfo.createReader(context, this.cacheConf);
        storeFileInfo.getHFileInfo().initMetaAndIndex(reader.getHFileReader());
        KeyValue k = KeyValueUtil.createFirstOnRow((byte[])HConstants.EMPTY_BYTE_ARRAY);
        StoreFileScanner s = TestHStoreFile.getStoreFileScanner(reader, false, false);
        s.reseek((Cell)k);
        Assert.assertNotNull((String)"Intial reseek should position at the beginning of the file", (Object)s.peek());
    }

    @Test
    public void testBloomTypes() throws Exception {
        float err = 0.01f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        int rowCount = 50;
        int colCount = 10;
        int versions = 2;
        BloomType[] bt = new BloomType[]{BloomType.ROWCOL, BloomType.ROW};
        int[] expKeys = new int[]{rowCount * colCount, rowCount};
        float[] expErr = new float[]{(float)(2 * rowCount * colCount) * err, (float)(2 * rowCount * 2 * colCount) * err};
        if (!fs.exists(ROOT_DIR)) {
            fs.mkdirs(ROOT_DIR);
        }
        for (int x : new int[]{0, 1}) {
            Path f = StoreFileWriter.getUniqueFile((FileSystem)fs, (Path)ROOT_DIR);
            HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
            StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withBloomType(bt[x]).withMaxKeyCount((long)expKeys[x]).withFileContext(meta).build();
            long now = EnvironmentEdgeManager.currentTime();
            for (int i = 0; i < rowCount * 2; i += 2) {
                for (int j = 0; j < colCount * 2; j += 2) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    for (int k = 0; k < versions; ++k) {
                        KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)("col" + col)), now - (long)k, Bytes.toBytes((long)-1L));
                        writer.append((Cell)kv);
                    }
                }
            }
            writer.close();
            ReaderContext context = new ReaderContextBuilder().withFilePath(f).withFileSize(fs.getFileStatus(f).getLen()).withFileSystem((FileSystem)fs).withInputStreamWrapper(new FSDataInputStreamWrapper((FileSystem)fs, f)).build();
            StoreFileInfo storeFileInfo = new StoreFileInfo(this.conf, (FileSystem)fs, f, true);
            storeFileInfo.initHFileInfo(context);
            StoreFileReader reader = storeFileInfo.createReader(context, this.cacheConf);
            storeFileInfo.getHFileInfo().initMetaAndIndex(reader.getHFileReader());
            reader.loadFileInfo();
            reader.loadBloomfilter();
            StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, false, false);
            Assert.assertEquals((long)expKeys[x], (long)reader.getGeneralBloomFilter().getKeyCount());
            HStore store = (HStore)Mockito.mock(HStore.class);
            Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < rowCount * 2; ++i) {
                for (int j = 0; j < colCount * 2; ++j) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                    columns.add(Bytes.toBytes((String)("col" + col)));
                    Scan scan = new Scan().withStartRow(Bytes.toBytes((String)row)).withStopRow(Bytes.toBytes((String)row), true);
                    scan.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)("col" + col)));
                    boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
                    boolean shouldRowExist = i % 2 == 0;
                    boolean shouldColExist = j % 2 == 0;
                    boolean bl = shouldColExist = shouldColExist || bt[x] == BloomType.ROW;
                    if (shouldRowExist && shouldColExist) {
                        if (exists) continue;
                        ++falseNeg;
                        continue;
                    }
                    if (!exists) continue;
                    ++falsePos;
                }
            }
            reader.close(true);
            fs.delete(f, true);
            System.out.println(bt[x].toString());
            System.out.println("  False negatives: " + falseNeg);
            System.out.println("  False positives: " + falsePos);
            Assert.assertEquals((long)0L, (long)falseNeg);
            Assert.assertTrue(((float)falsePos < 2.0f * expErr[x] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSeqIdComparator() {
        this.assertOrdering(StoreFileComparators.SEQ_ID, this.mockStoreFile(true, 100L, 1000L, -1L, "/foo/123"), this.mockStoreFile(true, 100L, 1000L, -1L, "/foo/124"), this.mockStoreFile(true, 99L, 1000L, -1L, "/foo/126"), this.mockStoreFile(true, 98L, 2000L, -1L, "/foo/126"), this.mockStoreFile(false, 3453L, -1L, 1L, "/foo/1"), this.mockStoreFile(false, 2L, -1L, 3L, "/foo/2"), this.mockStoreFile(false, 1000L, -1L, 5L, "/foo/2"), this.mockStoreFile(false, 76L, -1L, 5L, "/foo/3"));
    }

    private void assertOrdering(Comparator<? super HStoreFile> comparator, HStoreFile ... sfs) {
        ArrayList sorted = Lists.newArrayList((Object[])sfs);
        Collections.shuffle(sorted);
        Collections.sort(sorted, comparator);
        LOG.debug("sfs: " + Joiner.on((String)",").join((Object[])sfs));
        LOG.debug("sorted: " + Joiner.on((String)",").join((Iterable)sorted));
        Assert.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(sfs), (Iterable)sorted));
    }

    private HStoreFile mockStoreFile(boolean bulkLoad, long size, long bulkTimestamp, long seqId, String path) {
        HStoreFile mock = (HStoreFile)Mockito.mock(HStoreFile.class);
        StoreFileReader reader = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        ((StoreFileReader)Mockito.doReturn((Object)size).when((Object)reader)).length();
        ((HStoreFile)Mockito.doReturn((Object)reader).when((Object)mock)).getReader();
        ((HStoreFile)Mockito.doReturn((Object)bulkLoad).when((Object)mock)).isBulkLoadResult();
        ((HStoreFile)Mockito.doReturn((Object)OptionalLong.of(bulkTimestamp)).when((Object)mock)).getBulkLoadTimestamp();
        ((HStoreFile)Mockito.doReturn((Object)seqId).when((Object)mock)).getMaxSequenceId();
        ((HStoreFile)Mockito.doReturn((Object)new Path(path)).when((Object)mock)).getPath();
        String name = "mock storefile, bulkLoad=" + bulkLoad + " bulkTimestamp=" + bulkTimestamp + " seqId=" + seqId + " path=" + path;
        ((HStoreFile)Mockito.doReturn((Object)name).when((Object)mock)).toString();
        return mock;
    }

    List<KeyValue> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            LOG.info(Bytes.toString((byte[])b));
            LOG.info(Bytes.toString((byte[])b));
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    @Test
    public void testMultipleTimestamps() throws IOException {
        byte[] family = Bytes.toBytes((String)"familyname");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        int numRows = 10;
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        Path storedir = new Path(new Path(this.testDir, "7e0102"), Bytes.toString((byte[])family));
        Path dir = new Path(storedir, "1234567890");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withOutputDir(dir).withFileContext(meta).build();
        List<KeyValue> kvList = this.getKeyValueSet(timestamps, numRows, qualifier, family);
        for (KeyValue kv : kvList) {
            writer.append((Cell)kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        HStoreFile hsf = new HStoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE, true);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((byte[])family));
        hsf.initReader();
        StoreFileReader reader = hsf.getReader();
        StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, false, false);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qualifier);
        scan.setTimeRange(20L, 100L);
        Assert.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan.setTimeRange(1L, 2L);
        Assert.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan.setTimeRange(8L, 10L);
        Assert.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan.setColumnFamilyTimeRange(family, 7L, 50L);
        Assert.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan = new Scan();
        scan.setTimeRange(27L, 50L);
        Assert.assertTrue((!scanner.shouldUseScanner(scan, store, Long.MIN_VALUE) ? 1 : 0) != 0);
        scan = new Scan();
        scan.setTimeRange(27L, 50L);
        scan.setColumnFamilyTimeRange(family, 7L, 50L);
        Assert.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
    }

    @Test
    public void testCacheOnWriteEvictOnClose() throws Exception {
        Configuration conf = this.conf;
        Path baseDir = new Path(new Path(this.testDir, "7e0102"), "twoCOWEOC");
        BlockCache bc = BlockCacheFactory.createBlockCache((Configuration)conf);
        Assert.assertNotNull((Object)bc);
        CacheStats cs = bc.getStats();
        long startHit = cs.getHitCount();
        long startMiss = cs.getMissCount();
        long startEvicted = cs.getEvictedCount();
        conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        CacheConfig cacheConf = new CacheConfig(conf, bc);
        Path pathCowOff = new Path(baseDir, "123456789");
        StoreFileWriter writer = this.writeStoreFile(conf, cacheConf, pathCowOff, 3);
        HStoreFile hsf = new HStoreFile(this.fs, writer.getPath(), conf, cacheConf, BloomType.NONE, true);
        LOG.debug(hsf.getPath().toString());
        hsf.initReader();
        StoreFileReader reader = hsf.getReader();
        reader.loadFileInfo();
        StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, true, true);
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        Assert.assertEquals((long)startHit, (long)cs.getHitCount());
        Assert.assertEquals((long)(startMiss + 3L), (long)cs.getMissCount());
        Assert.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startMiss += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        cacheConf = new CacheConfig(conf, bc);
        Path pathCowOn = new Path(baseDir, "123456788");
        writer = this.writeStoreFile(conf, cacheConf, pathCowOn, 3);
        hsf = new HStoreFile(this.fs, writer.getPath(), conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        reader = hsf.getReader();
        scanner = TestHStoreFile.getStoreFileScanner(reader, true, true);
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        Assert.assertEquals((long)(startHit + 3L), (long)cs.getHitCount());
        Assert.assertEquals((long)startMiss, (long)cs.getMissCount());
        Assert.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        hsf = new HStoreFile(this.fs, pathCowOff, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        StoreFileReader readerOne = hsf.getReader();
        readerOne.loadFileInfo();
        StoreFileScanner scannerOne = TestHStoreFile.getStoreFileScanner(readerOne, true, true);
        scannerOne.seek((Cell)KeyValue.LOWESTKEY);
        hsf = new HStoreFile(this.fs, pathCowOn, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        StoreFileReader readerTwo = hsf.getReader();
        readerTwo.loadFileInfo();
        StoreFileScanner scannerTwo = TestHStoreFile.getStoreFileScanner(readerTwo, true, true);
        scannerTwo.seek((Cell)KeyValue.LOWESTKEY);
        Cell kv1 = null;
        Cell kv2 = null;
        while ((kv1 = scannerOne.next()) != null) {
            kv2 = scannerTwo.next();
            Assert.assertTrue((boolean)kv1.equals(kv2));
            KeyValue keyv1 = KeyValueUtil.ensureKeyValue((Cell)kv1);
            KeyValue keyv2 = KeyValueUtil.ensureKeyValue((Cell)kv2);
            Assert.assertTrue((Bytes.compareTo((byte[])keyv1.getBuffer(), (int)keyv1.getKeyOffset(), (int)keyv1.getKeyLength(), (byte[])keyv2.getBuffer(), (int)keyv2.getKeyOffset(), (int)keyv2.getKeyLength()) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((Bytes.compareTo((byte[])kv1.getValueArray(), (int)kv1.getValueOffset(), (int)kv1.getValueLength(), (byte[])kv2.getValueArray(), (int)kv2.getValueOffset(), (int)kv2.getValueLength()) == 0 ? 1 : 0) != 0);
        }
        Assert.assertNull((Object)scannerTwo.next());
        Assert.assertEquals((long)(startHit + 6L), (long)cs.getHitCount());
        Assert.assertEquals((long)startMiss, (long)cs.getMissCount());
        Assert.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 6L;
        scannerOne.close();
        readerOne.close(cacheConf.shouldEvictOnClose());
        scannerTwo.close();
        readerTwo.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        cacheConf = new CacheConfig(conf, bc);
        hsf = new HStoreFile(this.fs, pathCowOff, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        reader = hsf.getReader();
        reader.close(cacheConf.shouldEvictOnClose());
        Assert.assertEquals((long)startHit, (long)cs.getHitCount());
        Assert.assertEquals((long)startMiss, (long)cs.getMissCount());
        Assert.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        conf.setBoolean("hbase.rs.evictblocksonclose", false);
        cacheConf = new CacheConfig(conf, bc);
        hsf = new HStoreFile(this.fs, pathCowOn, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        reader = hsf.getReader();
        reader.close(cacheConf.shouldEvictOnClose());
        Assert.assertEquals((long)startHit, (long)cs.getHitCount());
        Assert.assertEquals((long)startMiss, (long)cs.getMissCount());
        Assert.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
    }

    private Path splitStoreFile(HRegionFileSystem regionFs, RegionInfo hri, String family, HStoreFile sf, byte[] splitKey, boolean isTopRef) throws IOException {
        Path path = regionFs.splitStoreFile(hri, family, sf, splitKey, isTopRef, null);
        if (null == path) {
            return null;
        }
        ArrayList<Path> splitFiles = new ArrayList<Path>();
        splitFiles.add(path);
        MasterProcedureEnv mockEnv = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        MasterServices mockServices = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)mockEnv.getMasterServices()).thenReturn((Object)mockServices);
        Mockito.when((Object)mockEnv.getMasterConfiguration()).thenReturn((Object)new Configuration());
        TableDescriptors mockTblDescs = (TableDescriptors)Mockito.mock(TableDescriptors.class);
        Mockito.when((Object)mockServices.getTableDescriptors()).thenReturn((Object)mockTblDescs);
        TableDescriptor mockTblDesc = TableDescriptorBuilder.newBuilder((TableName)hri.getTable()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)family)).build();
        Mockito.when((Object)mockTblDescs.get((TableName)ArgumentMatchers.any())).thenReturn((Object)mockTblDesc);
        Path regionDir = regionFs.commitDaughterRegion(hri, splitFiles, mockEnv);
        return new Path(new Path(regionDir, family), path.getName());
    }

    private StoreFileWriter writeStoreFile(Configuration conf, CacheConfig cacheConf, Path path, int numBlocks) throws IOException {
        int numKVs = 5 * numBlocks;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(numKVs);
        byte[] b = Bytes.toBytes((String)"x");
        int totalSize = 0;
        for (int i = numKVs; i > 0; --i) {
            KeyValue kv = new KeyValue(b, b, b, (long)i, b);
            kvs.add(kv);
            totalSize += kv.getLength() + 1;
        }
        int blockSize = totalSize / numBlocks;
        HFileContext meta = new HFileContextBuilder().withBlockSize(blockSize).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(conf, cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        kvs.remove(kvs.size() - 1);
        for (KeyValue kv : kvs) {
            writer.append((Cell)kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        return writer;
    }

    @Test
    public void testDataBlockEncodingMetaData() throws IOException {
        Path dir = new Path(new Path(this.testDir, "7e0102"), "familyname");
        Path path = new Path(dir, "1234567890");
        DataBlockEncoding dataBlockEncoderAlgo = DataBlockEncoding.FAST_DIFF;
        this.cacheConf = new CacheConfig(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).withDataBlockEncoding(dataBlockEncoderAlgo).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        writer.close();
        HStoreFile storeFile = new HStoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE, true);
        storeFile.initReader();
        StoreFileReader reader = storeFile.getReader();
        Map fileInfo = reader.loadFileInfo();
        byte[] value = (byte[])fileInfo.get(HFileDataBlockEncoder.DATA_BLOCK_ENCODING);
        Assert.assertArrayEquals((byte[])dataBlockEncoderAlgo.getNameInBytes(), (byte[])value);
    }

    @Test
    public void testDataBlockSizeEncoded() throws Exception {
        Path dir = new Path(new Path(this.testDir, "7e0102"), "familyname");
        Path path = new Path(dir, "1234567890");
        DataBlockEncoding dataBlockEncoderAlgo = DataBlockEncoding.FAST_DIFF;
        this.conf.setDouble("hbase.writer.unified.encoded.blocksize.ratio", 1.0);
        this.cacheConf = new CacheConfig(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).withDataBlockEncoding(dataBlockEncoderAlgo).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        this.writeStoreFile(writer);
        HStoreFile storeFile = new HStoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE, true);
        storeFile.initReader();
        StoreFileReader reader = storeFile.getReader();
        Map fileInfo = reader.loadFileInfo();
        byte[] value = (byte[])fileInfo.get(HFileDataBlockEncoder.DATA_BLOCK_ENCODING);
        Assert.assertEquals((Object)dataBlockEncoderAlgo.name(), (Object)Bytes.toString((byte[])value));
        HFile.Reader fReader = HFile.createReader((FileSystem)this.fs, (Path)writer.getPath(), (CacheConfig)storeFile.getCacheConf(), (boolean)true, (Configuration)this.conf);
        FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(this.fs, writer.getPath());
        long fileSize = this.fs.getFileStatus(writer.getPath()).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream((FSDataInputStream)fsdis.getStream(false), (long)fileSize);
        long offset = trailer.getFirstDataBlockOffset();
        long max = trailer.getLastDataBlockOffset();
        while (offset <= max) {
            HFileBlock block = fReader.readBlock(offset, -1L, false, false, false, false, null, null);
            double diff = block.getOnDiskSizeWithHeader() - 8192;
            if ((offset += (long)block.getOnDiskSizeWithHeader()) > max) continue;
            Assert.assertTrue((diff >= 0.0 && diff < 409.6 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDataBlockSizeCompressed() throws Exception {
        this.conf.set("hbase.block.compressed.size.predicator", PreviousBlockCompressionRatePredicator.class.getName());
        this.testDataBlockSizeWithCompressionRatePredicator(12, (s, c) -> c > 2 && c < 11 ? s >= 81920 : true);
    }

    @Test
    public void testDataBlockSizeUnCompressed() throws Exception {
        this.conf.set("hbase.block.compressed.size.predicator", UncompressedBlockSizePredicator.class.getName());
        this.testDataBlockSizeWithCompressionRatePredicator(200, (s, c) -> s < 81920);
    }

    private void testDataBlockSizeWithCompressionRatePredicator(int expectedBlockCount, BiFunction<Integer, Integer, Boolean> validation) throws Exception {
        HFileBlock block;
        Path dir = new Path(new Path(this.testDir, "7e0102"), "familyname");
        Path path = new Path(dir, "1234567890");
        DataBlockEncoding dataBlockEncoderAlgo = DataBlockEncoding.FAST_DIFF;
        this.cacheConf = new CacheConfig(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).withDataBlockEncoding(dataBlockEncoderAlgo).withCompression(Compression.Algorithm.GZ).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        TestHStoreFile.writeLargeStoreFile(writer, Bytes.toBytes((String)this.name.getMethodName()), Bytes.toBytes((String)this.name.getMethodName()), 200);
        writer.close();
        HStoreFile storeFile = new HStoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE, true);
        storeFile.initReader();
        HFile.Reader fReader = HFile.createReader((FileSystem)this.fs, (Path)writer.getPath(), (CacheConfig)storeFile.getCacheConf(), (boolean)true, (Configuration)this.conf);
        FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(this.fs, writer.getPath());
        long fileSize = this.fs.getFileStatus(writer.getPath()).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream((FSDataInputStream)fsdis.getStream(false), (long)fileSize);
        long max = trailer.getLastDataBlockOffset();
        int blockCount = 0;
        for (long offset = trailer.getFirstDataBlockOffset(); offset <= max; offset += (long)block.getOnDiskSizeWithHeader()) {
            block = fReader.readBlock(offset, -1L, false, false, false, false, null, null);
            Assert.assertTrue((boolean)validation.apply(block.getUncompressedSizeWithoutHeader(), ++blockCount));
        }
        Assert.assertEquals((long)expectedBlockCount, (long)blockCount);
    }
}

