/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.TestWALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, LargeTests.class})
public class TestHRegionServerBulkLoad {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionServerBulkLoad.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionServerBulkLoad.class);
    protected static HBaseTestingUtil UTIL = new HBaseTestingUtil();
    protected static final Configuration conf = UTIL.getConfiguration();
    protected static final byte[] QUAL = Bytes.toBytes((String)"qual");
    protected static final int NUM_CFS = 10;
    private int sleepDuration;
    public static int BLOCKSIZE = 65536;
    public static Compression.Algorithm COMPRESSION = Compression.Algorithm.NONE;
    protected static final byte[][] families = new byte[10][];

    @Parameterized.Parameters
    public static final Collection<Object[]> parameters() {
        int[] sleepDurations = new int[]{0, 30000};
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (int i : sleepDurations) {
            configurations.add(new Object[]{i});
        }
        return configurations;
    }

    public TestHRegionServerBulkLoad(int duration) {
        this.sleepDuration = duration;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setInt("hbase.rpc.timeout", 10000);
    }

    public static byte[] rowkey(int i) {
        return Bytes.toBytes((String)String.format("row_%08d", i));
    }

    static String family(int i) {
        return String.format("family_%04d", i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHFile(FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] value, int numRows) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(BLOCKSIZE).withCompression(COMPRESSION).build();
        long now = EnvironmentEdgeManager.currentTime();
        try (HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)new CacheConfig(conf)).withPath(fs, path).withFileContext(context).create();){
            for (int i = 0; i < numRows; ++i) {
                KeyValue kv = new KeyValue(TestHRegionServerBulkLoad.rowkey(i), family, qualifier, now, value);
                writer.append((Cell)kv);
            }
            writer.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)now));
        }
    }

    public void setupTable(TableName table, int cfs) throws IOException {
        try {
            LOG.info("Creating table " + table);
            TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)table);
            tableDescriptorBuilder.setCoprocessor(MyObserver.class.getName());
            MyObserver.sleepDuration = this.sleepDuration;
            for (int i = 0; i < 10; ++i) {
                ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)TestHRegionServerBulkLoad.family(i))).build();
                tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
            }
            UTIL.getAdmin().createTable(tableDescriptorBuilder.build());
        }
        catch (TableExistsException tee) {
            LOG.info("Table " + table + " already exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicBulkLoad() throws Exception {
        TableName TABLE_NAME = TableName.valueOf((String)"atomicBulkLoad");
        int millisToRun = 30000;
        int numScanners = 50;
        UTIL.startMiniCluster(StartTestingClusterOption.builder().createWALDir(true).build());
        try {
            WAL log = UTIL.getHBaseCluster().getRegionServer(0).getWAL(null);
            FindBulkHBaseListener listener = new FindBulkHBaseListener();
            log.registerWALActionsListener((WALActionsListener)listener);
            this.runAtomicBulkloadTest(TABLE_NAME, millisToRun, numScanners);
            MatcherAssert.assertThat((Object)listener.isFound(), (Matcher)Is.is((Object)true));
        }
        finally {
            UTIL.shutdownMiniCluster();
        }
    }

    void runAtomicBulkloadTest(TableName tableName, int millisToRun, int numScanners) throws Exception {
        this.setupTable(tableName, 10);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(UTIL.getConfiguration());
        AtomicHFileLoader loader = new AtomicHFileLoader(tableName, ctx, (byte[][])null);
        ctx.addThread(loader);
        ArrayList scanners = Lists.newArrayList();
        for (int i = 0; i < numScanners; ++i) {
            AtomicScanReader scanner = new AtomicScanReader(tableName, ctx, families);
            scanners.add(scanner);
            ctx.addThread(scanner);
        }
        ctx.startThreads();
        ctx.waitFor(millisToRun);
        ctx.stop();
        LOG.info("Loaders:");
        LOG.info("  loaded " + loader.numBulkLoads.get());
        LOG.info("  compations " + loader.numCompactions.get());
        LOG.info("Scanners:");
        for (AtomicScanReader scanner : scanners) {
            LOG.info("  scanned " + scanner.numScans.get());
            LOG.info("  verified " + scanner.numRowsScanned.get() + " rows");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Configuration c = HBaseConfiguration.create();
            TestHRegionServerBulkLoad test = new TestHRegionServerBulkLoad(0);
            test.setConf(c);
            test.runAtomicBulkloadTest(TableName.valueOf((String)"atomicTableTest"), 300000, 50);
        }
        finally {
            System.exit(0);
        }
    }

    private void setConf(Configuration c) {
        UTIL = new HBaseTestingUtil(c);
    }

    static {
        for (int i = 0; i < 10; ++i) {
            TestHRegionServerBulkLoad.families[i] = Bytes.toBytes((String)TestHRegionServerBulkLoad.family(i));
        }
    }

    static class FindBulkHBaseListener
    extends TestWALActionsListener.DummyWALActionsListener {
        private boolean found = false;

        FindBulkHBaseListener() {
        }

        public void visitLogEntryBeforeWrite(RegionInfo info, WALKey logKey, WALEdit logEdit) {
            for (Cell cell : logEdit.getCells()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                for (Map.Entry entry : kv.toStringMap().entrySet()) {
                    if (!entry.getValue().equals(Bytes.toString((byte[])WALEdit.BULK_LOAD))) continue;
                    this.found = true;
                }
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }

    public static class AtomicScanReader
    extends MultithreadedTestUtil.RepeatingTestThread {
        byte[][] targetFamilies;
        Table table;
        AtomicLong numScans = new AtomicLong();
        AtomicLong numRowsScanned = new AtomicLong();
        TableName TABLE_NAME;

        public AtomicScanReader(TableName TABLE_NAME, MultithreadedTestUtil.TestContext ctx, byte[][] targetFamilies) throws IOException {
            super(ctx);
            this.TABLE_NAME = TABLE_NAME;
            this.targetFamilies = targetFamilies;
            this.table = UTIL.getConnection().getTable(TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            Scan s = new Scan();
            for (byte[] family : this.targetFamilies) {
                s.addFamily(family);
            }
            ResultScanner scanner = this.table.getScanner(s);
            for (Result res : scanner) {
                byte[] lastRow = null;
                byte[] lastFam = null;
                byte[] lastQual = null;
                byte[] gotValue = null;
                for (byte[] family : this.targetFamilies) {
                    byte[] qualifier = QUAL;
                    byte[] thisValue = res.getValue(family, qualifier);
                    if (gotValue != null && thisValue != null && !Bytes.equals(gotValue, (byte[])thisValue)) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Failed on scan ").append(this.numScans).append(" after scanning ").append(this.numRowsScanned).append(" rows!\n");
                        msg.append("Current  was " + Bytes.toString((byte[])res.getRow()) + "/" + Bytes.toString((byte[])family) + ":" + Bytes.toString((byte[])qualifier) + " = " + Bytes.toString((byte[])thisValue) + "\n");
                        msg.append("Previous  was " + Bytes.toString((byte[])lastRow) + "/" + Bytes.toString((byte[])lastFam) + ":" + Bytes.toString((byte[])lastQual) + " = " + Bytes.toString((byte[])gotValue));
                        throw new RuntimeException(msg.toString());
                    }
                    lastFam = family;
                    lastQual = qualifier;
                    lastRow = res.getRow();
                    gotValue = thisValue;
                }
                this.numRowsScanned.getAndIncrement();
            }
            this.numScans.getAndIncrement();
        }
    }

    public static class MyObserver
    implements RegionCoprocessor,
    RegionObserver {
        static int sleepDuration;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException ie) {
                InterruptedIOException ioe = new InterruptedIOException();
                ioe.initCause(ie);
                throw ioe;
            }
            return scanner;
        }
    }

    public static class AtomicHFileLoader
    extends MultithreadedTestUtil.RepeatingTestThread {
        final AtomicLong numBulkLoads = new AtomicLong();
        final AtomicLong numCompactions = new AtomicLong();
        private TableName tableName;

        public AtomicHFileLoader(TableName tableName, MultithreadedTestUtil.TestContext ctx, byte[][] targetFamilies) throws IOException {
            super(ctx);
            this.tableName = tableName;
        }

        @Override
        public void doAnAction() throws Exception {
            long iteration = this.numBulkLoads.getAndIncrement();
            Path dir = UTIL.getDataTestDirOnTestFS(String.format("bulkLoad_%08d", iteration));
            FileSystem fs = UTIL.getTestFileSystem();
            byte[] val = Bytes.toBytes((String)String.format("%010d", iteration));
            TreeMap<byte[], List<Path>> family2Files = new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR);
            for (int i = 0; i < 10; ++i) {
                Path hfile = new Path(dir, TestHRegionServerBulkLoad.family(i));
                byte[] fam = Bytes.toBytes((String)TestHRegionServerBulkLoad.family(i));
                TestHRegionServerBulkLoad.createHFile(fs, hfile, fam, QUAL, val, 1000);
                family2Files.put(fam, Collections.singletonList(hfile));
            }
            BulkLoadHFiles.create((Configuration)UTIL.getConfiguration()).bulkLoad(this.tableName, family2Files);
            Connection conn = UTIL.getConnection();
            if (this.numBulkLoads.get() % 5L == 0L) {
                try (RegionLocator locator = conn.getRegionLocator(this.tableName);){
                    HRegionLocation loc = locator.getRegionLocation(Bytes.toBytes((String)"aaa"), true);
                    conn.getAdmin().compactRegion(loc.getRegion().getRegionName());
                    this.numCompactions.incrementAndGet();
                }
            }
        }
    }
}

