/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.exceptions.verification.WantedButNotInvoked;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class})
public class TestFailedAppendAndSync {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFailedAppendAndSync.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFailedAppendAndSync.class);
    @Rule
    public TestName name = new TestName();
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    HRegion region = null;
    private static HBaseTestingUtil TEST_UTIL;
    public static Configuration CONF;
    private String dir;
    protected TableName tableName;

    @Before
    public void setup() throws IOException {
        TEST_UTIL = new HBaseTestingUtil();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setFloat("hfile.block.cache.size", 0.0f);
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info("Cleaning test directory: " + TEST_UTIL.getDataTestDir());
        TEST_UTIL.cleanupTestDir();
    }

    String getName() {
        return this.name.getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockupAroundBadAssignSync() throws IOException {
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)services.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)services.isAborted()).thenReturn((Object)false);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        DodgyFSLog dodgyWAL = new DodgyFSLog(fs, (Server)services, rootDir, this.getName(), CONF);
        dodgyWAL.init();
        LogRoller logRoller = new LogRoller(services);
        logRoller.addWAL((WAL)dodgyWAL);
        logRoller.start();
        boolean threwOnSync = false;
        boolean threwOnAppend = false;
        boolean threwOnBoth = false;
        HRegion region = TestFailedAppendAndSync.initHRegion(this.tableName, null, null, CONF, (WAL)dodgyWAL);
        try {
            Put put;
            byte[] value = Bytes.toBytes((String)this.getName());
            try {
                Put put2 = new Put(value);
                put2.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), value);
                region.put(put2);
            }
            catch (IOException ioe) {
                Assert.fail();
            }
            long rollsCount = dodgyWAL.rolls.get();
            try {
                dodgyWAL.throwAppendException = true;
                dodgyWAL.throwSyncException = false;
                put = new Put(value);
                put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"3"), value);
                region.put(put);
            }
            catch (IOException ioe) {
                threwOnAppend = true;
            }
            while (rollsCount == dodgyWAL.rolls.get()) {
                Threads.sleep((long)100L);
            }
            rollsCount = dodgyWAL.rolls.get();
            try {
                dodgyWAL.throwAppendException = true;
                dodgyWAL.throwSyncException = true;
                put = new Put(value);
                put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"4"), value);
                region.put(put);
            }
            catch (IOException ioe) {
                threwOnBoth = true;
            }
            while (rollsCount == dodgyWAL.rolls.get()) {
                Threads.sleep((long)100L);
            }
            ((RegionServerServices)Mockito.verify((Object)services, (VerificationMode)Mockito.atLeast((int)0))).abort(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any(Throwable.class));
            try {
                dodgyWAL.throwAppendException = false;
                dodgyWAL.throwSyncException = true;
                put = new Put(value);
                put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"2"), value);
                region.put(put);
            }
            catch (IOException ioe) {
                threwOnSync = true;
            }
            while (true) {
                try {
                    ((RegionServerServices)Mockito.verify((Object)services, (VerificationMode)Mockito.atLeast((int)1))).abort(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any(Throwable.class));
                }
                catch (WantedButNotInvoked t) {
                    Threads.sleep((long)1L);
                    continue;
                }
                break;
            }
            try {
                dodgyWAL.throwAppendException = false;
                dodgyWAL.throwSyncException = false;
                dodgyWAL.throwArchiveException = true;
                Pair pair = new Pair();
                pair.setFirst((Object)new Path("/a/b/"));
                pair.setSecond((Object)100L);
                dodgyWAL.archive((Pair<Path, Long>)pair);
            }
            catch (Throwable pair) {
                // empty catch block
            }
            while (true) {
                try {
                    ((RegionServerServices)Mockito.verify((Object)services, (VerificationMode)Mockito.atLeast((int)2))).abort(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
                }
                catch (WantedButNotInvoked t) {
                    Threads.sleep((long)1L);
                    continue;
                }
                break;
            }
        }
        finally {
            Mockito.when((Object)services.isStopped()).thenReturn((Object)true);
            if (logRoller != null) {
                logRoller.close();
            }
            if (region != null) {
                try {
                    region.close(true);
                }
                catch (DroppedSnapshotException e) {
                    LOG.info("On way out; expected!", (Throwable)e);
                }
            }
            if (dodgyWAL != null) {
                dodgyWAL.close();
            }
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwOnBoth);
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwOnAppend);
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwOnSync);
        }
    }

    public static HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, WAL wal) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, conf, false, Durability.SYNC_WAL, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }

    class DodgyFSLog
    extends FSHLog {
        volatile boolean throwSyncException;
        volatile boolean throwAppendException;
        volatile boolean throwArchiveException;
        final AtomicLong rolls;

        public DodgyFSLog(FileSystem fs, Server server, Path root, String logDir, Configuration conf) throws IOException {
            super(fs, (Abortable)server, root, logDir, conf);
            this.throwSyncException = false;
            this.throwAppendException = false;
            this.throwArchiveException = false;
            this.rolls = new AtomicLong(0L);
        }

        public Map<byte[], List<byte[]>> rollWriter(boolean force) throws FailedLogCloseException, IOException {
            Map regions = super.rollWriter(force);
            this.rolls.getAndIncrement();
            return regions;
        }

        protected void archiveLogFile(Path p) throws IOException {
            if (this.throwArchiveException) {
                throw new IOException("throw archival exception");
            }
        }

        protected void archive(Pair<Path, Long> localLogsToArchive) {
            super.archive(localLogsToArchive);
        }

        protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
            final WALProvider.Writer w = super.createWriterInstance(path);
            return new WALProvider.Writer(){

                public void close() throws IOException {
                    w.close();
                }

                public void sync(boolean forceSync) throws IOException {
                    if (DodgyFSLog.this.throwSyncException) {
                        throw new IOException("FAKE! Failed to replace a bad datanode...");
                    }
                    w.sync(forceSync);
                }

                public void append(WAL.Entry entry) throws IOException {
                    if (DodgyFSLog.this.throwAppendException) {
                        throw new IOException("FAKE! Failed to replace a bad datanode...");
                    }
                    w.append(entry);
                }

                public long getLength() {
                    return w.getLength();
                }

                public long getSyncedLength() {
                    return w.getSyncedLength();
                }
            };
        }
    }
}

