/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;

public class EncodedSeekPerformanceTest {
    private static final double NANOSEC_IN_SEC = 1.0E9;
    private static final double BYTES_IN_MEGABYTES = 1048576.0;
    public static int DEFAULT_NUMBER_OF_SEEKS = 10000;
    private final HBaseTestingUtil testingUtility = new HBaseTestingUtil();
    private Configuration configuration = this.testingUtility.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.configuration);
    private Random randomizer;
    private int numberOfSeeks;

    public EncodedSeekPerformanceTest() {
        this.configuration.setFloat("hfile.block.cache.size", 0.5f);
        this.randomizer = new Random(42L);
        this.numberOfSeeks = DEFAULT_NUMBER_OF_SEEKS;
    }

    private List<Cell> prepareListOfTestSeeks(Path path) throws IOException {
        Cell current;
        ArrayList<Cell> allKeyValues = new ArrayList<Cell>();
        HStoreFile storeFile = new HStoreFile(this.testingUtility.getTestFileSystem(), path, this.configuration, this.cacheConf, BloomType.NONE, true);
        storeFile.initReader();
        StoreFileReader reader = storeFile.getReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, false, false, 0L, 0L, false);
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        while (null != (current = scanner.next())) {
            allKeyValues.add(current);
        }
        storeFile.closeStoreFile(this.cacheConf.shouldEvictOnClose());
        ArrayList<Cell> seeks = new ArrayList<Cell>();
        for (int i = 0; i < this.numberOfSeeks; ++i) {
            Cell keyValue = (Cell)allKeyValues.get(this.randomizer.nextInt(allKeyValues.size()));
            seeks.add(keyValue);
        }
        this.clearBlockCache();
        return seeks;
    }

    private void runTest(Path path, DataBlockEncoding blockEncoding, List<Cell> seeks) throws IOException {
        long finishSeeksTime;
        Cell current;
        HStoreFile storeFile = new HStoreFile(this.testingUtility.getTestFileSystem(), path, this.configuration, this.cacheConf, BloomType.NONE, true);
        storeFile.initReader();
        long totalSize = 0L;
        StoreFileReader reader = storeFile.getReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, false, false, 0L, 0L, false);
        long startReadingTime = System.nanoTime();
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        while (null != (current = scanner.next())) {
            if (KeyValueUtil.ensureKeyValue((Cell)current).getLength() < 0) {
                throw new IOException("Negative KV size: " + current);
            }
            totalSize += (long)KeyValueUtil.ensureKeyValue((Cell)current).getLength();
        }
        long finishReadingTime = System.nanoTime();
        long startSeeksTime = System.nanoTime();
        for (Cell keyValue : seeks) {
            scanner.seek(keyValue);
            Cell toVerify = scanner.next();
            if (keyValue.equals(toVerify)) continue;
            System.out.println(String.format("KeyValue doesn't match:\nOrig key: %s\nRet key:  %s", KeyValueUtil.ensureKeyValue((Cell)keyValue).getKeyString(), KeyValueUtil.ensureKeyValue((Cell)toVerify).getKeyString()));
            break;
        }
        if ((finishSeeksTime = System.nanoTime()) < startSeeksTime) {
            throw new AssertionError((Object)("Finish time " + finishSeeksTime + " is earlier than start time " + startSeeksTime));
        }
        double readInMbPerSec = (double)totalSize * 1.0E9 / (1048576.0 * (double)(finishReadingTime - startReadingTime));
        double seeksPerSec = (double)seeks.size() * 1.0E9 / (double)(finishSeeksTime - startSeeksTime);
        storeFile.closeStoreFile(this.cacheConf.shouldEvictOnClose());
        this.clearBlockCache();
        System.out.println(blockEncoding);
        System.out.printf("  Read speed:       %8.2f (MB/s)\n", readInMbPerSec);
        System.out.printf("  Seeks per second: %8.2f (#/s)\n", seeksPerSec);
        System.out.printf("  Total KV size:    %d\n", totalSize);
    }

    public void runTests(Path path, DataBlockEncoding[] encodings) throws IOException {
        List<Cell> seeks = this.prepareListOfTestSeeks(path);
        for (DataBlockEncoding blockEncoding : encodings) {
            this.runTest(path, blockEncoding, seeks);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            EncodedSeekPerformanceTest.printUsage();
            System.exit(-1);
        }
        Path path = new Path(args[0]);
        EncodedSeekPerformanceTest utility = new EncodedSeekPerformanceTest();
        utility.runTests(path, DataBlockEncoding.values());
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println("Usage: one argument, name of the HFile");
    }

    private void clearBlockCache() {
        ((LruBlockCache)this.cacheConf.getBlockCache().get()).clearCache();
    }
}

