/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRegionSizeUse {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSizeUse.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionSizeUse.class);
    private static final int SIZE_PER_VALUE = 256;
    private static final int NUM_SPLITS = 10;
    private static final String F1 = "f1";
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private SingleProcessHBaseCluster cluster;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        this.cluster = TEST_UTIL.startMiniCluster(2);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testBasicRegionSizeReports() throws Exception {
        long bytesWritten = 0x500000L;
        TableName tn = this.writeData(0x500000L);
        LOG.debug("Data was written to HBase");
        Admin admin = TEST_UTIL.getAdmin();
        admin.flush(tn);
        LOG.debug("Data flushed to disk");
        List regions = TEST_UTIL.getAdmin().getRegions(tn);
        HMaster master = this.cluster.getMaster();
        MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        Map regionSizes = quotaManager.snapshotRegionSizes();
        int observedRegions = this.numRegionsForTable(tn, regionSizes);
        while (observedRegions < regions.size()) {
            LOG.debug("Expecting more regions. Saw " + observedRegions + " region sizes reported, expected at least " + regions.size());
            Thread.sleep(1000L);
            regionSizes = quotaManager.snapshotRegionSizes();
            observedRegions = this.numRegionsForTable(tn, regionSizes);
        }
        LOG.debug("Observed region sizes by the HMaster: " + regionSizes);
        long totalRegionSize = 0L;
        for (Long regionSize : regionSizes.values()) {
            totalRegionSize += regionSize.longValue();
        }
        Assert.assertTrue((String)("Expected region size report to exceed 5242880, but was " + totalRegionSize + ". RegionSizes=" + regionSizes), (0x500000L < totalRegionSize ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableName writeData(long sizeInBytes) throws IOException {
        TableName tn;
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tn);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)F1)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        admin.createTable(tableDescriptorBuilder.build(), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"9"), 10);
        try (Table table = conn.getTable(tn);){
            ArrayList<Put> updates = new ArrayList<Put>();
            long bytesToWrite = sizeInBytes;
            long rowKeyId = 0L;
            StringBuilder sb = new StringBuilder();
            while (bytesToWrite > 0L) {
                sb.setLength(0);
                sb.append(Long.toString(rowKeyId));
                Put p = new Put(Bytes.toBytes((String)sb.reverse().toString()));
                byte[] value = new byte[256];
                Bytes.random((byte[])value);
                p.addColumn(Bytes.toBytes((String)F1), Bytes.toBytes((String)"q1"), value);
                updates.add(p);
                if (updates.size() > 50) {
                    table.put(updates);
                    updates.clear();
                }
                bytesToWrite -= 256L;
                ++rowKeyId;
            }
            if (!updates.isEmpty()) {
                table.put(updates);
            }
            TableName tableName = tn;
            return tableName;
        }
    }

    private int numRegionsForTable(TableName tn, Map<RegionInfo, Long> regions) {
        int sum = 0;
        for (Map.Entry<RegionInfo, Long> entry : regions.entrySet()) {
            if (!tn.equals((Object)entry.getKey().getTable()) || 0L >= entry.getValue()) continue;
            ++sum;
        }
        return sum;
    }
}

