/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.procedure.SimpleMasterProcedureManager;
import org.apache.hadoop.hbase.procedure.SimpleRSProcedureManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestProcedureManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureManager.class);
    private static final int NUM_RS = 2;
    private static HBaseTestingUtil util = new HBaseTestingUtil();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.set("hbase.procedure.master.classes", SimpleMasterProcedureManager.class.getName());
        conf.set("hbase.procedure.regionserver.classes", SimpleRSProcedureManager.class.getName());
        util.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSimpleProcedureManager() throws IOException {
        Admin admin = util.getAdmin();
        byte[] result = admin.execProcedureWithReturn("simple_test", "mytest", new HashMap());
        Assert.assertArrayEquals((String)"Incorrect return data from execProcedure", (byte[])Bytes.toBytes((String)"simple_test_data"), (byte[])result);
    }
}

