/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.namequeues.TestNamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerPayload;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerTableAccessor;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALEventTrackerListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALEventTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALEventTracker.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNamedQueueRecorder.class);
    private static HBaseTestingUtil TEST_UTIL;
    public static Configuration CONF;

    @BeforeClass
    public static void setup() throws Exception {
        CONF = HBaseConfiguration.create();
        CONF.setBoolean("hbase.regionserver.wal.event.tracker.enabled", true);
        CONF.setInt("hbase.regionserver.named.queue.chore.duration", 900);
        CONF.setLong("wal.event.tracker.sleep.interval.msec", 100L);
        TEST_UTIL = new HBaseTestingUtil(CONF);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        LOG.info("Calling teardown");
        TEST_UTIL.shutdownMiniHBaseCluster();
    }

    @Before
    public void waitForWalEventTrackerTableCreation() {
        Waiter.waitFor((Configuration)CONF, (long)10000L, () -> TEST_UTIL.getAdmin().tableExists(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME));
    }

    @Test
    public void testWALRolling() throws Exception {
        Connection connection = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getConnection();
        this.waitForWALEventTrackerTable(connection);
        List wals = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getWALs();
        Assert.assertEquals((long)1L, (long)wals.size());
        AbstractFSWAL wal = (AbstractFSWAL)wals.get(0);
        Path wal1Path = wal.getOldPath();
        wal.rollWriter(true);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        long wal1Length = fs.getFileStatus(wal1Path).getLen();
        Path wal2Path = wal.getOldPath();
        String hostName = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName().getHostname();
        TEST_UTIL.waitFor(5000L, () -> this.getTableCount(connection) >= 3);
        List<WALEventTrackerPayload> walEventsList = this.getRows(hostName, connection);
        this.compareEvents(hostName, wal1Path.getName(), walEventsList, new ArrayList<String>(Arrays.asList(WALEventTrackerListener.WalState.ROLLING.name(), WALEventTrackerListener.WalState.ROLLED.name())), false);
        this.compareEvents(hostName, wal2Path.getName(), walEventsList, new ArrayList<String>(Arrays.asList(WALEventTrackerListener.WalState.ACTIVE.name())), true);
        this.checkWALRolledEventHasSize(walEventsList, wal1Path.getName(), wal1Length);
    }

    private void checkWALRolledEventHasSize(List<WALEventTrackerPayload> walEvents, String walName, long actualSize) {
        ArrayList<WALEventTrackerPayload> eventsFilteredByNameState = new ArrayList<WALEventTrackerPayload>();
        for (WALEventTrackerPayload event : walEvents) {
            if (!walName.equals(event.getWalName()) || !WALEventTrackerListener.WalState.ROLLED.name().equals(event.getState())) continue;
            eventsFilteredByNameState.add(event);
        }
        Assert.assertEquals((long)1L, (long)eventsFilteredByNameState.size());
    }

    private void compareEvents(String hostName, String walName, List<WALEventTrackerPayload> walEvents, List<String> expectedStates, boolean strict) {
        ArrayList<WALEventTrackerPayload> eventsFilteredByWalName = new ArrayList<WALEventTrackerPayload>();
        for (WALEventTrackerPayload event : walEvents) {
            Assert.assertEquals((Object)hostName, (Object)event.getRsName());
        }
        for (WALEventTrackerPayload event : walEvents) {
            if (!walName.equals(event.getWalName())) continue;
            eventsFilteredByWalName.add(event);
        }
        if (strict) {
            Assert.assertEquals((long)expectedStates.size(), (long)eventsFilteredByWalName.size());
        }
        for (WALEventTrackerPayload event : eventsFilteredByWalName) {
            expectedStates.remove(event.getState());
        }
        Assert.assertEquals((long)0L, (long)expectedStates.size());
    }

    private void waitForWALEventTrackerTable(Connection connection) throws IOException {
        TEST_UTIL.waitFor(5000L, () -> TEST_UTIL.getAdmin().tableExists(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME));
    }

    private List<WALEventTrackerPayload> getRows(String rowKeyPrefix, Connection connection) throws IOException {
        Result r;
        ArrayList<WALEventTrackerPayload> list = new ArrayList<WALEventTrackerPayload>();
        Scan scan = new Scan();
        scan.withStartRow(Bytes.toBytes((String)rowKeyPrefix));
        Table table = connection.getTable(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME);
        ResultScanner scanner = table.getScanner(scan);
        while ((r = scanner.next()) != null) {
            List cells = r.listCells();
            list.add(this.getPayload(cells));
        }
        return list;
    }

    private WALEventTrackerPayload getPayload(List<Cell> cells) {
        String rsName = null;
        String walName = null;
        String walState = null;
        long timestamp = 0L;
        long walLength = 0L;
        for (Cell cell : cells) {
            byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
            byte[] value = CellUtil.cloneValue((Cell)cell);
            String qualifierStr = Bytes.toString((byte[])qualifier);
            if ("region_server_name".equals(qualifierStr)) {
                rsName = Bytes.toString((byte[])value);
                continue;
            }
            if ("wal_name".equals(qualifierStr)) {
                walName = Bytes.toString((byte[])value);
                continue;
            }
            if ("wal_state".equals(qualifierStr)) {
                walState = Bytes.toString((byte[])value);
                continue;
            }
            if ("timestamp".equals(qualifierStr)) {
                timestamp = Bytes.toLong((byte[])value);
                continue;
            }
            if (!"wal_length".equals(qualifierStr)) continue;
            walLength = Bytes.toLong((byte[])value);
        }
        return new WALEventTrackerPayload(rsName, walName, timestamp, walState, walLength);
    }

    private int getTableCount(Connection connection) throws Exception {
        Table table = connection.getTable(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME);
        ResultScanner resultScanner = table.getScanner(new Scan().setReadType(Scan.ReadType.STREAM));
        int count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        LOG.info("Table count: " + count);
        return count;
    }
}

