/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.CachedMobFile;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMobFileCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobFileCache.class);
    private HBaseTestingUtil UTIL;
    private HRegion region;
    private Configuration conf;
    private MobFileCache mobFileCache;
    private Date currentDate = new Date();
    private static final String TEST_CACHE_SIZE = "2";
    private static final int EXPECTED_CACHE_SIZE_ZERO = 0;
    private static final int EXPECTED_CACHE_SIZE_ONE = 1;
    private static final int EXPECTED_CACHE_SIZE_TWO = 2;
    private static final int EXPECTED_CACHE_SIZE_THREE = 3;
    private static final long EXPECTED_REFERENCE_ONE = 1L;
    private static final long EXPECTED_REFERENCE_TWO = 2L;
    private static final String TABLE = "tableName";
    private static final String FAMILY1 = "family1";
    private static final String FAMILY2 = "family2";
    private static final String FAMILY3 = "family3";
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] VALUE2 = Bytes.toBytes((String)"value2");
    private static final byte[] QF1 = Bytes.toBytes((String)"qf1");
    private static final byte[] QF2 = Bytes.toBytes((String)"qf2");
    private static final byte[] QF3 = Bytes.toBytes((String)"qf3");

    @Before
    public void setUp() throws Exception {
        this.UTIL = new HBaseTestingUtil();
        this.conf = this.UTIL.getConfiguration();
        this.conf.set("hbase.mob.file.cache.size", TEST_CACHE_SIZE);
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)this.UTIL.createTableDescriptor(TableName.valueOf((String)"testMobFileCache"), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)FAMILY1)).setMobEnabled(true).setMobThreshold(0L).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)FAMILY2)).setMobEnabled(true).setMobThreshold(0L).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)FAMILY3)).setMobEnabled(true).setMobThreshold(0L).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        TableDescriptor tableDescriptor = tableDescriptorBuilder.build();
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableDescriptor.getTableName()).build();
        this.mobFileCache = new MobFileCache(this.conf);
        this.region = HBaseTestingUtil.createRegionAndWAL(regionInfo, this.UTIL.getDataTestDir(), this.conf, tableDescriptor, this.mobFileCache);
    }

    @After
    public void tearDown() throws Exception {
        this.region.close();
        this.region.getFilesystem().delete(this.UTIL.getDataTestDir(), true);
    }

    private Path createMobStoreFile(String family) throws IOException {
        return this.createMobStoreFile(HBaseConfiguration.create(), family);
    }

    private Path createMobStoreFile(Configuration conf, String family) throws IOException {
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)family)).setMaxVersions(4).setMobEnabled(true).build();
        return this.createMobStoreFile(columnFamilyDescriptor);
    }

    private Path createMobStoreFile(ColumnFamilyDescriptor columnFamilyDescriptor) throws IOException {
        TableName tn = TableName.valueOf((String)TABLE);
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tn);
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        HMobStore mobStore = (HMobStore)this.region.getStore(columnFamilyDescriptor.getName());
        KeyValue key1 = new KeyValue(ROW, columnFamilyDescriptor.getName(), QF1, 1L, VALUE);
        KeyValue key2 = new KeyValue(ROW, columnFamilyDescriptor.getName(), QF2, 1L, VALUE);
        KeyValue key3 = new KeyValue(ROW2, columnFamilyDescriptor.getName(), QF3, 1L, VALUE2);
        KeyValue[] keys = new KeyValue[]{key1, key2, key3};
        int maxKeyCount = keys.length;
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tn).build();
        StoreFileWriter mobWriter = mobStore.createWriterInTmp(this.currentDate, (long)maxKeyCount, columnFamilyDescriptor.getCompactionCompressionType(), regionInfo.getStartKey(), false);
        Path mobFilePath = mobWriter.getPath();
        String fileName = mobFilePath.getName();
        mobWriter.append((Cell)key1);
        mobWriter.append((Cell)key2);
        mobWriter.append((Cell)key3);
        mobWriter.close();
        String targetPathName = MobUtils.formatDate((Date)this.currentDate);
        Path targetPath = new Path(mobStore.getPath(), targetPathName);
        mobStore.commitFile(mobFilePath, targetPath);
        return new Path(targetPath, fileName);
    }

    @Test
    public void testMobFileCache() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path file1Path = this.createMobStoreFile(FAMILY1);
        Path file2Path = this.createMobStoreFile(FAMILY2);
        Path file3Path = this.createMobStoreFile(FAMILY3);
        CacheConfig cacheConf = new CacheConfig(this.conf);
        Assert.assertEquals((long)0L, (long)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile1 = (CachedMobFile)this.mobFileCache.openFile(fs, file1Path, cacheConf);
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        Assert.assertNotNull((Object)cachedMobFile1);
        Assert.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        this.mobFileCache.evict();
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        this.mobFileCache.evictFile(file1Path.getName());
        Assert.assertEquals((long)0L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)1L, (long)cachedMobFile1.getReferenceCount());
        cachedMobFile1.close();
        cachedMobFile1 = (CachedMobFile)this.mobFileCache.openFile(fs, file1Path, cacheConf);
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile2 = (CachedMobFile)this.mobFileCache.openFile(fs, file2Path, cacheConf);
        Assert.assertEquals((long)2L, (long)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile3 = (CachedMobFile)this.mobFileCache.openFile(fs, file3Path, cacheConf);
        Assert.assertEquals((long)3L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        Assert.assertEquals((long)2L, (long)cachedMobFile2.getReferenceCount());
        Assert.assertEquals((long)2L, (long)cachedMobFile3.getReferenceCount());
        this.mobFileCache.evict();
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)1L, (long)cachedMobFile1.getReferenceCount());
        Assert.assertEquals((long)1L, (long)cachedMobFile2.getReferenceCount());
        Assert.assertEquals((long)2L, (long)cachedMobFile3.getReferenceCount());
    }
}

