/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobFileCleanerChore;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.TestMobUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class})
public class TestMobCompactionWithDefaults {
    private static final Logger LOG = LoggerFactory.getLogger(TestMobCompactionWithDefaults.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCompactionWithDefaults.class);
    protected HBaseTestingUtil HTU;
    protected static Configuration conf;
    protected static long minAgeToArchive;
    protected static final String famStr = "f1";
    protected static final byte[] fam;
    protected static final byte[] qualifier;
    protected static final long mobLen = 10L;
    protected static final byte[] mobVal;
    @Rule
    public TestName test = new TestName();
    protected TableDescriptor tableDescriptor;
    private ColumnFamilyDescriptor familyDescriptor;
    protected Admin admin;
    protected TableName table = null;
    protected int numRegions = 20;
    protected int rows = 1000;
    protected MobFileCleanerChore cleanerChore;
    protected Boolean useFileBasedSFT;

    public TestMobCompactionWithDefaults(Boolean useFileBasedSFT) {
        this.useFileBasedSFT = useFileBasedSFT;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> data() {
        Boolean[] data = new Boolean[]{false, true};
        return Arrays.asList(data);
    }

    protected void htuStart() throws Exception {
        this.HTU = new HBaseTestingUtil();
        conf = this.HTU.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.setLong("hbase.mob.compaction.chore.period", 0L);
        conf.setLong("hbase.master.mob.cleaner.period", 0L);
        conf.setLong("hbase.mob.min.age.archive", minAgeToArchive);
        conf.setLong("hbase.hfile.compaction.discharger.interval", minAgeToArchive / 2L);
        conf.setBoolean("hbase.regionserver.compaction.enabled", false);
        if (this.useFileBasedSFT.booleanValue()) {
            conf.set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        }
        this.additonalConfigSetup();
        this.HTU.startMiniCluster();
    }

    protected void additonalConfigSetup() {
    }

    @Before
    public void setUp() throws Exception {
        this.htuStart();
        this.admin = this.HTU.getAdmin();
        this.cleanerChore = new MobFileCleanerChore();
        this.familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setMobEnabled(true).setMobThreshold(10L).setMaxVersions(1).build();
        this.tableDescriptor = this.HTU.createModifyableTableDescriptor(TestMobUtils.getTableName(this.test)).setColumnFamily(this.familyDescriptor).build();
        RegionSplitter.UniformSplit splitAlgo = new RegionSplitter.UniformSplit();
        byte[][] splitKeys = splitAlgo.split(this.numRegions);
        this.table = this.HTU.createTable(this.tableDescriptor, splitKeys).getName();
    }

    private void loadData(TableName tableName, int num) {
        LOG.info("Started loading {} rows into {}", (Object)num, (Object)tableName);
        try (Table table = this.HTU.getConnection().getTable(tableName);){
            for (int i = 0; i < num; ++i) {
                byte[] key = new byte[32];
                Bytes.random((byte[])key);
                Put p = new Put(key);
                p.addColumn(fam, qualifier, mobVal);
                table.put(p);
            }
            this.admin.flush(tableName);
            LOG.info("Finished loading {} rows into {}", (Object)num, (Object)tableName);
        }
        catch (Exception e) {
            LOG.error("MOB file compaction chore test FAILED", (Throwable)e);
            Assert.fail((String)"MOB file compaction chore test FAILED");
        }
    }

    @After
    public void tearDown() throws Exception {
        this.admin.disableTable(this.tableDescriptor.getTableName());
        this.admin.deleteTable(this.tableDescriptor.getTableName());
        this.HTU.shutdownMiniCluster();
    }

    @Test
    public void baseTestMobFileCompaction() throws InterruptedException, IOException {
        LOG.info("MOB compaction " + this.description() + " started");
        this.loadAndFlushThreeTimes(this.rows, this.table, famStr);
        this.mobCompact(this.tableDescriptor, this.familyDescriptor);
        Assert.assertEquals((String)"Should have 4 MOB files per region due to 3xflush + compaction.", (long)(this.numRegions * 4), (long)this.getNumberOfMobFiles(this.table, famStr));
        this.cleanupAndVerifyCounts(this.table, famStr, 3 * this.rows);
        LOG.info("MOB compaction " + this.description() + " finished OK");
    }

    @Test
    public void testMobFileCompactionAfterSnapshotClone() throws InterruptedException, IOException {
        TableName clone = TableName.valueOf((String)(TestMobUtils.getTableName(this.test) + "-clone"));
        LOG.info("MOB compaction of cloned snapshot, " + this.description() + " started");
        this.loadAndFlushThreeTimes(this.rows, this.table, famStr);
        LOG.debug("Taking snapshot and cloning table {}", (Object)this.table);
        this.admin.snapshot(TestMobUtils.getTableName(this.test), this.table);
        this.admin.cloneSnapshot(TestMobUtils.getTableName(this.test), clone);
        Assert.assertEquals((String)"Should have 3 hlinks per region in MOB area from snapshot clone", (long)(3 * this.numRegions), (long)this.getNumberOfMobFiles(clone, famStr));
        this.mobCompact(this.admin.getDescriptor(clone), this.familyDescriptor);
        Assert.assertEquals((String)"Should have 3 hlinks + 1 MOB file per region due to clone + compact", (long)(4 * this.numRegions), (long)this.getNumberOfMobFiles(clone, famStr));
        this.cleanupAndVerifyCounts(clone, famStr, 3 * this.rows);
        LOG.info("MOB compaction of cloned snapshot, " + this.description() + " finished OK");
    }

    @Test
    public void testMobFileCompactionAfterSnapshotCloneAndFlush() throws InterruptedException, IOException {
        TableName clone = TableName.valueOf((String)(TestMobUtils.getTableName(this.test) + "-clone"));
        LOG.info("MOB compaction of cloned snapshot after flush, " + this.description() + " started");
        this.loadAndFlushThreeTimes(this.rows, this.table, famStr);
        LOG.debug("Taking snapshot and cloning table {}", (Object)this.table);
        this.admin.snapshot(TestMobUtils.getTableName(this.test), this.table);
        this.admin.cloneSnapshot(TestMobUtils.getTableName(this.test), clone);
        Assert.assertEquals((String)"Should have 3 hlinks per region in MOB area from snapshot clone", (long)(3 * this.numRegions), (long)this.getNumberOfMobFiles(clone, famStr));
        this.loadAndFlushThreeTimes(this.rows, clone, famStr);
        this.mobCompact(this.admin.getDescriptor(clone), this.familyDescriptor);
        Assert.assertEquals((String)"Should have 7 MOB file per region due to clone + 3xflush + compact", (long)(7 * this.numRegions), (long)this.getNumberOfMobFiles(clone, famStr));
        this.cleanupAndVerifyCounts(clone, famStr, 6 * this.rows);
        LOG.info("MOB compaction of cloned snapshot w flush, " + this.description() + " finished OK");
    }

    protected void loadAndFlushThreeTimes(int rows, TableName table, String family) throws IOException {
        long start = this.getNumberOfMobFiles(table, family);
        this.loadData(table, rows);
        this.loadData(table, rows);
        this.loadData(table, rows);
        Assert.assertEquals((String)"Should have 3 more mob files per region from flushing.", (long)(start + (long)(this.numRegions * 3)), (long)this.getNumberOfMobFiles(table, family));
    }

    protected String description() {
        return "regular mode";
    }

    protected void enableCompactions() throws IOException {
        List serverList = this.admin.getRegionServers().stream().map(sn -> sn.getServerName()).collect(Collectors.toList());
        this.admin.compactionSwitch(true, serverList);
    }

    protected void disableCompactions() throws IOException {
        List serverList = this.admin.getRegionServers().stream().map(sn -> sn.getServerName()).collect(Collectors.toList());
        this.admin.compactionSwitch(false, serverList);
    }

    protected void mobCompact(TableDescriptor tableDescriptor, ColumnFamilyDescriptor familyDescriptor) throws IOException, InterruptedException {
        LOG.debug("Major compact MOB table " + tableDescriptor.getTableName());
        this.enableCompactions();
        this.mobCompactImpl(tableDescriptor, familyDescriptor);
        this.waitUntilCompactionIsComplete(tableDescriptor.getTableName());
        this.disableCompactions();
    }

    protected void mobCompactImpl(TableDescriptor tableDescriptor, ColumnFamilyDescriptor familyDescriptor) throws IOException, InterruptedException {
        this.admin.majorCompact(tableDescriptor.getTableName(), familyDescriptor.getName());
    }

    protected void waitUntilCompactionIsComplete(TableName table) throws IOException, InterruptedException {
        CompactionState state = this.admin.getCompactionState(table);
        while (state != CompactionState.NONE) {
            LOG.debug("Waiting for compaction on {} to complete. current state {}", (Object)table, (Object)state);
            Thread.sleep(100L);
            state = this.admin.getCompactionState(table);
        }
        LOG.debug("done waiting for compaction on {}", (Object)table);
    }

    protected void cleanupAndVerifyCounts(TableName table, String family, int rows) throws InterruptedException, IOException {
        LOG.info("Waiting for {}ms", (Object)(minAgeToArchive + 1000L));
        Thread.sleep(minAgeToArchive + 1000L);
        LOG.info("Cleaning up MOB files");
        for (ServerName sn : this.admin.getRegionServers()) {
            this.HTU.getMiniHBaseCluster().getRegionServer(sn).getRSMobFileCleanerChore().chore();
        }
        Assert.assertEquals((String)"After cleaning, we should have 1 MOB file per region based on size.", (long)this.numRegions, (long)this.getNumberOfMobFiles(table, family));
        LOG.debug("checking count of rows");
        long scanned = this.scanTable(table);
        Assert.assertEquals((String)("Got the wrong number of rows in table " + table + " cf " + family), (long)rows, (long)scanned);
    }

    protected long getNumberOfMobFiles(TableName tableName, String family) throws IOException {
        FileStatus[] stat;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)family);
        for (FileStatus st : stat = fs.listStatus(dir)) {
            LOG.debug("MOB Directory content: {}", (Object)st.getPath());
        }
        LOG.debug("MOB Directory content total files: {}", (Object)stat.length);
        return stat.length;
    }

    /*
     * Exception decompiling
     */
    protected long scanTable(TableName tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        minAgeToArchive = 10000L;
        fam = Bytes.toBytes((String)famStr);
        qualifier = Bytes.toBytes((String)"q1");
        mobVal = Bytes.toBytes((String)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
    }
}

