/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mob.FaultyMobStoreCompactor;
import org.apache.hadoop.hbase.mob.MobFileCleanerChore;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobStressToolRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MobStressToolRunner.class);
    private HBaseTestingUtil HTU;
    private static final String famStr = "f1";
    private static final byte[] fam = Bytes.toBytes((String)"f1");
    private static final byte[] qualifier = Bytes.toBytes((String)"q1");
    private static final long mobLen = 10L;
    private static final byte[] mobVal = Bytes.toBytes((String)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
    private Configuration conf;
    private TableDescriptor tableDescriptor;
    private ColumnFamilyDescriptor familyDescriptor;
    private Admin admin;
    private long count = 500000L;
    private double failureProb = 0.1;
    private Table table = null;
    private MobFileCleanerChore chore = new MobFileCleanerChore();
    private static volatile boolean run = true;

    public void init(Configuration conf, long numRows) throws IOException {
        this.conf = conf;
        this.count = numRows;
        this.initConf();
        this.printConf();
        Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
        this.admin = conn.getAdmin();
        this.familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setMobEnabled(true).setMobThreshold(10L).setMaxVersions(1).build();
        this.tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"testMobCompactTable")).setColumnFamily(this.familyDescriptor).build();
        if (this.admin.tableExists(this.tableDescriptor.getTableName())) {
            this.admin.disableTable(this.tableDescriptor.getTableName());
            this.admin.deleteTable(this.tableDescriptor.getTableName());
        }
        this.admin.createTable(this.tableDescriptor);
        this.table = conn.getTable(this.tableDescriptor.getTableName());
    }

    private void printConf() {
        LOG.info("Please ensure the following HBase configuration is set:");
        LOG.info("hfile.format.version=3");
        LOG.info("hbase.master.hfilecleaner.ttl=0");
        LOG.info("hbase.hregion.max.filesize=200000000");
        LOG.info("hbase.client.retries.number=100");
        LOG.info("hbase.hregion.memstore.flush.size=800000");
        LOG.info("hbase.hstore.blockingStoreFiles=150");
        LOG.info("hbase.hstore.compaction.throughput.lower.bound=50000000");
        LOG.info("hbase.hstore.compaction.throughput.higher.bound=100000000");
        LOG.info("hbase.master.mob.cleaner.period=0");
        LOG.info("hbase.mob.default.compactor=org.apache.hadoop.hbase.mob.FaultyMobStoreCompactor");
        LOG.warn("hbase.mob.compaction.fault.probability=x, where x is between 0. and 1.");
    }

    private void initConf() {
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setLong("hbase.master.hfilecleaner.ttl", 0L);
        this.conf.setInt("hbase.client.retries.number", 100);
        this.conf.setInt("hbase.hregion.max.filesize", 200000000);
        this.conf.setInt("hbase.hregion.memstore.flush.size", 800000);
        this.conf.setInt("hbase.hstore.blockingStoreFiles", 150);
        this.conf.setInt("hbase.hstore.compaction.throughput.lower.bound", 0x3200000);
        this.conf.setInt("hbase.hstore.compaction.throughput.higher.bound", 0x6400000);
        this.conf.setDouble("hbase.mob.compaction.fault.probability", this.failureProb);
        this.conf.setLong("hbase.mob.compaction.chore.period", 0L);
        this.conf.setLong("hbase.master.mob.cleaner.period", 0L);
        this.conf.setLong("hbase.mob.min.age.archive", 120000L);
        this.conf.set("hbase.mob.compaction.type", "optimized");
        this.conf.setLong("hbase.mob.compactions.max.file.size", 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStressTest() throws InterruptedException, IOException {
        try {
            Thread writeData = new Thread(new WriteData(this.count));
            writeData.start();
            Thread majorcompact = new Thread(new MajorCompaction());
            majorcompact.start();
            Thread cleaner = new Thread(new CleanMobAndArchive());
            cleaner.start();
            while (run) {
                Thread.sleep(1000L);
            }
            this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
            LOG.info("Waiting for write thread to finish ...");
            writeData.join();
            this.chore.cleanupObsoleteMobFiles(this.conf, this.table.getName());
            this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
            if (this.HTU != null) {
                LOG.info("Archive cleaner started ...");
                this.HTU.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
                LOG.info("Archive cleaner finished");
            }
            this.scanTable();
        }
        finally {
            this.admin.disableTable(this.tableDescriptor.getTableName());
            this.admin.deleteTable(this.tableDescriptor.getTableName());
        }
        LOG.info("MOB Stress Test finished OK");
        this.printStats(this.count);
    }

    private long getNumberOfMobFiles(Configuration conf, TableName tableName, String family) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)family);
        FileStatus[] stat = fs.listStatus(dir);
        long size = 0L;
        for (FileStatus st : stat) {
            LOG.debug("MOB Directory content: {} len={}", (Object)st.getPath(), (Object)st.getLen());
            size += st.getLen();
        }
        LOG.debug("MOB Directory content total files: {}, total size={}", (Object)stat.length, (Object)size);
        return stat.length;
    }

    public void printStats(long loaded) {
        LOG.info("MOB Stress Test: loaded=" + loaded + " compactions=" + FaultyMobStoreCompactor.totalCompactions.get() + " major=" + FaultyMobStoreCompactor.totalMajorCompactions.get() + " mob=" + FaultyMobStoreCompactor.mobCounter.get() + " injected failures=" + FaultyMobStoreCompactor.totalFailures.get());
    }

    private void scanTable() {
        try {
            Result result;
            ResultScanner scanner = this.table.getScanner(fam);
            int counter = 0;
            while ((result = scanner.next()) != null) {
                byte[] key = result.getRow();
                Assert.assertTrue((boolean)Arrays.equals(result.getValue(fam, qualifier), Bytes.add((byte[])key, (byte[])mobVal)));
                if (counter % 10000 == 0) {
                    LOG.info("GET=" + counter + " key=" + Bytes.toInt((byte[])key));
                }
                ++counter;
            }
            Assert.assertEquals((long)this.count, (long)counter);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("MOB Stress Test FAILED");
            if (this.HTU != null) {
                Assert.assertTrue((boolean)false);
            }
            System.exit(-1);
        }
    }

    class WriteData
    implements Runnable {
        private long rows = -1L;

        public WriteData(long rows) {
            this.rows = rows;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while ((long)i < this.rows) {
                    byte[] key = Bytes.toBytes((int)i);
                    Put p = new Put(key);
                    p.addColumn(fam, qualifier, Bytes.add((byte[])key, (byte[])mobVal));
                    MobStressToolRunner.this.table.put(p);
                    if (i % 10000 == 0) {
                        LOG.info("LOADED=" + i);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (i % 100000 == 0) {
                        MobStressToolRunner.this.printStats(i);
                    }
                    ++i;
                }
                MobStressToolRunner.this.admin.flush(MobStressToolRunner.this.table.getName());
                run = false;
            }
            catch (Exception e) {
                LOG.error("MOB Stress Test FAILED", (Throwable)e);
                System.exit(-1);
            }
        }
    }

    class CleanMobAndArchive
    implements Runnable {
        CleanMobAndArchive() {
        }

        @Override
        public void run() {
            while (run) {
                try {
                    LOG.info("MOB cleanup chore started ...");
                    MobStressToolRunner.this.chore.cleanupObsoleteMobFiles(MobStressToolRunner.this.conf, MobStressToolRunner.this.table.getName());
                    LOG.info("MOB cleanup chore finished");
                    Thread.sleep(130000L);
                }
                catch (Exception e) {
                    LOG.error("CleanMobAndArchive", (Throwable)e);
                }
            }
        }
    }

    class MajorCompaction
    implements Runnable {
        MajorCompaction() {
        }

        @Override
        public void run() {
            while (run) {
                try {
                    MobStressToolRunner.this.admin.majorCompact(MobStressToolRunner.this.tableDescriptor.getTableName(), fam);
                    Thread.sleep(120000L);
                }
                catch (Exception e) {
                    LOG.error("MOB Stress Test FAILED", (Throwable)e);
                    System.exit(-1);
                }
            }
        }
    }
}

