/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.MasterStateStoreTestBase;
import org.apache.hadoop.hbase.master.snapshot.SnapshotCleanupStateStore;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotCleanupProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotCleanupStateStore
extends MasterStateStoreTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotCleanupStateStore.class);

    @After
    public void tearDown() throws Exception {
        TestSnapshotCleanupStateStore.cleanup();
        ZKUtil.deleteNodeFailSilent((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)TestSnapshotCleanupStateStore.UTIL.getZooKeeperWatcher().getZNodePaths().snapshotCleanupZNode);
    }

    @Test
    public void testReadWrite() throws Exception {
        SnapshotCleanupStateStore store = new SnapshotCleanupStateStore(REGION, UTIL.getZooKeeperWatcher());
        Assert.assertTrue((boolean)store.get());
        store.set(false);
        Assert.assertFalse((boolean)store.get());
        store = new SnapshotCleanupStateStore(REGION, UTIL.getZooKeeperWatcher());
        Assert.assertFalse((boolean)store.get());
        store.set(true);
        Assert.assertTrue((boolean)store.get());
    }

    @Test
    public void testMigrate() throws Exception {
        byte[] zkData = ProtobufUtil.prependPBMagic((byte[])SnapshotCleanupProtos.SnapshotCleanupState.newBuilder().setSnapshotCleanupEnabled(false).build().toByteArray());
        ZKUtil.createSetData((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)TestSnapshotCleanupStateStore.UTIL.getZooKeeperWatcher().getZNodePaths().snapshotCleanupZNode, (byte[])zkData);
        SnapshotCleanupStateStore store = new SnapshotCleanupStateStore(REGION, UTIL.getZooKeeperWatcher());
        Assert.assertFalse((boolean)store.get());
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)TestSnapshotCleanupStateStore.UTIL.getZooKeeperWatcher().getZNodePaths().snapshotCleanupZNode));
    }
}

