/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.replication.TransitPeerSyncReplicationStateProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTransitPeerSyncReplicationStateProcedureRetry
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTransitPeerSyncReplicationStateProcedureRetry.class);

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL2.getConfiguration().setInt("hbase.master.procedure.threads", 1);
        SyncReplicationTestBase.setUp();
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 0, 100);
        Thread.sleep(2000L);
        this.verifyNotReplicatedThroughRegion(UTIL2, 0, 100);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        HMaster master = UTIL2.getHBaseCluster().getMaster();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning((ProcedureExecutor)procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)true);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        t.start();
        UTIL2.waitFor(30000L, () -> procExec.getProcedures().stream().anyMatch(p -> p instanceof TransitPeerSyncReplicationStateProcedure && !p.isFinished()));
        long procId = procExec.getProcedures().stream().filter(p -> p instanceof TransitPeerSyncReplicationStateProcedure && !p.isFinished()).mapToLong(Procedure::getProcId).min().getAsLong();
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution((ProcedureExecutor<MasterProcedureEnv>)procExec, procId);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)false);
        Assert.assertEquals((Object)SyncReplicationState.DOWNGRADE_ACTIVE, (Object)UTIL2.getAdmin().getReplicationPeerSyncReplicationState(PEER_ID));
        this.verify(UTIL2, 0, 100);
    }
}

